/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.util.security;

import com.sun.management.viperimpl.util.security.CertificateStore;
import com.sun.management.viperimpl.util.security.DeniedCertificateStore;
import com.sun.management.viperimpl.util.security.RootCACertificateStore;
import com.sun.management.viperimpl.util.security.SMCCertificateStore;
import com.sun.management.viperimpl.util.security.SessionCertificateStore;
import com.sun.management.viperimpl.util.security.TrustDeciderDialog;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SMCX509TrustManager
implements X509TrustManager {
    private X509TrustManager trustManager = null;
    private static CertificateStore rootStore = null;
    private static CertificateStore permanentStore = null;
    private static CertificateStore sessionStore = null;
    private static CertificateStore deniedStore = null;

    public static void reset() {
        rootStore = new RootCACertificateStore();
        permanentStore = new SMCCertificateStore();
        sessionStore = new SessionCertificateStore();
        deniedStore = new DeniedCertificateStore();
    }

    public SMCX509TrustManager() throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
        tmf.init(rootStore.getKeyStore());
        TrustManager[] tmArray = tmf.getTrustManagers();
        this.trustManager = (X509TrustManager)tmArray[0];
    }

    public synchronized void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
    }

    public synchronized void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        boolean rootCANotValid = false;
        boolean timeNotValid = false;
        int result = 1;
        try {
            rootStore.load();
            permanentStore.load();
            sessionStore.load();
            deniedStore.load();
            if (deniedStore.contains(chain[0])) {
                throw new CertificateException("Certificate has been denied");
            }
            try {
                this.trustManager.checkServerTrusted(chain, authType);
                return;
            }
            catch (CertificateException e) {
                if (sessionStore.contains(chain[0])) {
                    return;
                }
                if (permanentStore.contains(chain[0])) {
                    return;
                }
                for (int i = 0; i < chain.length; ++i) {
                    if (!rootStore.verify(chain[i])) {
                        rootCANotValid = true;
                    }
                    try {
                        chain[i].checkValidity();
                        continue;
                    }
                    catch (CertificateExpiredException e1) {
                        timeNotValid = true;
                        continue;
                    }
                    catch (CertificateNotYetValidException e2) {
                        timeNotValid = true;
                    }
                }
                String rv = System.getProperty("com.sun.smc.security.gui");
                if (rv != null && rv.equals("yes")) {
                    try {
                        boolean theRootCANotValid = rootCANotValid;
                        boolean theTimeNotValid = timeNotValid;
                        TrustDeciderDialog dialog = new TrustDeciderDialog(chain, 0, chain.length, theRootCANotValid, theTimeNotValid);
                        result = dialog.DoModal();
                    }
                    catch (Exception e2) {}
                } else {
                    result = 0;
                }
                if (result == 0) {
                    sessionStore.add(chain[0]);
                    sessionStore.save();
                } else if (result == 2) {
                    permanentStore.add(chain[0]);
                    permanentStore.save();
                } else {
                    deniedStore.add(chain[0]);
                    deniedStore.save();
                }
            }
        }
        catch (CertificateException ce) {
            throw ce;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (result != 0 && result != 2) {
            throw new CertificateException("SMC Console couldn't trust Server");
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    static {
        SMCX509TrustManager.reset();
    }
}

