/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.util.security;

import com.sun.management.viperimpl.util.security.CertificateStore;
import com.sun.management.viperimpl.util.security.SMCSSLConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;

public class SMCCertificateStore
implements CertificateStore {
    private static String _filename = null;
    private static char[] _storepass = null;
    private KeyStore _deploymentcerts = null;

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        try {
            if (this._deploymentcerts == null) {
                this._deploymentcerts = KeyStore.getInstance("JKS");
                this._deploymentcerts.load(null, null);
            }
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    File file = new File(_filename);
                    if (file.exists()) {
                        FileInputStream fis = new FileInputStream(file);
                        BufferedInputStream bis = new BufferedInputStream(fis);
                        SMCCertificateStore.this._deploymentcerts.load(bis, _storepass);
                        bis.close();
                        fis.close();
                    }
                    return null;
                }
            });
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof CertificateException) {
                throw (CertificateException)ex;
            }
            if (ex instanceof KeyStoreException) {
                throw (KeyStoreException)ex;
            }
            if (ex instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)ex;
            }
            ex.printStackTrace();
        }
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    FileOutputStream fos = new FileOutputStream(new File(_filename));
                    BufferedOutputStream bos = new BufferedOutputStream(fos);
                    SMCCertificateStore.this._deploymentcerts.store(bos, _storepass);
                    bos.close();
                    fos.close();
                    return null;
                }
            });
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof CertificateException) {
                throw (CertificateException)ex;
            }
            if (ex instanceof KeyStoreException) {
                throw (KeyStoreException)ex;
            }
            if (ex instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)ex;
            }
            ex.printStackTrace();
        }
    }

    public void add(Certificate cert) throws KeyStoreException {
        if (!this.contains(cert)) {
            Random rand = new Random();
            boolean found = false;
            String alias = null;
            do {
                Certificate c;
                if ((c = this._deploymentcerts.getCertificate(alias = "deploymentcert" + rand.nextLong())) != null) continue;
                found = true;
            } while (!found);
            this._deploymentcerts.setCertificateEntry(alias, cert);
        }
    }

    public void remove(Certificate cert) throws KeyStoreException {
        String alias = this._deploymentcerts.getCertificateAlias(cert);
        if (alias != null) {
            this._deploymentcerts.deleteEntry(alias);
        }
    }

    public boolean contains(Certificate cert) throws KeyStoreException {
        String alias = null;
        alias = this._deploymentcerts.getCertificateAlias(cert);
        return alias != null;
    }

    public boolean verify(Certificate cert) {
        return false;
    }

    public Iterator iterator() throws KeyStoreException {
        HashSet<Certificate> certCollection = new HashSet<Certificate>();
        Enumeration<String> enumr = this._deploymentcerts.aliases();
        while (enumr.hasMoreElements()) {
            String alias = enumr.nextElement();
            Certificate cert = this._deploymentcerts.getCertificate(alias);
            certCollection.add(cert);
        }
        return certCollection.iterator();
    }

    public KeyStore getKeyStore() {
        return this._deploymentcerts;
    }

    static {
        _filename = SMCSSLConfig.getUserCertificateFile();
        _storepass = SMCSSLConfig.getUserCertificatePswd();
    }
}

