/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.util.security;

import com.sun.management.viperimpl.util.ImplResourceManager;
import com.sun.management.viperimpl.util.security.DialogFactory;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.HashSet;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public final class CertificateHostnameVerifier
implements HostnameVerifier {
    private static HashSet hashSet = new HashSet();

    public boolean verify(String hostname, SSLSession session) {
        String certHostname = ImplResourceManager.getString((String)"https_dialog.unknown.host");
        try {
            int cn;
            Certificate[] cert = session.getPeerCertificates();
            if (!(cert[0] instanceof X509Certificate)) {
                throw new SSLPeerUnverifiedException("");
            }
            X509Certificate peerCert = (X509Certificate)cert[0];
            String certDN = peerCert.getSubjectDN().getName();
            if (certDN != null && (cn = certDN.toUpperCase().indexOf("CN=")) != -1) {
                int end = certDN.indexOf(",", cn);
                certHostname = end != -1 ? certDN.substring(cn + 3, end) : certDN.substring(cn + 3);
            }
        }
        catch (SSLPeerUnverifiedException e) {
            return false;
        }
        if (hostname.equalsIgnoreCase(certHostname) || certHostname.equals("*")) {
            return true;
        }
        for (Object[] elements : hashSet) {
            if (!elements[0].toString().equalsIgnoreCase(hostname) || !elements[1].toString().equalsIgnoreCase(certHostname)) continue;
            return true;
        }
        return this.showHostnameMismatchDialog(hostname, certHostname);
    }

    private boolean showHostnameMismatchDialog(String hostname, String certHostname) {
        String title = ImplResourceManager.getString((String)"https_dialog.caption");
        MessageFormat mf = new MessageFormat(ImplResourceManager.getString((String)"https_dialog.text"));
        Object[] args = new Object[]{hostname, certHostname};
        String message = mf.format(args);
        int result = 1;
        result = DialogFactory.showConfirmDialog(message, title);
        if (result == 0) {
            Object[] elements = new Object[]{hostname, certHostname};
            hashSet.add(elements);
        }
        return result == 0;
    }

    public static void reset() {
        hashSet.clear();
    }
}

