/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.config;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;

public class SectionedProperties
extends TreeMap {
    static final long serialVersionUID = -200555434270383795L;
    protected static final String specialSaveChars = "=: \t\r\n\f#!";
    protected static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public Properties getBlock(String string) {
        Object v = this.get(string);
        if (v instanceof Properties) {
            return (Properties)v;
        }
        return null;
    }

    public Properties setBlock(String string, Properties properties) {
        Properties properties2 = this.put(string, properties);
        if (properties2 instanceof Properties) {
            return properties2;
        }
        return null;
    }

    public void removeBlock(String string) {
        try {
            this.remove(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getProperty(String string, String string2) {
        Properties properties = this.getBlock(string);
        if (properties != null) {
            return properties.getProperty(string2);
        }
        return null;
    }

    public Object setProperty(String string, String string2, String string3) {
        Properties properties = this.getBlock(string);
        if (properties != null) {
            return properties.setProperty(string2, string3);
        }
        properties = new Properties();
        properties.setProperty(string2, string3);
        return this.put(string, properties);
    }

    public Iterator blockNames() {
        return this.keySet().iterator();
    }

    public Iterator propertyNames(String string) {
        Properties properties = this.getBlock(string);
        if (properties != null) {
            return properties.keySet().iterator();
        }
        return null;
    }

    public SectionedProperties select(String string) {
        SectionedProperties sectionedProperties = new SectionedProperties();
        if (string != null) {
            Iterator iterator = this.blockNames();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Properties properties = this.getBlock(string2);
                if (properties == null || !string2.startsWith(string)) continue;
                sectionedProperties.setBlock(string2, properties);
            }
        }
        return sectionedProperties;
    }

    public void load(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[inputStream.available()];
        inputStream.read(byArray);
        Object[] objectArray = null;
        int n = 0;
        int n2 = 0;
        while ((objectArray = this.findNextBlock(byArray, n)) != null) {
            String string = (String)objectArray[0];
            n2 = (Integer)objectArray[1];
            n = (Integer)objectArray[2];
            Properties properties = this.getBlock(string);
            if (properties == null) {
                properties = new Properties();
            }
            properties.load(new ByteArrayInputStream(byArray, n2, n - n2));
            this.setBlock(string, properties);
        }
    }

    protected Object[] findNextBlock(byte[] byArray, int n) {
        int n2 = this.findNextBlockTagOffset(byArray, n);
        if (n2 == -1) {
            return null;
        }
        int n3 = ++n2;
        while (byArray[n3] != 93) {
            ++n3;
        }
        int n4 = this.findNextBlockTagOffset(byArray, n3);
        if (n4 == -1) {
            n4 = byArray.length;
        }
        return new Object[]{new String(byArray, n2, n3 - n2), new Integer(n3 + 1), new Integer(n4)};
    }

    protected int findNextBlockTagOffset(byte[] byArray, int n) {
        try {
            int n2 = n;
            while (n2 < byArray.length) {
                if (byArray[n2] != 91) {
                    while (byArray[n2] != 10) {
                        if (byArray[n2] == 35) {
                            if (n2 > 0 && byArray[n2 - 1] == 32) {
                                byArray[n2 - 1] = 10;
                            }
                            while (byArray[n2] != 10) {
                                byArray[n2] = 10;
                                ++n2;
                            }
                            continue;
                        }
                        ++n2;
                    }
                    ++n2;
                }
                while (byArray[n2] == 32 || byArray[n2] == 9) {
                    ++n2;
                }
                if (byArray[n2] != 91) continue;
                int n3 = n2++;
                while (byArray[n2] != 93 && byArray[n2] != 10) {
                    ++n2;
                }
                if (byArray[n2] != 93) continue;
                return n3;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return -1;
    }

    public void store(OutputStream outputStream, String string) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "8859_1"));
        if (string != null) {
            SectionedProperties.writeln(bufferedWriter, "# " + string);
        }
        SectionedProperties.writeln(bufferedWriter, "# " + new Date().toString());
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Properties properties = this.getBlock(string2);
            if (properties != null) {
                SectionedProperties.writeBlock(bufferedWriter, string2, properties);
            }
            if (!iterator.hasNext()) continue;
            SectionedProperties.writeln(bufferedWriter, "");
        }
        bufferedWriter.flush();
    }

    protected static void writeBlock(BufferedWriter bufferedWriter, String string, Properties properties) throws IOException {
        SectionedProperties.writeln(bufferedWriter, '[' + string + ']');
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)properties.get(string2);
            string2 = SectionedProperties.saveConvert(string2);
            string3 = SectionedProperties.saveConvert(string3);
            SectionedProperties.writeln(bufferedWriter, string2 + "=" + string3);
        }
    }

    protected static void writeln(BufferedWriter bufferedWriter, String string) throws IOException {
        bufferedWriter.write(string);
        bufferedWriter.newLine();
    }

    protected static String saveConvert(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(2 * n);
        int n2 = 0;
        block7: while (n2 < n) {
            char c = string.charAt(n2++);
            switch (c) {
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block7;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block7;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block7;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block7;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block7;
                }
            }
            if (c < '\u0014' || c > '\u007f') {
                stringBuffer.append("\\u");
                stringBuffer.append(SectionedProperties.toHex(c >> 12 & 0xF));
                stringBuffer.append(SectionedProperties.toHex(c >> 8 & 0xF));
                stringBuffer.append(SectionedProperties.toHex(c >> 4 & 0xF));
                stringBuffer.append(SectionedProperties.toHex(c >> 0 & 0xF));
                continue;
            }
            if (specialSaveChars.indexOf(c) != -1) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    protected static char toHex(int n) {
        return hexDigit[n & 0xF];
    }
}

