/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.config;

import com.sun.web.console.config.ConsoleConfigException;
import com.sun.web.console.config.ConsoleConfigPasswordManager;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Properties;

public class ConsoleConfigSetup {
    public static final String DEFAULT_ADMINNAME = "admin";
    public static final String DEFAULT_PASSWORD = "changeit";
    private static final String FS = File.separator;
    private static final String SYSTEM_SUBDIR = "system";
    private static final String CONSOLE_SUBDIR = "console";
    private static final String LEGACY_SUBDIR = "legacy";
    private static final String PREREG_SUBDIR = "prereg";
    private static final String CACHE_SUBDIR = "regcache";
    private static final String CONSOLE_TGTDIR = "prereg" + FS + "console";
    private static final String DEFAULT_PROPS_TPL = "default_properties.tpl";
    private static final String SERVICE_PROPS_TPL = "service_properties.tpl";
    private static final String DEFAULT_PROPS_FILE = "default.properties";
    private static final String SERVICE_PROPS_FILE = "service.properties";
    private static final String CONFIG_HEADER = " Console instance configuration properties";
    private Properties env = null;
    private String conf_dir = null;
    private String prereg_dir = null;
    private String console_dir = null;
    private String template_dir = null;

    public ConsoleConfigSetup(Properties properties) {
        this.env = properties;
        this.conf_dir = this.env.getProperty("console_conf") + FS + this.env.getProperty("console_instance");
        this.prereg_dir = this.conf_dir + FS + PREREG_SUBDIR;
        this.console_dir = this.conf_dir + FS + CONSOLE_TGTDIR;
        this.template_dir = this.env.getProperty("console_home") + FS + "templates";
    }

    public void setupConfiguration() throws ConsoleConfigException {
        String string = null;
        File file = null;
        try {
            string = this.conf_dir + FS + PREREG_SUBDIR;
            file = new File(string);
            if (!file.exists()) {
                file.mkdir();
            }
            if (!(file = new File(string = this.conf_dir + FS + CACHE_SUBDIR)).exists()) {
                file.mkdir();
            }
            if (!(file = new File(string = this.conf_dir + FS + PREREG_SUBDIR + FS + CONSOLE_SUBDIR)).exists()) {
                file.mkdir();
            }
            if (!(file = new File(string = this.conf_dir + FS + PREREG_SUBDIR + FS + LEGACY_SUBDIR)).exists()) {
                file.mkdir();
            }
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("Error creating dir", string, exception.getLocalizedMessage());
        }
        String string2 = this.template_dir + FS + SYSTEM_SUBDIR + FS + DEFAULT_PROPS_TPL;
        String string3 = this.conf_dir + FS + DEFAULT_PROPS_FILE;
        this.copyTemplate(string2, string3);
        string2 = this.template_dir + FS + SYSTEM_SUBDIR + FS + DEFAULT_PROPS_TPL;
        string3 = this.conf_dir + FS + DEFAULT_PROPS_FILE;
        this.copyTemplate(string2, string3);
        String string4 = this.template_dir + FS + CONSOLE_SUBDIR;
        String string5 = this.conf_dir + FS + CONSOLE_TGTDIR;
        file = new File(string4);
        if (file.exists()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = stringArray[i];
                if (!string2.endsWith(".reg")) continue;
                string2 = string4 + FS + string2;
                string3 = string5 + FS + string2;
                this.copyTemplate(string2, string3);
            }
        }
    }

    public void setupPasswords(String string, String string2, String string3, String string4) throws ConsoleConfigException {
        String string5 = string != null ? string : DEFAULT_ADMINNAME;
        String string6 = string2 != null ? string2 : DEFAULT_PASSWORD;
        String string7 = string3 != null ? string3 : DEFAULT_PASSWORD;
        String string8 = string4 != null ? string4 : DEFAULT_PASSWORD;
        String string9 = this.conf_dir + FS + ".pswd";
        ConsoleConfigPasswordManager consoleConfigPasswordManager = new ConsoleConfigPasswordManager(string9);
        consoleConfigPasswordManager.load();
        consoleConfigPasswordManager.setValue("admin_name", string5);
        consoleConfigPasswordManager.setValue("admin_pswd", string6);
        consoleConfigPasswordManager.setValue("admin_name", string7);
        consoleConfigPasswordManager.setValue("admin_name", string8);
        consoleConfigPasswordManager.save(true);
    }

    public void destroyConfiguration(boolean bl) throws ConsoleConfigException {
        String string = null;
        File file = null;
        string = this.conf_dir + FS + PREREG_SUBDIR;
        try {
            this.recursiveRemove(string);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        string = this.conf_dir + FS + CACHE_SUBDIR;
        try {
            this.recursiveRemove(string);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        try {
            string = this.conf_dir + FS + DEFAULT_PROPS_FILE;
            file = new File(string);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        try {
            string = this.conf_dir + FS + SERVICE_PROPS_FILE;
            file = new File(string);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        try {
            string = this.conf_dir + FS + ".pswd";
            file = new File(string);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        if (bl) {
            try {
                this.recursiveRemove(this.conf_dir);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void copyTemplate(String string, String string2) throws ConsoleConfigException {
        Closeable closeable;
        File file = null;
        File file2 = null;
        file = new File(string);
        if (!file.exists()) {
            throw new ConsoleConfigException("tpl_err_02", string);
        }
        file2 = new File(string2);
        if (file2.exists()) {
            try {
                file2.delete();
            }
            catch (Exception exception) {
                throw new ConsoleConfigException("tpl_err_04", string2, exception.getLocalizedMessage());
            }
        }
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            fileInputStream = new FileInputStream(file);
            closeable = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            bufferedReader = new BufferedReader((Reader)closeable);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ConsoleConfigException("tpl_err_02", string);
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("tpl_err_05", string, exception.getLocalizedMessage());
        }
        closeable = null;
        PrintWriter printWriter = null;
        try {
            closeable = new FileOutputStream(file2);
            printWriter = new PrintWriter((OutputStream)closeable);
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("tpl_err_06", string2, exception.getLocalizedMessage());
        }
        try {
            String string3;
            while ((string3 = bufferedReader.readLine()) != null) {
                int n;
                int n2;
                String string4 = "";
                while ((n2 = string3.indexOf("%%")) != -1 && n2 + 2 < string3.length() && (n = string3.indexOf("%%", n2 + 2)) != -1) {
                    String string5 = string3.substring(0, n2);
                    String string6 = string3.substring(n2 + 2, n);
                    string3 = n + 2 < string3.length() ? string3.substring(n + 2) : "";
                    String string7 = null;
                    if (string6.length() > 0) {
                        string7 = this.env.getProperty(string6);
                    }
                    if (string7 == null) {
                        string7 = "%%" + string6 + "%%";
                    }
                    string4 = string4 + string5 + string7;
                }
                string4 = string4 + string3;
                printWriter.println(string4);
            }
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("tpl_err_07", string, exception.getLocalizedMessage());
        }
        try {
            bufferedReader.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            printWriter.close();
            ((FileOutputStream)closeable).close();
        }
        catch (Exception exception) {
            throw new ConsoleConfigException("tpl_err_08", string2, exception.getLocalizedMessage());
        }
    }

    private void recursiveRemove(String string) {
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            String[] stringArray = file.list();
            if (stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = string + FS + stringArray[i];
                    File file2 = new File(string2);
                    if (file2.isDirectory()) {
                        try {
                            this.recursiveRemove(string2);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        file2.delete();
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println("Error removing: " + string2);
                    }
                }
            }
            try {
                file.delete();
            }
            catch (Exception exception) {
                System.out.println("Error removing: " + string);
            }
        }
    }

    private Properties loadConfigProperties() throws ConsoleConfigException {
        String string = this.conf_dir + FS + "config.properties";
        FileInputStream fileInputStream = null;
        ConsoleConfigException consoleConfigException = null;
        Properties properties = new Properties();
        try {
            fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
        }
        catch (Exception exception) {
            consoleConfigException = new ConsoleConfigException("Error loading config props: ", exception.getLocalizedMessage());
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (consoleConfigException != null) {
            throw consoleConfigException;
        }
        return properties;
    }

    private void saveConfigProperties(Properties properties) throws ConsoleConfigException {
        String string = this.conf_dir + FS + "config.properties";
        String string2 = this.conf_dir + FS + "temp.properties";
        String string3 = this.conf_dir + FS + "backup.properties";
        File file = new File(string);
        File file2 = new File(string2);
        File file3 = new File(string3);
        FileOutputStream fileOutputStream = null;
        ConsoleConfigException consoleConfigException = null;
        try {
            if (file2.exists()) {
                file2.delete();
            }
            fileOutputStream = new FileOutputStream(file2);
            properties.store(fileOutputStream, CONFIG_HEADER);
            fileOutputStream.close();
            fileOutputStream = null;
            if (file.exists()) {
                file3.delete();
                file.renameTo(file3);
            }
            file2.renameTo(file);
        }
        catch (Exception exception) {
            consoleConfigException = new ConsoleConfigException("Error storing config file: ", exception.getLocalizedMessage());
        }
        if (file3.exists()) {
            try {
                file3.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (fileOutputStream != null) {
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (consoleConfigException != null) {
            throw consoleConfigException;
        }
    }
}

