/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.config;

import com.sun.web.console.config.ConsoleConfigException;
import com.sun.web.console.config.ConsoleConfigLog;
import com.sun.web.console.config.SectionedProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Properties;

public class ConsoleConfigRegnot {
    private static final String FS = File.separator;
    private static final String BKP_FILETYPE = ".bkp";
    private static final String REG_FILETYPE = ".reg";
    private static final int REG_FILETYPE_LEN = ".reg".length();
    private static final String REG_HEADER = " registration notification";
    private String regdir;

    public ConsoleConfigRegnot(String string) {
        this.regdir = string;
    }

    public boolean exists(String string, String string2) {
        boolean bl = false;
        File file = new File(this.regdir + FS + string + FS + string2 + REG_FILETYPE);
        if (file.exists()) {
            bl = true;
        }
        return bl;
    }

    public Properties read(String string, String string2) throws FileNotFoundException, ConsoleConfigException {
        String string3 = this.regdir + FS + string + FS + string2 + REG_FILETYPE;
        File file = new File(string3);
        if (!file.exists()) {
            throw new FileNotFoundException(string3);
        }
        Properties properties = new Properties();
        long l = 0L;
        FileInputStream fileInputStream = null;
        ConsoleConfigException consoleConfigException = null;
        try {
            l = file.lastModified();
            fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
        }
        catch (Exception exception) {
            consoleConfigException = new ConsoleConfigException("reg_err_07", string2, string, exception.getLocalizedMessage());
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (consoleConfigException != null) {
            throw consoleConfigException;
        }
        properties.setProperty("appname", string);
        properties.setProperty("id", string2);
        properties.setProperty("timestamp", Long.toString(l));
        properties.setProperty("notification", string3);
        if (!this.validate(properties)) {
            throw new ConsoleConfigException("reg_err_08", string2, string);
        }
        return properties;
    }

    public String[] listAllIds() throws ConsoleConfigException {
        File file = new File(this.regdir);
        if (!file.exists() || !file.isDirectory()) {
            throw new ConsoleConfigException("reg_err_09", this.regdir);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.endsWith(REG_FILETYPE)) continue;
            string = string.substring(0, string.length() - REG_FILETYPE_LEN);
            arrayList.add(string);
        }
        String[] stringArray2 = new String[arrayList.size()];
        stringArray2 = arrayList.toArray(stringArray2);
        return stringArray2;
    }

    public SectionedProperties loadAll() throws ConsoleConfigException {
        Object object;
        Object object2;
        Object object3;
        SectionedProperties sectionedProperties = new SectionedProperties();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        File file = new File(this.regdir);
        if (file.exists() && file.isDirectory() && (object3 = file.list()) != null && ((Object)object3).length > 0) {
            for (int i = 0; i < ((Object)object3).length; ++i) {
                object2 = this.regdir + FS + (String)object3[i];
                object = new File((String)object2);
                if (!((File)object).isDirectory()) continue;
                arrayList.add(object3[i]);
            }
        }
        if (arrayList.size() > 0) {
            object3 = arrayList.iterator();
            while (object3.hasNext()) {
                String string = (String)object3.next();
                object2 = new File(this.regdir + FS + string);
                object = ((File)object2).list();
                if (object == null || ((String[])object).length <= 0) continue;
                for (int i = 0; i < ((Object)object).length; ++i) {
                    Object object4 = object[i];
                    if (!((String)object4).endsWith(REG_FILETYPE)) continue;
                    try {
                        String string2 = ((String)object4).substring(0, ((String)object4).length() - REG_FILETYPE_LEN);
                        Properties properties = this.read(string, string2);
                        String string3 = this.getKey(properties);
                        sectionedProperties.setBlock(string3, properties);
                        continue;
                    }
                    catch (Exception exception) {
                        ConsoleConfigLog.log(1, "Error reading regnot", (String)object4, string, exception.getMessage());
                    }
                }
            }
        }
        return sectionedProperties;
    }

    public void write(Properties properties) throws ConsoleConfigException {
        String string = properties.getProperty("appname");
        String string2 = properties.getProperty("id");
        String string3 = properties.getProperty("type");
        if (!this.validate(properties)) {
            throw new ConsoleConfigException("reg_err_10", string2, string);
        }
        properties.remove("id");
        properties.remove("appname");
        properties.remove("timestamp");
        properties.remove("notification");
        String string4 = this.regdir + FS + string;
        File file = new File(string4);
        if (!file.exists()) {
            try {
                file.mkdirs();
            }
            catch (Exception exception) {
                throw new ConsoleConfigException("reg_err_11", string, exception.getLocalizedMessage());
            }
        }
        File file2 = new File(string4 + FS + string2 + BKP_FILETYPE);
        File file3 = new File(string4 + FS + string2 + REG_FILETYPE);
        if (file3.exists()) {
            try {
                if (file2.exists()) {
                    file2.delete();
                }
                file3.renameTo(file2);
            }
            catch (Exception exception) {
                throw new ConsoleConfigException("reg_err_12", string2, string, exception.getLocalizedMessage());
            }
        }
        FileOutputStream fileOutputStream = null;
        ConsoleConfigException consoleConfigException = null;
        try {
            fileOutputStream = new FileOutputStream(file3);
            properties.store(fileOutputStream, "# " + string3 + REG_HEADER);
        }
        catch (Exception exception) {
            consoleConfigException = new ConsoleConfigException("reg_err_12", string2, string, exception.getMessage());
        }
        if (file2.exists()) {
            try {
                file2.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (fileOutputStream != null) {
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (consoleConfigException != null) {
            throw consoleConfigException;
        }
    }

    public void remove(String string, String string2) throws ConsoleConfigException {
        File file;
        String string3 = this.regdir + FS + string + FS + string2;
        File file2 = new File(string3 + REG_FILETYPE);
        if (file2.exists()) {
            try {
                file2.delete();
            }
            catch (Exception exception) {
                throw new ConsoleConfigException("reg_err_13", string2, string, exception.getMessage());
            }
        }
        if ((file = new File(string3 + BKP_FILETYPE)).exists()) {
            try {
                file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void sort(Properties[] propertiesArray) {
        Properties properties = null;
        int n = propertiesArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n - 1; ++j) {
                String string;
                String string2 = this.getKey(propertiesArray[j]);
                if (string2.compareToIgnoreCase(string = this.getKey(propertiesArray[j + 1])) <= 0) continue;
                properties = propertiesArray[j];
                propertiesArray[j] = propertiesArray[j + 1];
                propertiesArray[j + 1] = properties;
            }
        }
    }

    public Properties[] select(Properties[] propertiesArray, String string) {
        ArrayList<Properties> arrayList = new ArrayList<Properties>();
        for (int i = 0; i < propertiesArray.length; ++i) {
            String string2 = propertiesArray[i].getProperty("type");
            if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
            arrayList.add(propertiesArray[i]);
        }
        Properties[] propertiesArray2 = new Properties[arrayList.size()];
        propertiesArray2 = arrayList.toArray(propertiesArray2);
        return propertiesArray2;
    }

    public boolean validate(Properties properties) {
        boolean bl;
        block1: {
            boolean bl2;
            block3: {
                String string;
                block5: {
                    block4: {
                        block2: {
                            bl2 = true;
                            bl = false;
                            if (!bl2 || this.badProp("appname", properties) || this.badProp("id", properties) || this.badProp("type", properties)) break block1;
                            string = properties.getProperty("type");
                            if (!string.equalsIgnoreCase("webapp")) break block2;
                            if (!this.badProp("context", properties) && !this.badProp("location", properties)) break block3;
                            break block1;
                        }
                        if (!string.equalsIgnoreCase("jar")) break block4;
                        if (!this.badProp("location", properties)) break block3;
                        break block1;
                    }
                    if (!string.equalsIgnoreCase("loginmodule")) break block5;
                    if (this.badProp("class", properties) || this.badProp("behavior", properties) || this.badProp("service", properties)) break block1;
                    if (this.badProp("order", properties)) {
                        properties.setProperty("order", "0");
                    }
                    break block3;
                }
                if (!string.equalsIgnoreCase("jvmoptions")) break block1;
            }
            bl = true;
            bl2 = false;
        }
        return bl;
    }

    public String getKey(Properties properties) {
        return properties.getProperty("type") + "-" + properties.getProperty("appname") + "-" + properties.getProperty("id");
    }

    public static String getId(String string, String string2) {
        String string3 = null;
        if (string != null && string2 != null) {
            if (string.equalsIgnoreCase("webapp")) {
                string3 = string2;
            } else if (string.equalsIgnoreCase("jar")) {
                string3 = string2;
                if (string3.length() > 2 && string3.charAt(1) == ':') {
                    string3 = string3.substring(2);
                }
                if (string3.startsWith(FS)) {
                    string3 = string3.substring(1);
                }
                if (string3.endsWith(".jar")) {
                    string3 = string3.substring(0, string3.length() - 4);
                }
                string3 = string3.replace(File.separatorChar, '_');
            } else if (string.equalsIgnoreCase("loginmodule")) {
                string3 = string2.replace('.', '_');
            }
        }
        return string3;
    }

    private boolean badProp(String string, Properties properties) {
        boolean bl = true;
        String string2 = properties.getProperty(string);
        if (string2 != null && string2.length() > 0) {
            bl = false;
        }
        return bl;
    }
}

