/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.config;

import com.sun.web.console.config.ConsoleConfigException;
import com.sun.web.console.config.ConsoleConfigLog;
import com.sun.web.console.config.ConsoleConfigService;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class ConsoleConfigFactory {
    private String impl_class = "com.sun.web.console.config.sjsas.ConsoleConfigServiceImpl";

    public Properties loadEnv(String string, String string2) throws ConsoleConfigException {
        Properties properties = new Properties();
        String string3 = string + File.separator + string2 + File.separator + "config.properties";
        try {
            properties.load(new FileInputStream(string3));
        }
        catch (Exception exception) {
            ConsoleConfigLog.trace("Error loading config properties: " + string3, exception);
            throw new ConsoleConfigException("impl_err_03", string3, exception.getLocalizedMessage());
        }
        String string4 = (String)properties.get("console_instance");
        if (string4 == null || string4.length() == 0 || !string4.equals(string2)) {
            throw new ConsoleConfigException("impl_err_04", string3, string2);
        }
        return properties;
    }

    public ConsoleConfigService createConsoleConfigService(String string, String string2) throws ConsoleConfigException {
        Properties properties = this.loadEnv(string, string2);
        return this.createConsoleConfigService(properties, string2);
    }

    public ConsoleConfigService createConsoleConfigService(Properties properties, String string) throws ConsoleConfigException {
        ConsoleConfigService consoleConfigService = null;
        String string2 = null;
        String string3 = null;
        try {
            string3 = properties.getProperty("console_type");
            if (string3 != null) {
                string3 = string3.trim();
            }
            string2 = string3.equalsIgnoreCase("sjsas") || string3.toLowerCase().indexOf("appserver") != -1 ? "sjsas" : "tomcat";
            Class<?> clazz = Class.forName("com.sun.web.console.config." + string2 + ".ConsoleConfigServiceImpl");
            consoleConfigService = (ConsoleConfigService)clazz.newInstance();
            consoleConfigService.setEnv(properties);
        }
        catch (Exception exception) {
            consoleConfigService = null;
            ConsoleConfigLog.trace("Error creating service impl class", exception);
            throw new ConsoleConfigException("impl_err_05", string3, exception.getLocalizedMessage());
        }
        return consoleConfigService;
    }
}

