/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.config;

import com.sun.management.services.common.ConsoleInfo;
import com.sun.web.console.config.ConsoleConfigException;
import com.sun.web.console.config.ConsoleConfigFactory;
import com.sun.web.console.config.ConsoleConfigLog;
import com.sun.web.console.config.ConsoleConfigRegistrationResolver;
import com.sun.web.console.config.ConsoleConfigRegnot;
import com.sun.web.console.config.ConsoleConfigService;
import com.sun.web.console.config.ConsoleConfigStatus;
import com.sun.web.console.config.ConsoleConfigUpgrade;
import com.sun.web.console.config.ConsoleConfigUtil;
import com.sun.web.console.config.SectionedProperties;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.ResourceBundle;

public class ConsoleConfigDriver {
    public static final String INSTANCE_FLAG_SHORT = "-i";
    public static final String INSTANCE_FLAG_LONG = "--instance";
    public static final String USER_FLAG_SHORT = "-u";
    public static final String USER_FLAG_LONG = "--user";
    public static final String VERSION_FLAG_SHORT = "-V";
    public static final String VERSION_FLAG_LONG = "--version";
    public static final String HELP_FLAG_SHORT = "-h";
    public static final String HELP_FLAG_SHORT2 = "-?";
    public static final String HELP_FLAG_LONG = "--help";
    public static final String PARSEABLE_FLAG_SHORT = "-p";
    public static final String PARSEABLE_FLAG_LONG = "--parseable";
    public static final String DEBUG_FLAG_LONG = "--debug";
    public static final String LOCAL_FLAG_LONG = "--local";
    public static final String PARSEABLE_STATUS_RUNNING = "running=yes";
    public static final String PARSEABLE_STATUS_STOPPED = "running=no";
    public static final String PARSEABLE_STATUS_UNKNOWN = "running=unknown";
    public static final String PROGNAME = "smcwebserver";
    private String consoleInstanceName = "console";
    private String propertyFilePath = "";
    private Properties configProperties = null;
    ConsoleConfigFactory configFactory = null;
    ConsoleConfigService configService = null;
    public static final String START_CMD = "start";
    public static final String STOP_CMD = "stop";
    public static final String RESTART_CMD = "restart";
    public static final String STATUS_CMD = "status";
    public static final String ENABLE_CMD = "enable";
    public static final String DISABLE_CMD = "disable";
    private String SERVICE_USERNAME_PROP = "com.sun.web.console.user";
    private String useropt = null;
    private boolean startFlag = false;
    private boolean stopFlag = false;
    private boolean restartFlag = false;
    private boolean statusFlag = false;
    private boolean enableFlag = false;
    private boolean disableFlag = false;
    private boolean versionFlag = false;
    private boolean helpFlag = false;
    private boolean parseableFlag = false;
    private boolean debugFlag = false;
    private boolean localFlag = false;
    ResourceBundle messages = null;
    int stat_timeout = 1;
    private static final String RESOURCE_BUNDLE = "com.sun.web.console.config.resources.Resources";

    public void usage(int n) {
        System.out.println(this.messages.getString("smcwebserver_usage"));
        System.exit(n);
    }

    public void cleanup() {
    }

    public void parseArgs(String[] stringArray) {
        Object var2_2 = null;
        int n = stringArray.length;
        int n2 = 0;
        if (n > 0) {
            this.startFlag = stringArray[n2].equals(START_CMD);
            this.stopFlag = stringArray[n2].equals(STOP_CMD);
            this.restartFlag = stringArray[n2].equals(RESTART_CMD);
            this.statusFlag = stringArray[n2].equals(STATUS_CMD);
            this.enableFlag = stringArray[n2].equals(ENABLE_CMD);
            this.disableFlag = stringArray[n2].equals(DISABLE_CMD);
            this.versionFlag = stringArray[n2].equals(VERSION_FLAG_SHORT) || stringArray[n2].equals(VERSION_FLAG_LONG);
            boolean bl = this.helpFlag = stringArray[n2].equals(HELP_FLAG_SHORT) || stringArray[n2].equals(HELP_FLAG_SHORT2) || stringArray[n2].equals(HELP_FLAG_LONG);
            if (!(this.startFlag || this.stopFlag || this.restartFlag || this.statusFlag || this.enableFlag || this.disableFlag || this.versionFlag || this.helpFlag)) {
                this.usage(1);
            }
            if ((this.versionFlag || this.helpFlag) && n != 1) {
                this.usage(1);
            }
        } else {
            this.usage(1);
        }
        ++n2;
        while (n2 < n) {
            if (stringArray[n2].equals(INSTANCE_FLAG_SHORT) || stringArray[n2].equals(INSTANCE_FLAG_LONG)) {
                if (!(this.startFlag || this.stopFlag || this.restartFlag || this.enableFlag || this.disableFlag || this.statusFlag)) {
                    this.usage(1);
                }
                if (n2 + 1 < n) {
                    this.consoleInstanceName = stringArray[++n2];
                } else {
                    this.usage(1);
                }
            } else if (stringArray[n2].equals(USER_FLAG_SHORT) || stringArray[n2].equals(USER_FLAG_LONG)) {
                if (!this.startFlag && !this.restartFlag) {
                    this.usage(1);
                }
                if (n2 + 1 < n) {
                    this.useropt = stringArray[++n2];
                } else {
                    this.usage(1);
                }
            } else if (stringArray[n2].equals(PARSEABLE_FLAG_LONG) || stringArray[n2].equals(PARSEABLE_FLAG_SHORT)) {
                if (!this.statusFlag) {
                    this.usage(1);
                }
                this.parseableFlag = true;
            } else if (stringArray[n2].equals(DEBUG_FLAG_LONG)) {
                this.debugFlag = true;
            } else if (stringArray[n2].equals(LOCAL_FLAG_LONG)) {
                this.localFlag = true;
            } else {
                this.usage(1);
            }
            ++n2;
        }
    }

    public int checkStatus(int n) {
        int n2 = 1;
        int n3 = this.stat_timeout;
        Thread thread = Thread.currentThread();
        int n4 = 2;
        int n5 = -1;
        while (n3 > 0) {
            try {
                Thread.sleep(n2 * 1000);
            }
            catch (Exception exception) {
                // empty catch block
            }
            --n3;
            try {
                n4 = this.configService.statServer();
            }
            catch (Exception exception) {
                ConsoleConfigLog.log(1, "driver_err_47", exception.getMessage());
                n4 = 2;
            }
            ConsoleConfigLog.log(4, "ping server: " + n4);
            if (n != n4) continue;
            return n4;
        }
        ConsoleConfigLog.log(1, "driver_err_47", "timeout");
        return 2;
    }

    public void startContainer(String string) throws ConsoleConfigException {
        try {
            int n = this.configService.startServer(string);
            if (n < 0) {
                ConsoleConfigException consoleConfigException = new ConsoleConfigException("driver_err_03", this.consoleInstanceName);
                ConsoleConfigLog.log(1, (Throwable)((Object)consoleConfigException));
                throw consoleConfigException;
            }
            String string2 = string;
            if (this.localFlag && string.equals("user")) {
                string2 = "local user";
            }
            ConsoleConfigLog.log(3, "driver_msg_02", this.consoleInstanceName, string2);
        }
        catch (ConsoleConfigException consoleConfigException) {
            ConsoleConfigException consoleConfigException2 = new ConsoleConfigException("driver_err_16", this.consoleInstanceName, consoleConfigException.getLocalizedMessage());
            ConsoleConfigLog.log(1, (Throwable)((Object)consoleConfigException));
            System.err.println(consoleConfigException2.getLocalizedMessage());
            System.exit(1);
        }
    }

    public void stopContainer(boolean bl) throws ConsoleConfigException {
        try {
            int n = this.configService.stopServer(bl);
            if (n < 0) {
                ConsoleConfigException consoleConfigException = new ConsoleConfigException("driver_err_13", this.consoleInstanceName);
                ConsoleConfigLog.log(1, (Throwable)((Object)consoleConfigException));
                throw consoleConfigException;
            }
            ConsoleConfigLog.log(3, bl ? "driver_msg_14" : "driver_msg_03", this.consoleInstanceName);
        }
        catch (Exception exception) {
            ConsoleConfigException consoleConfigException = new ConsoleConfigException("driver_err_14", this.consoleInstanceName, exception.getLocalizedMessage());
            ConsoleConfigLog.log(1, (Throwable)((Object)consoleConfigException));
            System.err.println(consoleConfigException.getLocalizedMessage());
            System.exit(1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean createSubdirs() throws ConsoleConfigException {
        boolean bl = false;
        try {
            String string = this.configProperties.getProperty("console_log");
            String string2 = this.configProperties.getProperty("console_instance");
            if (string != null && string2 != null) {
                File file = new File(string = string + File.separator + string2);
                if (file.isFile()) {
                    ConsoleConfigException consoleConfigException = new ConsoleConfigException("driver_err_12");
                    ConsoleConfigLog.log(1, (Throwable)((Object)consoleConfigException));
                    throw consoleConfigException;
                }
                if (file.exists()) return true;
                boolean bl2 = file.mkdirs();
                if (bl2) {
                    return true;
                }
                ConsoleConfigException consoleConfigException = new ConsoleConfigException("driver_err_05", string);
                ConsoleConfigLog.log(1, (Throwable)((Object)consoleConfigException));
                throw consoleConfigException;
            }
            ConsoleConfigException consoleConfigException = new ConsoleConfigException("driver_err_06");
            ConsoleConfigLog.log(1, (Throwable)((Object)consoleConfigException));
            throw consoleConfigException;
        }
        catch (Exception exception) {
            ConsoleConfigException consoleConfigException = new ConsoleConfigException("driver_err_07", this.consoleInstanceName);
            ConsoleConfigLog.log(1, exception);
            System.err.println(consoleConfigException.getLocalizedMessage());
            System.exit(1);
        }
        return bl;
    }

    public void createContainerInstance() throws ConsoleConfigException {
        try {
            int n = this.configService.createConsoleContainer();
            if (n != 0) {
                ConsoleConfigException consoleConfigException = new ConsoleConfigException("driver_err_08", this.consoleInstanceName);
                ConsoleConfigLog.log(1, (Throwable)((Object)consoleConfigException));
                throw consoleConfigException;
            }
            ConsoleConfigLog.log(4, "created container instance " + this.consoleInstanceName);
        }
        catch (ConsoleConfigException consoleConfigException) {
            ConsoleConfigException consoleConfigException2 = new ConsoleConfigException("driver_err_09", this.consoleInstanceName);
            ConsoleConfigLog.log(1, (Throwable)((Object)consoleConfigException));
            System.err.println(consoleConfigException2.getLocalizedMessage());
            System.exit(1);
        }
    }

    public void createKeyEntry() throws ConsoleConfigException {
        try {
            int n = this.configService.createCertificate();
            if (n != 0) {
                ConsoleConfigException consoleConfigException = new ConsoleConfigException("driver_err_10");
                ConsoleConfigLog.log(1, (Throwable)((Object)consoleConfigException));
                throw consoleConfigException;
            }
            ConsoleConfigLog.log(4, "created secutrity certificate " + this.consoleInstanceName);
        }
        catch (ConsoleConfigException consoleConfigException) {
            ConsoleConfigException consoleConfigException2 = new ConsoleConfigException("driver_err_11", this.consoleInstanceName);
            ConsoleConfigLog.log(1, (Throwable)((Object)consoleConfigException));
            System.err.println(consoleConfigException2.getLocalizedMessage());
            System.exit(1);
        }
    }

    public void setStartOnBoot(boolean bl) throws ConsoleConfigException {
        String string = null;
        String string2 = System.getProperty("os.name");
        if (string2 != null) {
            string2 = string2.toLowerCase();
            int n = string2.indexOf("sunos");
            int n2 = string2.indexOf("windows");
            if (n >= 0) {
                string2 = System.getProperty("os.version");
                if (string2 != null && !string2.equals("5.8") && !string2.equals("5.9")) {
                    string = "driver_err_56";
                }
            } else if (n2 >= 0) {
                string = "driver_err_56";
            }
        }
        if (string != null) {
            ConsoleConfigException consoleConfigException = new ConsoleConfigException(string);
            ConsoleConfigLog.log(2, (Throwable)((Object)consoleConfigException));
            System.err.println(consoleConfigException.getLocalizedMessage());
            System.exit(1);
        }
        try {
            String string3 = this.configProperties.getProperty("console_conf");
            String string4 = this.configProperties.getProperty("console_instance");
            String string5 = string3 + File.separator + string4 + File.separator + "service.properties";
            Properties properties = new Properties();
            File file = new File(string5);
            if (file.exists()) {
                properties.load(new FileInputStream(string5));
            }
            String string6 = properties.getProperty("ENABLE");
            boolean bl2 = false;
            if (bl) {
                if (string6 != null) {
                    if (!string6.equals("yes")) {
                        properties.setProperty("ENABLE", "yes");
                        bl2 = true;
                    }
                } else {
                    properties.setProperty("ENABLE", "yes");
                    bl2 = true;
                }
            } else if (string6 != null) {
                properties.remove("ENABLE");
                bl2 = true;
            }
            if (bl2) {
                ConsoleConfigUtil.storeProperties(string5, properties, null);
            }
        }
        catch (Exception exception) {
            ConsoleConfigException consoleConfigException = new ConsoleConfigException("driver_err_04", exception.getLocalizedMessage());
            ConsoleConfigLog.log(1, exception);
            System.err.println(consoleConfigException.getLocalizedMessage());
            System.exit(1);
        }
    }

    public void createDomain() throws ConsoleConfigException {
        String string;
        ConsoleConfigStatus consoleConfigStatus = new ConsoleConfigStatus(this.configProperties);
        if (this.configService == null) {
            throw new ConsoleConfigException("driver_err_03", this.consoleInstanceName);
        }
        if (consoleConfigStatus.isDomainComplete()) {
            String string2 = consoleConfigStatus.getUserName();
            if (!string2.equals("undefined")) {
                this.configProperties.setProperty("console_user", string2);
            } else {
                string2 = this.configProperties.getProperty("console_user");
            }
            if (this.useropt != null && !this.useropt.equals(string2)) {
                consoleConfigStatus.setUserName(this.useropt);
                this.configProperties.setProperty("console_user", this.useropt);
            }
            return;
        }
        String string3 = this.configProperties.getProperty("console_type");
        ConsoleConfigLog.log(3, "driver_msg_21", this.consoleInstanceName, string3);
        consoleConfigStatus.setDomainInit();
        if (!consoleConfigStatus.isSubdirsComplete()) {
            consoleConfigStatus.setSubdirsInit();
            if (this.createSubdirs()) {
                consoleConfigStatus.setSubdirsComplete();
            }
        }
        if ((string = consoleConfigStatus.getUserName()).equals("undefined")) {
            string = this.getUserIdentity(this.useropt);
            consoleConfigStatus.setUserName(string);
        }
        this.configProperties.setProperty("console_user", string);
        if (!consoleConfigStatus.isContainerComplete()) {
            consoleConfigStatus.setContainerInit();
            this.createContainerInstance();
            consoleConfigStatus.setContainerComplete();
        }
        if (!consoleConfigStatus.isKeyEntryComplete()) {
            consoleConfigStatus.setKeyEntryInit();
            this.createKeyEntry();
            consoleConfigStatus.setKeyEntryComplete();
        }
        if (this.consoleInstanceName.equals("console") && !consoleConfigStatus.isUpgradeComplete()) {
            ConsoleConfigLog.log(3, "driver_msg_22");
            consoleConfigStatus.setUpgradeInit();
            ConsoleConfigUpgrade consoleConfigUpgrade = new ConsoleConfigUpgrade();
            consoleConfigUpgrade.performUpgrade(this.configProperties);
            consoleConfigStatus.setUpgradeComplete();
        }
        consoleConfigStatus.setDomainComplete();
        ConsoleConfigLog.log(3, "driver_msg_04", this.consoleInstanceName);
    }

    public void addDriverProperties() {
        Properties properties;
        String string;
        String string2 = this.configProperties.getProperty("console_base") + File.separator + "policy" + File.separator + "console.policy";
        this.configProperties.put("console_security_policyfile", string2);
        string2 = this.configProperties.getProperty("console_conf") + File.separator + "console";
        this.configProperties.put("console_config_file", string2);
        this.configProperties.put("console_default_file", "/etc/default/console");
        if (this.localFlag) {
            this.configProperties.put("container_address", "127.0.0.1");
        }
        if ((string = (properties = this.getServiceProperties()).getProperty("java.home")) != null && string.length() > 0) {
            try {
                if (ConsoleConfigUtil.checkJavaVersion(string) == 0) {
                    this.configProperties.put("java_home", string);
                }
            }
            catch (Exception exception) {
                ConsoleConfigLog.log(1, exception);
            }
        }
    }

    public void createConfigLog() throws ConsoleConfigException {
        int n;
        String string = this.configProperties.getProperty("console_log") + File.separator + this.configProperties.getProperty("console_instance");
        String string2 = string + File.separator + "console_config_log";
        File file = new File(string);
        if (!file.exists()) {
            n = file.mkdirs();
            if (n == 0) {
                throw new ConsoleConfigException("driver_err_18", string2);
            }
        } else if (file.isFile()) {
            throw new ConsoleConfigException("driver_err_17");
        }
        n = this.debugFlag ? 4 : 3;
        ConsoleConfigLog.open(n, string2);
    }

    public void setupDriver(String[] stringArray) throws ConsoleConfigException {
        ConsoleConfigException consoleConfigException;
        try {
            this.messages = ResourceBundle.getBundle(RESOURCE_BUNDLE);
            if (this.messages == null) {
                ConsoleConfigException consoleConfigException2 = new ConsoleConfigException("driver_err_00", this.consoleInstanceName);
                ConsoleConfigLog.log(1, (Throwable)((Object)consoleConfigException2));
                throw consoleConfigException2;
            }
            this.parseArgs(stringArray);
            this.getConfigProperties();
            this.createConfigLog();
            this.addDriverProperties();
            this.stat_timeout = this.getStatTimeout();
        }
        catch (Exception exception) {
            consoleConfigException = new ConsoleConfigException(exception.getLocalizedMessage());
            ConsoleConfigLog.log(1, exception);
            System.err.println(consoleConfigException.getLocalizedMessage());
            System.exit(1);
        }
        try {
            this.configFactory = new ConsoleConfigFactory();
            this.configService = this.configFactory.createConsoleConfigService(this.configProperties, this.consoleInstanceName);
            this.configService.initialize();
        }
        catch (ConsoleConfigException consoleConfigException3) {
            consoleConfigException = new ConsoleConfigException("driver_err_03", this.consoleInstanceName);
            ConsoleConfigLog.log(1, consoleConfigException3.getLocalizedMessage());
            System.err.println(consoleConfigException.getLocalizedMessage());
            System.exit(1);
        }
    }

    public void checkSupportingProducts() throws ConsoleConfigException {
        try {
            int n = ConsoleConfigUtil.checkSupportingProducts(this.configProperties);
            ConsoleConfigLog.log(4, "driver_msg_12");
        }
        catch (Exception exception) {
            ConsoleConfigException consoleConfigException = new ConsoleConfigException(exception.getLocalizedMessage());
            ConsoleConfigLog.log(1, exception);
            System.err.println(consoleConfigException.getLocalizedMessage());
            System.exit(1);
        }
    }

    public boolean initialConfig() throws ConsoleConfigException {
        boolean bl = false;
        try {
            ConsoleConfigStatus consoleConfigStatus = new ConsoleConfigStatus(this.configProperties);
            if (!consoleConfigStatus.isInitialConfigComplete()) {
                ConsoleConfigLog.log(3, "Initial container configuration...");
                consoleConfigStatus.setInitialConfigInit();
                bl = this.configService.initialContainerConfig();
                consoleConfigStatus.setInitialConfigComplete();
            }
        }
        catch (Exception exception) {
            String string = "Error from initial configuration: " + exception.getMessage();
            ConsoleConfigLog.log(1, string);
            System.err.println(string);
            System.exit(1);
        }
        return bl;
    }

    private String getUserIdentity(String string) {
        String string2;
        Object object;
        String string3 = string;
        if (string3 != null && string3.trim().length() >= 0 && !ConsoleConfigUtil.isValidUser(string3, this.configProperties)) {
            object = this.startFlag ? START_CMD : RESTART_CMD;
            ConsoleConfigLog.log(1, "log_adm_01", (String)object, string3);
            System.err.println("User " + string + " is not a valid entity.");
            System.exit(1);
        }
        if ((string3 == null || string3.trim().length() == 0) && (string2 = ((Properties)(object = this.getServiceProperties())).getProperty(this.SERVICE_USERNAME_PROP)) != null && string2.length() > 0) {
            string3 = string2;
        }
        if (string3 == null || string3.length() == 0) {
            string3 = this.configProperties.getProperty("console_user");
        }
        if (string3 == null || string3.length() == 0) {
            string3 = System.getProperty("user.name");
        }
        return string3;
    }

    private ArrayList setJvmOptions(Properties properties, Properties properties2) {
        Object object;
        String string = this.stripQuotes(this.configProperties.getProperty("java_options"));
        if (string == null || string.length() == 0) {
            string = "-server -Xmx128m -XX:+UseParallelGC -XX:ParallelGCThreads=4";
        }
        ArrayList arrayList = new ArrayList();
        String string2 = properties.getProperty("java.options.clear");
        if (string2 == null || !string2.toLowerCase().equals("true")) {
            arrayList = ConsoleConfigUtil.parseOptions(string);
        }
        if ((string2 = properties.getProperty("java.options")) != null && string2.length() > 0) {
            object = ConsoleConfigUtil.parseOptions(string2);
            arrayList = ConsoleConfigUtil.mergeJvmOptions(arrayList, (ArrayList)object);
        }
        string = "";
        object = arrayList.iterator();
        while (object.hasNext()) {
            string2 = (String)object.next();
            string = string + " " + string2;
        }
        this.configProperties.setProperty("java_options", string);
        if (properties2 != null) {
            ArrayList arrayList2 = ConsoleConfigUtil.getJvmOptions(properties2);
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    private Properties getServiceProperties() {
        Properties properties = null;
        String string = this.configProperties.getProperty("console_conf") + File.separator + this.configProperties.getProperty("console_instance") + File.separator + "service.properties";
        File file = new File(string);
        if (file.exists()) {
            try {
                properties = ConsoleConfigUtil.loadProperties(string);
            }
            catch (Exception exception) {
                ConsoleConfigLog.log(1, "driver_err_44", string);
                ConsoleConfigLog.log(1, exception);
            }
        }
        if (properties == null) {
            properties = new Properties();
        }
        return properties;
    }

    private void getConfigProperties() throws ConsoleConfigException {
        String string = System.getProperty("com.sun.web.console.conf");
        if (string == null || string.length() == 0) {
            ConsoleConfigException consoleConfigException = new ConsoleConfigException("driver_err_01", "com.sun.web.console.conf");
            ConsoleConfigLog.log(1, (Throwable)((Object)consoleConfigException));
        }
        this.configProperties = ConsoleConfigUtil.getEnvProperties(string, this.consoleInstanceName);
    }

    private String stripQuotes(String string) {
        String string2 = string;
        if (string2 != null && string2.startsWith("\"") && (string2 = string2.substring(1)).endsWith("\"")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    private int getStatTimeout() {
        int n = 45;
        try {
            String string = this.configProperties.getProperty("container_status_timeout");
            if (string != null && (n = Integer.parseInt(string)) < 5) {
                n = 5;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) throws ConsoleConfigException {
        Object object;
        ConsoleConfigDriver consoleConfigDriver = new ConsoleConfigDriver();
        ConsoleConfigException consoleConfigException = null;
        consoleConfigDriver.setupDriver(stringArray);
        if (consoleConfigDriver.versionFlag) {
            String string = consoleConfigDriver.messages.getString("driver_msg_11") + " " + ConsoleInfo.getDisplayVersion();
            System.out.println(string);
            System.exit(0);
        }
        if (consoleConfigDriver.helpFlag) {
            consoleConfigDriver.usage(0);
        }
        if (consoleConfigDriver.statusFlag) {
            int n = 1;
            object = "unknown";
            try {
                int n2 = consoleConfigDriver.configService.statServer();
                object = n2 == 0 ? (consoleConfigDriver.parseableFlag ? PARSEABLE_STATUS_RUNNING : consoleConfigDriver.messages.getString("driver_msg_00")) : (n2 == 1 ? (consoleConfigDriver.parseableFlag ? PARSEABLE_STATUS_STOPPED : consoleConfigDriver.messages.getString("driver_msg_01")) : (consoleConfigDriver.parseableFlag ? PARSEABLE_STATUS_UNKNOWN : consoleConfigDriver.messages.getString("driver_msg_13")));
                n = 0;
            }
            catch (Exception exception) {
                ConsoleConfigLog.log(1, exception);
                n = 1;
                object = consoleConfigDriver.messages.getString("driver_err_41");
            }
            System.out.println((String)object);
            System.exit(n);
        }
        consoleConfigDriver.checkSupportingProducts();
        if (consoleConfigDriver.enableFlag) {
            consoleConfigDriver.setStartOnBoot(true);
            System.exit(0);
        }
        if (consoleConfigDriver.disableFlag) {
            consoleConfigDriver.setStartOnBoot(false);
            System.exit(0);
        }
        if (consoleConfigDriver.stopFlag || consoleConfigDriver.restartFlag) {
            int n = consoleConfigDriver.configService.statServer();
            if (n != 1) {
                consoleConfigException = new ConsoleConfigException("driver_msg_16", ConsoleInfo.getDisplayVersion());
                System.out.println(consoleConfigException.getLocalizedMessage());
                consoleConfigDriver.stopContainer(false);
                n = consoleConfigDriver.checkStatus(1);
                if (n != 1) {
                    consoleConfigException = new ConsoleConfigException("driver_err_50");
                    ConsoleConfigLog.log(1, (Throwable)((Object)consoleConfigException));
                    System.err.println(consoleConfigException.getLocalizedMessage());
                    consoleConfigDriver.stopContainer(true);
                }
            }
            if (consoleConfigDriver.stopFlag) {
                consoleConfigException = new ConsoleConfigException("driver_msg_19");
                System.out.println(consoleConfigException.getLocalizedMessage());
                System.exit(0);
            }
        }
        if (consoleConfigDriver.startFlag || consoleConfigDriver.restartFlag) {
            void var12_23;
            int n;
            consoleConfigDriver.createDomain();
            int n4 = consoleConfigDriver.configService.statServer();
            if (n4 == 0) {
                consoleConfigException = new ConsoleConfigException("driver_msg_18");
                System.out.println(consoleConfigException.getLocalizedMessage());
                System.exit(0);
            }
            if (n4 != 1) {
                consoleConfigException = new ConsoleConfigException("driver_msg_13");
                ConsoleConfigLog.log(1, (Throwable)((Object)consoleConfigException));
                System.out.println(consoleConfigException.getLocalizedMessage());
                consoleConfigException = new ConsoleConfigException("driver_msg_15");
                System.err.println(consoleConfigException.getLocalizedMessage());
                System.exit(1);
            }
            consoleConfigException = new ConsoleConfigException("driver_msg_17", ConsoleInfo.getDisplayVersion());
            System.out.println(consoleConfigException.getLocalizedMessage());
            object = new ConsoleConfigUpgrade();
            ((ConsoleConfigUpgrade)object).registerDeferredObjects(consoleConfigDriver.configProperties);
            consoleConfigDriver.startContainer("admin");
            String string = consoleConfigDriver.configProperties.getProperty("console_conf") + File.separator + consoleConfigDriver.configProperties.getProperty("console_instance") + File.separator + "prereg";
            ConsoleConfigRegnot consoleConfigRegnot = new ConsoleConfigRegnot(string);
            ConsoleConfigRegistrationResolver consoleConfigRegistrationResolver = new ConsoleConfigRegistrationResolver(consoleConfigDriver.configProperties);
            SectionedProperties sectionedProperties = null;
            SectionedProperties sectionedProperties2 = null;
            Properties[] propertiesArray = null;
            String string2 = null;
            try {
                Properties properties;
                ArrayList arrayList;
                ArrayList[] arrayListArray;
                string2 = "Error from one-time special configuration";
                boolean n3 = consoleConfigDriver.initialConfig();
                string2 = "driver_err_30";
                sectionedProperties = consoleConfigRegnot.loadAll();
                consoleConfigRegistrationResolver.loadCache();
                n = 0;
                string2 = "driver_err_31";
                ConsoleConfigLog.log(3, "driver_msg_06");
                sectionedProperties2 = sectionedProperties.select("jar");
                String[] stringArray2 = consoleConfigRegistrationResolver.resolveJars(consoleConfigDriver.configService, sectionedProperties2);
                n = consoleConfigRegistrationResolver.deploySharedJars(consoleConfigDriver.configService, stringArray2);
                boolean bl = false;
                string2 = "driver_err_32";
                ConsoleConfigLog.log(3, "driver_msg_07");
                sectionedProperties2 = sectionedProperties.select("loginmodule");
                propertiesArray = consoleConfigRegistrationResolver.resolveLoginModules(sectionedProperties2);
                bl = consoleConfigRegistrationResolver.deployLoginModules(consoleConfigDriver.configService, propertiesArray);
                boolean bl2 = false;
                string2 = "driver_err_61";
                String string3 = consoleConfigDriver.configProperties.getProperty("console_native");
                String[] stringArray3 = consoleConfigRegistrationResolver.resolveNativeLibraryPaths(consoleConfigDriver.configService, string3);
                bl2 = consoleConfigRegistrationResolver.deployNativeLibraryPaths(consoleConfigDriver.configService, stringArray3);
                boolean bl3 = false;
                string2 = "driver_err_62";
                ConsoleConfigLog.log(3, "driver_msg_09");
                Properties properties2 = null;
                if (consoleConfigRegnot.exists("console", "jvmoptions")) {
                    properties2 = consoleConfigRegnot.read("console", "jvmoptions");
                }
                if ((arrayListArray = consoleConfigRegistrationResolver.resolveJvmOptions(arrayList = consoleConfigDriver.setJvmOptions(properties = consoleConfigDriver.getServiceProperties(), properties2))) != null) {
                    bl3 = consoleConfigRegistrationResolver.deployJvmOptions(consoleConfigDriver.configService, arrayListArray[0], arrayListArray[1]);
                }
                if (n != 0 || bl || bl3 || bl2 || n3) {
                    string2 = "driver_err_33";
                    consoleConfigDriver.configService.restartServer("admin");
                }
                string2 = "driver_err_34";
                ConsoleConfigLog.log(3, "driver_msg_08");
                sectionedProperties2 = sectionedProperties.select("webapp");
                consoleConfigRegistrationResolver.resolveWebapps(consoleConfigDriver.configService, sectionedProperties2);
                propertiesArray = consoleConfigRegistrationResolver.getUndeployWebapps();
                consoleConfigRegistrationResolver.undeployWebModules(consoleConfigDriver.configService, propertiesArray);
                propertiesArray = consoleConfigRegistrationResolver.getDeployWebapps();
                consoleConfigRegistrationResolver.deployWebModules(consoleConfigDriver.configService, propertiesArray);
                propertiesArray = consoleConfigRegistrationResolver.getReloadWebapps();
                consoleConfigRegistrationResolver.reloadWebModules(consoleConfigDriver.configService, propertiesArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                consoleConfigException = new ConsoleConfigException(string2, exception.getLocalizedMessage());
                ConsoleConfigLog.log(1, exception);
                ConsoleConfigLog.log(1, (Throwable)((Object)consoleConfigException));
                ConsoleConfigLog.close();
                System.err.println(consoleConfigException.getLocalizedMessage());
                System.exit(1);
            }
            consoleConfigDriver.startContainer("user");
            n4 = consoleConfigDriver.checkStatus(0);
            boolean bl = false;
            n = 0;
            string2 = "";
            switch (n4) {
                case 0: {
                    string2 = "driver_msg_18";
                    n = 3;
                    boolean bl4 = false;
                    break;
                }
                case 1: {
                    string2 = "driver_err_58";
                    n = 1;
                    boolean bl5 = true;
                    break;
                }
                default: {
                    string2 = "driver_err_49";
                    n = 3;
                    boolean bl6 = false;
                }
            }
            consoleConfigException = new ConsoleConfigException(string2);
            System.out.println(consoleConfigException.getLocalizedMessage());
            ConsoleConfigLog.log(n, (Throwable)((Object)consoleConfigException));
            System.exit((int)var12_23);
        }
    }
}

