/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.registration;

import com.sun.management.services.authorization.AuthorizationService;
import com.sun.management.services.authorization.AuthorizationServiceFactory;
import com.sun.management.services.registration.CategoryElement;
import java.security.Permission;
import javax.security.auth.Subject;

public class CategoryApp
implements CategoryElement {
    private String appname;
    private String appdesc;
    private String catname;
    private String plugname;
    private String bundlename;
    private String keyname;
    private String keydesc;
    private String keytip;
    private String url;
    private String authType;
    private Permission authPerm;
    private boolean bNameLocalizable;
    private boolean bDescLocalizable;
    private String locname;
    private String loctip;
    private String locdesc;

    public CategoryApp(String string, String string2) {
        this.appname = string;
        this.appdesc = null;
        this.catname = string2;
        this.plugname = null;
        this.bundlename = null;
        this.keyname = null;
        this.keydesc = null;
        this.keytip = null;
        this.url = null;
        this.authType = null;
        this.authPerm = null;
        this.locname = null;
        this.locdesc = null;
        this.loctip = null;
        this.bNameLocalizable = false;
        this.bDescLocalizable = false;
    }

    public String getName() {
        return this.appname;
    }

    public String getLocalizedName() {
        return this.locname == null ? this.appname : this.locname;
    }

    public void setLocalizedName(String string) {
        this.locname = string;
    }

    public String getLocalizedTooltip() {
        return this.loctip;
    }

    public void setLocalizedTooltip(String string) {
        this.loctip = string;
    }

    public String getCategoryName() {
        return this.catname;
    }

    public String getNameKey() {
        return this.keyname;
    }

    public String getTooltipKey() {
        return this.keytip;
    }

    public CategoryElement[] getElements() {
        return new CategoryElement[0];
    }

    public CategoryElement[] getSubcategories() {
        return new CategoryElement[0];
    }

    public CategoryElement[] getApplications() {
        return new CategoryElement[0];
    }

    public boolean isNameLocalizable() {
        return this.bNameLocalizable;
    }

    public String getBundleName() {
        return this.bundlename;
    }

    public String getPluginName() {
        return this.plugname;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDescKey() {
        return this.keydesc;
    }

    public String getLocalizedDesc() {
        return this.locdesc == null ? this.appdesc : this.locdesc;
    }

    public void setLocalizedDesc(String string) {
        this.locdesc = string;
    }

    public boolean isDescLocalizable() {
        return this.bDescLocalizable;
    }

    void setPluginName(String string) {
        this.plugname = string;
    }

    void setBundleName(String string) {
        this.bundlename = string;
    }

    void setUrl(String string) {
        this.url = string;
    }

    void setNameKey(String string) {
        this.keyname = string;
    }

    void setNameLocalizable(boolean bl) {
        this.bNameLocalizable = bl;
    }

    void setTooltipKey(String string) {
        this.keytip = string;
    }

    void setAuthType(String string) {
        this.authType = string;
    }

    void setAuthPerm(Permission permission) {
        this.authPerm = permission;
    }

    void setDesc(String string) {
        this.appdesc = string;
    }

    void setDescKey(String string) {
        this.keydesc = string;
    }

    void setDescLocalizable(boolean bl) {
        this.bDescLocalizable = bl;
    }

    void addElement(CategoryElement categoryElement) {
    }

    CategoryElement copy() {
        CategoryApp categoryApp = new CategoryApp(this.appname, this.catname);
        categoryApp.setPluginName(this.plugname);
        categoryApp.setBundleName(this.bundlename);
        categoryApp.setUrl(this.url);
        categoryApp.setNameKey(this.keyname);
        categoryApp.setNameLocalizable(this.bNameLocalizable);
        categoryApp.setDesc(this.appdesc);
        categoryApp.setDescKey(this.keydesc);
        categoryApp.setDescLocalizable(this.bDescLocalizable);
        categoryApp.setTooltipKey(this.keytip);
        categoryApp.setAuthType(this.authType);
        categoryApp.setAuthPerm(this.authPerm);
        return categoryApp;
    }

    boolean checkAccess(Subject subject) {
        boolean bl = true;
        if (this.authType != null && this.authType.length() > 0) {
            AuthorizationService authorizationService = null;
            try {
                authorizationService = AuthorizationServiceFactory.getAuthorizationService(this.authType);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (authorizationService != null) {
                try {
                    bl = authorizationService.checkPermission(subject, this.authPerm);
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
        }
        return bl;
    }
}

