/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.registration;

import com.sun.management.services.registration.CategoryApp;
import com.sun.management.services.registration.CategoryElement;
import java.util.ArrayList;

public class Category
implements CategoryElement {
    private String catname;
    private String keyname;
    private String keytip;
    private int ordernum;
    private boolean bSyscat;
    private ArrayList elements;
    private String locname;
    private String loctooltip;

    Category(String string) {
        this.catname = string;
        this.ordernum = 0;
        this.bSyscat = false;
        this.keyname = "category.name." + this.catname.replace(' ', '_').toLowerCase();
        this.keytip = "category.tooltip." + this.catname.replace(' ', '_').toLowerCase();
        this.elements = new ArrayList();
        this.locname = null;
        this.loctooltip = null;
    }

    public String getName() {
        return this.catname;
    }

    public String getCategoryName() {
        return this.catname;
    }

    public String getLocalizedName() {
        return this.locname == null ? this.catname : this.locname;
    }

    public void setLocalizedName(String string) {
        this.locname = string;
    }

    public String getLocalizedTooltip() {
        return this.loctooltip == null ? this.catname : this.loctooltip;
    }

    public void setLocalizedTooltip(String string) {
        this.loctooltip = string;
    }

    public String getNameKey() {
        return this.keyname;
    }

    public String getTooltipKey() {
        return this.keytip;
    }

    public CategoryElement[] getElements() {
        CategoryElement[] categoryElementArray = null;
        if (this.elements != null && this.elements.size() > 0) {
            categoryElementArray = new CategoryElement[this.elements.size()];
            categoryElementArray = this.elements.toArray(categoryElementArray);
        } else {
            categoryElementArray = new CategoryElement[]{};
        }
        return categoryElementArray;
    }

    public CategoryElement[] getSubcategories() {
        CategoryElement[] categoryElementArray;
        ArrayList<CategoryElement> arrayList = new ArrayList<CategoryElement>();
        if (this.elements != null && this.elements.size() > 0) {
            categoryElementArray = this.elements.iterator();
            while (categoryElementArray.hasNext()) {
                CategoryElement categoryElement = (CategoryElement)categoryElementArray.next();
                if (!(categoryElement instanceof Category)) continue;
                arrayList.add(categoryElement);
            }
        }
        categoryElementArray = new CategoryElement[arrayList.size()];
        if (arrayList.size() > 0) {
            categoryElementArray = arrayList.toArray(categoryElementArray);
        }
        return categoryElementArray;
    }

    public CategoryElement[] getApplications() {
        CategoryElement[] categoryElementArray;
        ArrayList<CategoryElement> arrayList = new ArrayList<CategoryElement>();
        if (this.elements != null && this.elements.size() > 0) {
            categoryElementArray = this.elements.iterator();
            while (categoryElementArray.hasNext()) {
                CategoryElement categoryElement = (CategoryElement)categoryElementArray.next();
                if (!(categoryElement instanceof CategoryApp)) continue;
                arrayList.add(categoryElement);
            }
        }
        categoryElementArray = new CategoryElement[arrayList.size()];
        if (arrayList.size() > 0) {
            categoryElementArray = arrayList.toArray(categoryElementArray);
        }
        return categoryElementArray;
    }

    public int getOrderNumber() {
        return this.ordernum;
    }

    public boolean isSystemCategory() {
        return this.bSyscat;
    }

    void setName(String string) {
        this.catname = string;
    }

    void addElement(CategoryElement categoryElement) {
        if (this.elements == null) {
            this.elements = new ArrayList();
        }
        this.elements.add(categoryElement);
    }

    CategoryElement copy() {
        Category category = new Category(this.catname);
        category.setOrderNumber(this.ordernum);
        category.setSystemCategory(this.bSyscat);
        return category;
    }

    void setOrderNumber(int n) {
        this.ordernum = n;
    }

    void setSystemCategory(boolean bl) {
        this.bSyscat = bl;
    }
}

