/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.security;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.security.ClientSecurityContext;
import com.sun.wbem.security.PasswordCredential;
import com.sun.wbem.security.SecurityUtil;
import com.sun.wbem.security.UserPrincipal;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Arrays;

public class HttpClientSecurity
implements ClientSecurityContext {
    private String mechanism = "Default";
    private CIMNameSpace nameSpace;
    private Principal principal;
    private String userName;
    private byte[] userPswd;
    private String nsHost;
    private String nsPath;
    private boolean bEstablished = false;
    private String initialKey = "InitialKey";
    private byte[] sessionId = null;
    private byte[] encryptKey = null;
    private static final int MAX_DATA_SIZE = 15;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public HttpClientSecurity() throws NoSuchAlgorithmException {
        this.nameSpace = null;
        this.principal = null;
        this.userName = null;
        this.userPswd = new byte[0];
        this.nsHost = null;
        this.nsPath = "";
    }

    public HttpClientSecurity(CIMNameSpace ns, Principal prin, Object cred) throws NoSuchAlgorithmException, CIMException {
        this.setNameSpace(ns);
        this.setPrincipal(prin);
        this.setCredential(cred);
    }

    public String getMechanism() {
        return this.mechanism;
    }

    public String getServerName() {
        return this.nsHost;
    }

    public CIMNameSpace getNameSpace() {
        return this.nameSpace;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public boolean isEstablished() {
        return this.bEstablished;
    }

    public void setNameSpace(CIMNameSpace namespace) throws CIMException {
        if (namespace == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        this.nameSpace = namespace;
        this.nsHost = namespace.getHost();
        this.nsPath = namespace.getNameSpace();
    }

    public void setPrincipal(Principal prin) throws CIMException {
        if (prin == null || !(prin instanceof UserPrincipal)) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        this.principal = prin;
        this.userName = prin.getName();
        if (this.userName == null || this.userName.trim().length() == 0) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
    }

    public void setCredential(Object cred) throws CIMException {
        String tPswd = null;
        if (cred != null) {
            if (cred instanceof PasswordCredential) {
                tPswd = new String(((PasswordCredential)cred).getUserPassword());
            } else if (cred instanceof String) {
                tPswd = new String((String)cred);
            }
        }
        if (tPswd == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        int len = tPswd.length();
        this.userPswd = new byte[len];
        for (int i = 0; i < len; ++i) {
            char c = tPswd.charAt(i);
            this.userPswd[i] = (byte)c;
        }
    }

    public void dispose() {
        this.bEstablished = false;
        this.nameSpace = null;
        this.principal = null;
        this.userName = null;
        Arrays.fill(this.userPswd, (byte)0);
        this.userPswd = new byte[0];
        this.nsHost = null;
        this.nsPath = "";
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserPassword() {
        String tPswd = null;
        if (this.userPswd.length > 0) {
            char[] ca = new char[this.userPswd.length];
            for (int i = 0; i < this.userPswd.length; ++i) {
                ca[i] = (char)(0 | this.userPswd[i] & 0xFF);
            }
            tPswd = new String(ca);
        }
        return tPswd;
    }

    public String getSecurityToken(String[] sarray) throws CIMException {
        String st = null;
        return st;
    }

    public String trans51Format(String inData) throws CIMException {
        int i;
        if (inData.length() > 15 || this.encryptKey == null) {
            throw new CIMException("CIM_ERR_FAILED", "Bad data length or null encrypt key");
        }
        byte[] pwb = inData.getBytes();
        int len = this.encryptKey.length;
        byte[] rb = new byte[len];
        System.arraycopy(this.encryptKey, 0, rb, 0, len);
        byte[] pad = new byte[len];
        SecurityUtil.secrand.nextBytes(pad);
        for (i = 0; i < pwb.length; ++i) {
            int n = i;
            rb[n] = (byte)(rb[n] ^ pwb[i]);
        }
        int n = i++;
        rb[n] = (byte)(rb[n] ^ 0);
        while (i < rb.length) {
            int n2 = i;
            rb[n2] = (byte)(rb[n2] ^ pad[i]);
            ++i;
        }
        String val = this.toHex(rb);
        return val;
    }

    private String toHex(byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            sb.append(hex[data[i] >> 4 & 0xF]);
            sb.append(hex[data[i] & 0xF]);
        }
        return sb.toString();
    }

    private byte[] fromHex(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        byte[] ba = new byte[len / 2];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            int k;
            ba[j] = 0;
            boolean ok = false;
            char c = str.charAt(i);
            for (k = 0; k < hex.length; ++k) {
                if (c != hex[k]) continue;
                ba[j] = (byte)(k << 4 & 0xF0);
                ok = true;
                break;
            }
            if (!ok) {
                return null;
            }
            ok = false;
            c = str.charAt(++i);
            for (k = 0; k < hex.length; ++k) {
                if (c != hex[k]) continue;
                ba[j] = (byte)(ba[j] | (byte)(k & 0xF));
                ok = true;
                break;
            }
            if (!ok) {
                return null;
            }
            ++j;
        }
        return ba;
    }
}

