/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.security;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMSecurityException;
import com.sun.wbem.client.ClientProps;
import com.sun.wbem.security.ClientSecurityContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClientSecurityFactory {
    private static final String PROP_SECURITY = "security";
    private static final String PROP_TRANSPORT = "transport";
    private static final String PROP_PROTOCOL = "protocol";
    private static final String PROP_MECHANISM = "mechanism";
    private static final String PROP_CLASS = "client.class";
    private static final String PROP_DEFAULT_SECURITY = "security.default";
    private static final String HTTP_PROTOCOL = "http";
    private static final String RMI_PROTOCOL = "rmi";
    private static final String DFLT_HTTP_SECURITY = "httpbasic";
    private static final String DFLT_RMI_SECURITY = "rmidigest";
    private static final String DFLT_HTTPBASIC_CLASS = "com.sun.wbem.security.HttpClientSecurity";
    private static final String DFLT_RMIDIGEST_CLASS = "com.sun.wbem.security.RmiClientSecurity";

    public static ClientSecurityContext createClientSecurity(CIMNameSpace ns, Principal principal, Object credential, String mechanism, int protocol) throws CIMException {
        String list;
        String proto;
        String name = null;
        String mech = null;
        if (mechanism != null) {
            mech = mechanism.toLowerCase();
        }
        if ((proto = ClientProps.getProperty(name = "transport.protocol." + protocol)) == null) {
            if (protocol == 0) {
                proto = HTTP_PROTOCOL;
            } else if (protocol == 1) {
                proto = RMI_PROTOCOL;
            }
        }
        if (proto == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", PROP_PROTOCOL);
        }
        proto = proto.toLowerCase();
        if ((mech == null || mech.trim().length() == 0) && (mech = ClientProps.getProperty(name = "transport." + proto + "." + PROP_DEFAULT_SECURITY)) == null) {
            if (proto.equals(HTTP_PROTOCOL)) {
                mech = DFLT_HTTP_SECURITY;
            } else if (proto.equals(RMI_PROTOCOL)) {
                mech = DFLT_RMI_SECURITY;
            } else {
                throw new CIMSecurityException("CIM_ERR_NOT_FOUND", "default");
            }
        }
        if ((list = ClientProps.getProperty(name = "security." + proto + "." + PROP_TRANSPORT)) == null) {
            if (mech.equals(DFLT_HTTP_SECURITY)) {
                list = HTTP_PROTOCOL;
            } else if (mech.equals(DFLT_RMI_SECURITY)) {
                list = RMI_PROTOCOL;
            }
        }
        if (list == null) {
            throw new CIMSecurityException("CIM_ERR_NOT_FOUND", PROP_MECHANISM);
        }
        Vector vlist = ClientSecurityFactory.parseList(list);
        if (!vlist.contains(proto)) {
            throw new CIMSecurityException("CIM_ERR_NOT_FOUND", PROP_MECHANISM);
        }
        name = "security." + mech + "." + PROP_CLASS;
        String classname = ClientProps.getProperty(name);
        if (classname == null) {
            if (mech.equals(DFLT_HTTP_SECURITY)) {
                classname = DFLT_HTTPBASIC_CLASS;
            } else if (mech.equals(DFLT_RMI_SECURITY)) {
                classname = DFLT_RMIDIGEST_CLASS;
            }
        }
        if (classname == null) {
            throw new CIMSecurityException("CIM_ERR_NOT_FOUND", PROP_MECHANISM);
        }
        Class<?> cl = null;
        try {
            cl = Class.forName(classname);
        }
        catch (Exception ex) {
            throw new CIMSecurityException("CIM_ERR_NOT_FOUND", PROP_MECHANISM);
        }
        ClientSecurityContext cs = null;
        try {
            Class[] paramTypes = new Class[]{CIMNameSpace.class, Principal.class, Object.class};
            Object[] paramList = new Object[]{ns, principal, credential};
            Constructor<?> ctr = cl.getConstructor(paramTypes);
            cs = (ClientSecurityContext)ctr.newInstance(paramList);
        }
        catch (InvocationTargetException ex) {
            Throwable ax = ex.getTargetException();
            if (ax instanceof CIMException) {
                CIMException cex = (CIMException)ax;
                throw cex;
            }
            throw new CIMSecurityException("CIM_ERR_FAILED", (Object)ax);
        }
        catch (Exception ex) {
            throw new CIMSecurityException("CIM_ERR_FAILED", (Object)ex);
        }
        return cs;
    }

    public static String[] getSecurityMechanisms() {
        String name = "security.mechanism";
        return ClientProps.getPropertyList(name);
    }

    private static Vector parseList(String list) {
        Vector<String> v = new Vector<String>(10);
        StringTokenizer st = new StringTokenizer(list, ",");
        while (st.hasMoreElements()) {
            String elem = (String)st.nextElement();
            v.addElement(elem);
        }
        return v;
    }
}

