/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client.http;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.XmlGenericId;
import com.sun.wbem.cim.XmlInstance;
import com.sun.wbem.client.XMLParser;
import com.sun.wbem.client.http.Handler;
import com.sun.wbem.client.http.HttpExURLConnection;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.TreeWalker;
import com.sun.xml.tree.XmlDocument;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Random;
import org.w3c.dom.Node;

public class HttpURLConnection
extends HttpExURLConnection {
    private boolean useMPost = true;
    private static final String ns = "http://www.dmtf.org/cim/mapping/http/v1.0";
    private String prefix = "";

    public HttpURLConnection(URL url) throws IOException {
        this(url, new Handler(), true);
    }

    public HttpURLConnection(URL url, boolean useMPost) throws IOException {
        this(url, new Handler(), useMPost);
    }

    private HttpURLConnection(URL url, Handler handler, boolean useMPost) throws IOException {
        super(url, handler);
        this.useMPost = useMPost;
    }

    public void encapsulate(XmlDocument entity) throws CIMException {
        if (this.useMPost) {
            try {
                this.setRequestMethod("M-POST");
            }
            catch (ProtocolException e) {
                throw new CIMException("XMLERROR", (Object)e);
            }
            this.setPrefix();
        } else {
            try {
                this.setRequestMethod("POST");
            }
            catch (ProtocolException e) {
                throw new CIMException("XMLERROR", (Object)e);
            }
        }
        this.setRequestProperties(entity);
    }

    private void setPrefix() {
        Random generator = new Random();
        int rand = Math.abs(generator.nextInt() % 100);
        this.prefix = Integer.toString(rand);
        this.prefix = this.prefix.length() == 1 ? "0" + this.prefix : this.prefix;
    }

    /*
     * Unable to fully structure code
     */
    private void setRequestProperties(XmlDocument msg) throws CIMException {
        if (this.useMPost) {
            this.setRequestProperty("Man", "http://www.dmtf.org/cim/mapping/http/v1.0;ns=" + this.prefix);
            this.prefix = this.prefix + "-";
        }
        isBatch = false;
        xi = new XmlInstance();
        walker = new TreeWalker((Node)msg);
        roottag = XmlInstance.CIM;
        nodename = null;
        callname = null;
        node = walker.getCurrent();
        while (node != null) {
            block6: {
                block8: {
                    block7: {
                        nodename = node.getNodeName();
                        if (nodename.equals(roottag)) break block6;
                        if (!nodename.equals(XmlInstance.MESSAGE)) break block7;
                        this.setRequestProperty(this.prefix + "CIMProtocolVersion", ((ElementNode)node).getAttribute("PROTOCOLVERSION"));
                        break block6;
                    }
                    if (!nodename.equals(XmlInstance.MULTIREQ)) break block8;
                    this.setRequestProperty(this.prefix + "CIMBatch", "CIMBatch");
                    isBatch = true;
                    break block6;
                }
                if (nodename.equals(XmlInstance.SIMPLEREQ)) break block6;
                if (nodename.equals(XmlInstance.IMETHODCALL)) ** GOTO lbl-1000
                if (nodename.equals(XmlInstance.METHODCALL)) lbl-1000:
                // 2 sources

                {
                    this.setRequestProperty(this.prefix + "CIMOperation", "MethodCall");
                    if (!isBatch) {
                        this.setRequestProperty(this.prefix + "CIMMethod", ((ElementNode)node).getAttribute("NAME"));
                    }
                } else if (nodename.startsWith("LOCAL")) {
                    if (isBatch) break;
                    this.setRequestProperty(this.prefix + "CIMObject", this.objectPath(node));
                    break;
                }
            }
            node = walker.getNextElement(null);
        }
    }

    private String objectPath(Node node) throws CIMException {
        String op = "";
        CIMProperty p = null;
        boolean isFirstKey = true;
        boolean isSingleton = false;
        TreeWalker walker = new TreeWalker(node);
        node = walker.getCurrent();
        while (node != null) {
            String nodename = node.getNodeName();
            if (!(nodename.equals(XmlGenericId.NAMESPACEPATH) || nodename.equals(XmlGenericId.LOCALNAMESPACEPATH) || nodename.equals(XmlGenericId.CLASSPATH) || nodename.equals(XmlGenericId.LOCALCLASSPATH) || nodename.equals(XmlGenericId.INSTANCEPATH))) {
                if (nodename.equals(XmlGenericId.LOCALINSTANCEPATH)) {
                    isSingleton = true;
                } else if (nodename.equals(XmlGenericId.NAMESPACE)) {
                    op = op.length() > 0 ? op + "/" : op;
                    op = op + ((ElementNode)node).getAttribute("NAME");
                } else if (nodename.equals(XmlGenericId.CLASSNAME)) {
                    op = op + ":" + ((ElementNode)node).getAttribute("NAME");
                } else if (nodename.equals(XmlGenericId.INSTANCENAME)) {
                    op = op + ":" + ((ElementNode)node).getAttribute("CLASSNAME");
                } else if (nodename.equals(XmlGenericId.KEYBINDING)) {
                    isSingleton = false;
                    op = op + (isFirstKey ? "." : ",");
                    isFirstKey = false;
                    op = op + ((ElementNode)node).getAttribute("NAME");
                    XMLParser parser = new XMLParser();
                    p = XMLParser.getCIMProperty(node);
                } else if (nodename.equals(XmlGenericId.KEYVALUE)) {
                    isSingleton = false;
                    op = op + "=";
                    String type = ((ElementNode)node).getAttribute("VALUETYPE");
                    String value = p.getValue().getValue().toString();
                    StringBuffer buf = new StringBuffer(value.length());
                    for (int i = 0; i < value.length(); ++i) {
                        if (value.charAt(i) == '\"') {
                            buf.append("\\");
                        }
                        buf.append(value.charAt(i));
                    }
                    value = buf.toString();
                    op = op + (type.equals("string") ? "\"" + value + "\"" : value);
                } else if (nodename.equals(XmlGenericId.VALUE_REFERENCE)) {
                    isSingleton = false;
                    op = op + "=" + this.objectPath(walker.getNextElement(null));
                }
            }
            node = walker.getNextElement(null);
        }
        op = op + (isSingleton ? "=@" : "");
        return URLEncoder.encode(op);
    }
}

