/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client.http;

import com.sun.wbem.client.http.AuthenticationInfo;
import com.sun.wbem.client.http.HeaderParser;
import com.sun.wbem.client.http.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

class DigestAuthentication
extends AuthenticationInfo {
    private PasswordAuthentication pw;
    private URL url;
    private String authMethod;
    private static final char[] charArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public DigestAuthentication(URL url, String realm, String authMethod, PasswordAuthentication pw) {
        super('s', url.getHost(), url.getPort(), realm);
        this.authMethod = authMethod;
        this.url = url;
        this.pw = pw;
    }

    boolean supportsPreemptiveAuthorization() {
        return false;
    }

    String getHeaderName() {
        return "";
    }

    String getHeaderValue() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setHeaders(HttpURLConnection conn, HeaderParser p) {
        String response;
        String algorithm;
        String nonce = p.findValue("nonce");
        String uri = this.url.getFile();
        if (nonce == null || this.authMethod == null || this.pw == null || this.realm == null) {
            return false;
        }
        if (this.authMethod.length() >= 1) {
            this.authMethod = Character.toUpperCase(this.authMethod.charAt(0)) + this.authMethod.substring(1).toLowerCase();
        }
        if ((algorithm = p.findValue("algorithm")) == null || "".equals(algorithm)) {
            algorithm = "MD5";
        }
        char[] passwd = this.pw.getPassword();
        try {
            response = this.computeDigest(this.pw.getUserName(), passwd, this.realm, conn.getMethod(), uri, nonce, algorithm);
            if (passwd != null) {
                Arrays.fill(passwd, ' ');
            }
            passwd = null;
        }
        catch (NoSuchAlgorithmException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (passwd != null) {
                Arrays.fill(passwd, ' ');
            }
        }
        String value = this.authMethod + " username=\"" + this.pw.getUserName() + "\", realm=\"" + this.realm + "\", nonce=\"" + nonce + "\", uri=\"" + uri + "\", response=\"" + response + "\"";
        conn.setAuthenticationProperty("Authorization", value);
        return true;
    }

    private String computeDigest(String userName, char[] password, String realm, String connMethod, String requestURI, String nonceString, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        String A1 = userName + ":" + realm + ":";
        String HashA1 = this.encode(A1, password, md);
        String A2 = connMethod + ":" + requestURI;
        String HashA2 = this.encode(A2, null, md);
        String combo = HashA1 + ":" + nonceString + ":" + HashA2;
        String finalHash = this.encode(combo, null, md);
        return finalHash;
    }

    private String encode(String src, char[] passwd, MessageDigest md) {
        md.update(src.getBytes());
        if (passwd != null) {
            byte[] passwdBytes = new byte[passwd.length];
            for (int i = 0; i < passwd.length; ++i) {
                passwdBytes[i] = (byte)passwd[i];
            }
            md.update(passwdBytes);
            Arrays.fill(passwdBytes, (byte)0);
        }
        byte[] digest = md.digest();
        StringBuffer res = new StringBuffer(digest.length * 2);
        for (int i = 0; i < digest.length; ++i) {
            int hashchar = digest[i] >>> 4 & 0xF;
            res.append(charArray[hashchar]);
            hashchar = digest[i] & 0xF;
            res.append(charArray[hashchar]);
        }
        return res.toString();
    }
}

