/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMTransportException;
import com.sun.wbem.client.CIMClientAPI;
import com.sun.wbem.client.CIMListener;
import com.sun.wbem.client.ClientProps;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

class CIMClientFactory {
    private static final String PROP_TRANSPORT = "transport";
    private static final String PROP_PROTOCOL = "protocol";
    private static final String PROP_CLASS = "client.class";
    private static final String HTTP_PROTOCOL_NAME = "http";
    private static final String RMI_PROTOCOL_NAME = "rmi";
    private static final String HTTP_CLASS_NAME = "com.sun.wbem.client.CIMClientXML";
    private static final String RMI_CLASS_NAME = "com.sun.wbem.client.CIMClientRMI";

    CIMClientFactory() {
    }

    public static CIMClientAPI getClientAPI(String version, CIMNameSpace ns, int protocol, int debug, CIMListener clientListener) throws CIMException {
        String propname = "transport.protocol." + protocol;
        String proto_name = ClientProps.getProperty(propname);
        if (proto_name == null) {
            if (protocol == 0) {
                proto_name = HTTP_PROTOCOL_NAME;
            } else if (protocol == 1) {
                proto_name = RMI_PROTOCOL_NAME;
            }
        }
        if (proto_name == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", PROP_PROTOCOL);
        }
        propname = "transport." + proto_name + "." + PROP_CLASS;
        String classname = ClientProps.getProperty(propname);
        Class<?> cl = null;
        try {
            cl = Class.forName(classname);
        }
        catch (Exception ex) {
            throw new CIMTransportException("CIM_ERR_NOT_FOUND", PROP_PROTOCOL);
        }
        CIMClientAPI cc = null;
        try {
            Class[] paramTypes = new Class[]{String.class, CIMNameSpace.class, CIMListener.class, Integer.class};
            Object[] paramList = new Object[]{version, ns, clientListener, new Integer(debug)};
            Constructor<?> ctr = cl.getConstructor(paramTypes);
            cc = (CIMClientAPI)ctr.newInstance(paramList);
        }
        catch (InvocationTargetException ex) {
            Throwable ax = ex.getTargetException();
            if (ax instanceof CIMException) {
                CIMException cex = (CIMException)ax;
                throw cex;
            }
            throw new CIMTransportException("CIM_ERR_FAILED", (Object)ax);
        }
        catch (Exception ex) {
            throw new CIMTransportException("CIM_ERR_FAILED", (Object)ex);
        }
        return cc;
    }
}

