/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cim;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMDataType;
import com.sun.wbem.cim.CIMDateTime;
import com.sun.wbem.cim.CIMElement;
import com.sun.wbem.cim.CIMFlavor;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMMethod;
import com.sun.wbem.cim.CIMParameter;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMQualifier;
import com.sun.wbem.cim.CIMQualifierType;
import com.sun.wbem.cim.CIMScope;
import com.sun.wbem.cim.CIMValue;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

class MOFFormatter
implements Serializable {
    static final long serialVersionUID = 200L;
    private final String INDENT = "    ";
    private final String TAB = "\t";
    private final String QUOTE = "\"";
    private final String SPACE = " ";
    private final String COLON = ":";
    private final String LINE = "\n";
    private static final String ANY = "any";
    private static final String AS = "as";
    private static final String ASSOCIATION = "association";
    private static final String CLASS = "class";
    private static final String DISABLEOVERRIDE = "disableoverride";
    private static final String DT_BOOL = "boolean";
    private static final String DT_CHAR16 = "char16";
    private static final String DT_DATETIME = "datetime";
    private static final String DT_REAL32 = "real32";
    private static final String DT_REAL64 = "real64";
    private static final String DT_SINT16 = "sint16";
    private static final String DT_SINT32 = "sint32";
    private static final String DT_SINT64 = "sint64";
    private static final String DT_SINT8 = "sint8";
    private static final String DT_STR = "string";
    private static final String DT_UINT16 = "uint16";
    private static final String DT_UINT32 = "uint32";
    private static final String DT_UINT64 = "uint64";
    private static final String DT_UINT8 = "uint8";
    private static final String ENABLEOVERRIDE = "enableoverride";
    private static final String FALSE = "false";
    private static final String FLAVOR = "Flavor";
    private static final String INDICATION = "indication";
    private static final String INSTANCE = "instance";
    private static final String METHOD = "method";
    private static final String NULL = "null";
    private static final String OF = "of";
    private static final String PARAMETER = "parameter";
    private static final String PRAGMA = "#pragma";
    private static final String PROPERTY = "property";
    private static final String QUALIFIER = "qualifier";
    private static final String REF = "ref";
    private static final String REFERENCE = "reference";
    private static final String RESTRICTED = "restricted";
    private static final String SCHEMA = "schema";
    private static final String SCOPE = "Scope";
    private static final String TOSUBCLASS = "tosubclass";
    private static final String TRANSLATABLE = "translatable";
    private static final String TRUE = "true";
    private boolean cimclass = true;

    public String toString(Object o) {
        String mof = "";
        if (o instanceof CIMInstance) {
            mof = this.cimInstance((CIMInstance)o);
        } else if (o instanceof CIMClass) {
            mof = this.cimClass((CIMClass)o);
        } else if (o instanceof CIMValue) {
            mof = this.cimValue((CIMValue)o);
        } else if (o instanceof CIMQualifierType) {
            mof = this.cimQualifierType((CIMQualifierType)o);
        } else if (o instanceof CIMQualifier) {
            mof = this.cimQualifier((CIMQualifier)o);
        } else if (o instanceof CIMDateTime) {
            mof = this.cimDateTime((CIMDateTime)o);
        } else if (o instanceof CIMProperty) {
            mof = this.cimProperty((CIMProperty)o);
        } else if (o instanceof CIMScope) {
            mof = this.cimScope((CIMScope)o);
        } else if (o instanceof CIMFlavor) {
            mof = this.cimFlavor((CIMFlavor)o);
        } else if (o instanceof CIMDataType) {
            mof = this.cimDataType((CIMDataType)o);
        } else if (o instanceof CIMMethod) {
            mof = this.cimMethod((CIMMethod)o);
        } else if (o instanceof CIMParameter) {
            mof = this.cimParameter((CIMParameter)o);
        }
        return mof;
    }

    public String vectorToMOFString(Vector v) {
        return this.vectorToMOFString(v, "    ", false, false, true);
    }

    public String vectorToMOFString(Vector v, String i) {
        return this.vectorToMOFString(v, i, false, false, true);
    }

    public String vectorToMOFString(Vector v, boolean b) {
        return this.vectorToMOFString(v, "    ", b, false, true);
    }

    public String vectorToMOFString(Vector v, boolean b, boolean d) {
        return this.vectorToMOFString(v, "    ", b, d, true);
    }

    public String vectorToMOFString(Vector v, boolean b, boolean d, boolean l) {
        return this.vectorToMOFString(v, "    ", b, d, l);
    }

    public String vectorToMOFString(Vector v, String indent, boolean bracketed, boolean delim, boolean lf) {
        String delimeter = "";
        delimeter = lf ? ",\n" : ", ";
        String str = new String("");
        if (v != null && !v.isEmpty()) {
            if (bracketed) {
                str = indent + "[";
            }
            for (int x = 0; x < v.size(); ++x) {
                if (x > 0) {
                    str = delim ? str.concat(delimeter + indent + " ") : str.concat("\n");
                }
                str = v.elementAt(x) instanceof CIMElement ? str.concat(this.toString(v.elementAt(x))) : (v.elementAt(x) instanceof CIMScope ? str.concat(((CIMScope)v.elementAt(x)).toString()) : (v.elementAt(x) instanceof CIMFlavor ? str.concat(((CIMFlavor)v.elementAt(x)).toString()) : str.concat("\"" + v.elementAt(x).toString() + "\"")));
            }
            if (bracketed) {
                str = str.concat("\n" + indent + "]" + "\n");
            }
        }
        return str;
    }

    public String wrapText(String textString, int numColumns) {
        String NEWLINE = "\n";
        StringTokenizer stringTokenizer = new StringTokenizer(textString, " \t\n", true);
        StringBuffer buff = new StringBuffer();
        int stringLength = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String word = stringTokenizer.nextToken();
            if (word.equals(NEWLINE)) {
                stringLength = 0;
            } else if (stringLength + word.length() > numColumns) {
                buff.append(NEWLINE);
                stringLength = 0;
            }
            if (word.equals(" ") && buff.toString().endsWith(NEWLINE)) continue;
            buff.append(word);
            stringLength += word.length();
        }
        return buff.toString();
    }

    public String cimClass(CIMClass cc) {
        String cl = "class " + cc.getName();
        if (cc.getSuperClass().length() > 0) {
            cl = cl.concat(":" + cc.getSuperClass());
        }
        return new String(this.vectorToMOFString(cc.getQualifiers(), true, true) + cl + "\n" + "{" + "\n" + this.vectorToMOFString(cc.getProperties()) + "\n" + this.vectorToMOFString(cc.getMethods()) + "\n" + "};");
    }

    public String cimValue(CIMValue cv) {
        String s = NULL;
        Object o = cv.getValue();
        if (o != null) {
            if (cv.isArrayValue()) {
                s = this.vectorToMOFString((Vector)o, "", false, true, false);
            } else {
                String q = "";
                if (new CIMDataType(8).equals(cv.getType())) {
                    q = "\"";
                }
                s = q + o.toString() + q;
            }
        }
        return new String(s);
    }

    public String cimQualifierType(CIMQualifierType cqt) {
        String scopeStr = "";
        String flavorStr = "";
        String valueStr = "";
        if (!cqt.getScope().isEmpty()) {
            scopeStr = "Scope(" + this.vectorToMOFString(cqt.getScope(), "", false, true, false) + ")";
        }
        if (!cqt.getFlavor().isEmpty()) {
            flavorStr = ", Flavor(" + this.vectorToMOFString(cqt.getFlavor(), "", false, true, false) + ")";
        }
        if (!cqt.getType().isArrayType()) {
            valueStr = " = " + cqt.getDefaultValue();
        }
        return new String("qualifier " + cqt.getName() + " : " + cqt.getType() + valueStr + ", " + scopeStr + flavorStr + ";");
    }

    public String cimQualifier(CIMQualifier cq) {
        String name = cq.getName();
        if (cq.getValue() == null) {
            return new String(name);
        }
        if (cq.getValue().getType() != null && cq.getValue().getType().isArrayType()) {
            return new String(name + "{" + cq.getValue().toString() + "}");
        }
        return new String(name + "(" + cq.getValue().toString() + ")");
    }

    public String cimDateTime(CIMDateTime cdt) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss.SSS000");
        Calendar cal = cdt.getCalendar();
        if (cal == null) {
            return NULL;
        }
        TimeZone tz = cal.getTimeZone();
        if (cdt.isInterval()) {
            return formatter.format(cal.getTime()) + ":000";
        }
        int offset = cal.get(15) + cal.get(16);
        double minutes = (double)offset * 0.001 / 60.0;
        return formatter.format(cal.getTime()) + (int)minutes;
    }

    public String cimDataType(CIMDataType cdt) {
        switch (cdt.getType()) {
            case 0: {
                return new String(DT_UINT8);
            }
            case 1: {
                return new String(DT_SINT8);
            }
            case 2: {
                return new String(DT_UINT16);
            }
            case 3: {
                return new String(DT_SINT16);
            }
            case 4: {
                return new String(DT_UINT32);
            }
            case 5: {
                return new String(DT_SINT32);
            }
            case 6: {
                return new String(DT_UINT64);
            }
            case 7: {
                return new String(DT_SINT64);
            }
            case 10: {
                return new String(DT_REAL32);
            }
            case 11: {
                return new String(DT_REAL64);
            }
            case 8: {
                return new String(DT_STR);
            }
            case 13: {
                return new String(DT_CHAR16);
            }
            case 12: {
                return new String(DT_DATETIME);
            }
            case 9: {
                return new String(DT_BOOL);
            }
            case 14: {
                return new String("uint8[]");
            }
            case 15: {
                return new String("sint8[]");
            }
            case 16: {
                return new String("uint16[]");
            }
            case 17: {
                return new String("sint16[]");
            }
            case 18: {
                return new String("uint32[]");
            }
            case 19: {
                return new String("sint32[]");
            }
            case 20: {
                return new String("uint64[]");
            }
            case 21: {
                return new String("sint64[]");
            }
            case 24: {
                return new String("real32[]");
            }
            case 25: {
                return new String("real64[]");
            }
            case 22: {
                return new String("string[]");
            }
            case 27: {
                return new String("char16[]");
            }
            case 26: {
                return new String("datetime[]");
            }
            case 23: {
                return new String("boolean[]");
            }
            case 30: {
                return new String(NULL);
            }
            case 28: {
                return new String(cdt.getRefClassName() + " REF");
            }
        }
        return "";
    }

    public String cimFlavor(CIMFlavor cf) {
        switch (cf.getFlavor()) {
            case 0: {
                return ENABLEOVERRIDE;
            }
            case 1: {
                return DISABLEOVERRIDE;
            }
            case 2: {
                return RESTRICTED;
            }
            case 3: {
                return TOSUBCLASS;
            }
            case 4: {
                return TRANSLATABLE;
            }
        }
        return "UNKNOWN";
    }

    public String cimInstance(CIMInstance ci) {
        this.cimclass = false;
        String tmp = new String("instance of " + ci.getClassName() + " " + "{" + "\n" + this.vectorToMOFString(ci.getProperties()) + "\n" + "};");
        this.cimclass = true;
        return tmp;
    }

    public String cimMethod(CIMMethod cp) {
        return new String("    " + cp.getType() + " " + cp.getName() + "(" + this.vectorToMOFString(cp.getParameters(), "", false, true, false) + ");");
    }

    public String cimParameter(CIMParameter cp) {
        return new String(cp.getQualifiers() + " " + cp.getType() + " " + cp.getName());
    }

    public String cimProperty(CIMProperty cp) {
        if (this.cimclass) {
            return new String(this.vectorToMOFString(cp.getQualifiers(), "    ", true, true, true) + "    " + cp.getType() + " " + cp.getName() + ";" + "\n");
        }
        return new String("    " + cp.getName() + " = " + cp.getValue() + ";");
    }

    public String cimScope(CIMScope cs) {
        switch (cs.getScope()) {
            case 0: {
                return SCHEMA;
            }
            case 1: {
                return CLASS;
            }
            case 2: {
                return ASSOCIATION;
            }
            case 3: {
                return INDICATION;
            }
            case 4: {
                return PROPERTY;
            }
            case 5: {
                return REFERENCE;
            }
            case 6: {
                return METHOD;
            }
            case 7: {
                return PARAMETER;
            }
            case 8: {
                return ANY;
            }
        }
        return "UNKNOWN";
    }
}

