/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.admin;

import com.sun.web.console.admin.WebAdminException;
import com.sun.web.console.admin.WebAdminUtil;
import com.sun.web.console.config.ConsoleConfigLog;
import com.sun.web.console.config.ConsoleConfigRegnot;
import com.sun.web.util.WebUtilLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class WebAdminAddRemove {
    private static final String SERVICE_HEADER = "Console shared services properties";
    private static final String FS = File.separator;
    private Properties env = null;
    private WebUtilLogger logger = null;
    private String regpath = null;
    private String svcpath = null;
    private String bkppath = null;
    private String tmppath = null;
    private ConsoleConfigRegnot ccrn = null;
    private WebAdminUtil util = null;

    public WebAdminAddRemove(Properties properties, WebAdminUtil webAdminUtil) throws WebAdminException {
        this.env = properties;
        this.util = webAdminUtil;
        String string = this.env.getProperty("console_conf") + FS + this.env.getProperty("console_instance");
        this.regpath = string + FS + "prereg";
        this.svcpath = string + FS + "service.properties";
        this.bkppath = string + FS + "backup.properties";
        this.tmppath = string + FS + "temp.properties";
        this.ccrn = new ConsoleConfigRegnot(this.regpath);
    }

    public void addJar(String string, String string2, String string3) throws WebAdminException {
        boolean bl = false;
        Properties properties = this.createNewProperties("jar", string, string2);
        try {
            File file = new File(string3);
            if (!file.isAbsolute()) {
                throw new Exception("(not absolute path)");
            }
            if (string3.endsWith(".jar")) {
                if (string3.endsWith("*.jar")) {
                    String string4 = string3.substring(0, string3.length() - 5);
                    file = new File(string4);
                    string3 = file.getCanonicalPath();
                    string4 = string3 + File.separator + "*.jar";
                    properties.setProperty("location", string4);
                } else {
                    string3 = file.getCanonicalPath();
                    properties.setProperty("location", string3);
                }
            }
            if (string3.endsWith(".jar")) {
                file = new File(string3);
                bl = file.exists() && file.isFile();
            } else {
                if (string3.endsWith(FS) && string3.length() > 1) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                bl = (file = new File(string3)).exists() && file.isDirectory();
            }
        }
        catch (Exception exception) {
            bl = false;
            string3 = exception.getMessage();
        }
        if (!bl) {
            throw new WebAdminException("add_err_24", string2, string, string3);
        }
        try {
            this.ccrn.validate(properties);
            this.ccrn.write(properties);
        }
        catch (Exception exception) {
            throw new WebAdminException("comm_err_08", exception.getLocalizedMessage());
        }
        this.logInfo("log_adm_08", string2, string, string3);
        this.printAdminMessage("add_err_20", string2, string, null);
    }

    public void removeJar(String string, String string2) throws WebAdminException {
        try {
            if (this.ccrn.exists(string, string2)) {
                Properties properties = this.ccrn.read(string, string2);
                String string3 = properties.getProperty("system");
                if (string3 != null && string3.equalsIgnoreCase("true")) {
                    throw new WebAdminException("rem_err_03", string2);
                }
                this.ccrn.remove(string, string2);
            }
        }
        catch (Exception exception) {
            throw new WebAdminException("comm_err_09", exception.getLocalizedMessage());
        }
        this.logInfo("log_adm_11", string2, string, null);
        this.printAdminMessage("add_err_21", string2, string, null);
    }

    public void addLoginModule(String string, String string2, String string3, String string4, String string5, Map map) throws WebAdminException {
        Properties properties = this.createNewProperties("loginmodule", string, string2);
        properties.setProperty("class", string3);
        properties.setProperty("service", string4);
        properties.setProperty("behavior", string5);
        properties.setProperty("order", "0");
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string6 = (String)iterator.next();
            String string7 = (String)map.get(string6);
            string6 = "option_" + string6;
            properties.setProperty(string6, string7);
        }
        try {
            this.ccrn.validate(properties);
            this.ccrn.write(properties);
        }
        catch (Exception exception) {
            throw new WebAdminException("comm_err_08", exception.getLocalizedMessage());
        }
        this.logInfo("log_adm_09", string2, string, string4);
        this.printAdminMessage("add_err_20", string2, string, null);
    }

    public void removeLoginModule(String string, String string2) throws WebAdminException {
        try {
            if (this.ccrn.exists(string, string2)) {
                this.ccrn.remove(string, string2);
            }
        }
        catch (Exception exception) {
            throw new WebAdminException("comm_err_09", exception.getLocalizedMessage());
        }
        this.logInfo("log_admin_12", string2, string, null);
        this.printAdminMessage("add_err_21", string2, string, null);
    }

    public void addProperties(String string, Map map) throws WebAdminException {
        String string2;
        Properties properties = this.loadServiceProperties();
        String string3 = "";
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            String string4 = (String)map.get(string2);
            properties.setProperty(string2, string4);
            string3 = string3 + " " + string2;
        }
        this.saveServiceProperties(properties);
        string2 = Integer.toString(map.size());
        this.logInfo("log_adm_10", string2, string, string3);
        this.printAdminMessage("add_err_22", string2, string, null);
    }

    public void removeProperties(String string, ArrayList arrayList) throws WebAdminException {
        String string2;
        Properties properties = this.loadServiceProperties();
        String string3 = "";
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            properties.remove(string2);
            string3 = string3 + " " + string2;
        }
        this.saveServiceProperties(properties);
        string2 = Integer.toString(arrayList.size());
        this.logInfo("log_adm_13", string2, string, string3);
        this.printAdminMessage("add_err_23", string2, string, null);
    }

    private Properties createNewProperties(String string, String string2, String string3) throws WebAdminException {
        Properties properties = new Properties();
        properties.setProperty("type", string);
        properties.setProperty("appname", string2);
        properties.setProperty("id", string3);
        properties.setProperty("timestamp", Long.toString(System.currentTimeMillis()));
        properties.setProperty("notification", this.regpath + FS + string2 + FS + string3 + ".reg");
        return properties;
    }

    private Properties loadServiceProperties() throws WebAdminException {
        File file = new File(this.svcpath);
        FileInputStream fileInputStream = null;
        WebAdminException webAdminException = null;
        Properties properties = new Properties();
        try {
            if (file.exists()) {
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
            }
        }
        catch (Exception exception) {
            webAdminException = new WebAdminException("add_err_13", exception.getLocalizedMessage());
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (webAdminException != null) {
            throw webAdminException;
        }
        return properties;
    }

    private void saveServiceProperties(Properties properties) throws WebAdminException {
        File file = new File(this.svcpath);
        File file2 = new File(this.tmppath);
        File file3 = new File(this.bkppath);
        FileOutputStream fileOutputStream = null;
        WebAdminException webAdminException = null;
        try {
            if (file2.exists()) {
                file2.delete();
            }
            fileOutputStream = new FileOutputStream(file2);
            properties.store(fileOutputStream, SERVICE_HEADER);
            fileOutputStream.close();
            fileOutputStream = null;
            if (file.exists()) {
                file3.delete();
                file.renameTo(file3);
            }
            file2.renameTo(file);
        }
        catch (Exception exception) {
            webAdminException = new WebAdminException("add_err_14", exception.getLocalizedMessage());
        }
        if (file3.exists()) {
            try {
                file3.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (fileOutputStream != null) {
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (webAdminException != null) {
            throw webAdminException;
        }
    }

    private void logInfo(String string, String string2, String string3, String string4) {
        ConsoleConfigLog.log((int)3, (String)string, (String)string2, (String)string3, (String)string4);
    }

    private void printAdminMessage(String string, String string2, String string3, String string4) {
        this.util.printMessage(2, string, string2, string3, string4);
    }
}

