/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom.adapters.provider.jni;

import com.sun.wbem.cimom.ServiceRegistry;
import com.sun.wbem.cimom.audit.WbemAuditService;
import com.sun.wbem.cimom.audit.WbemAuditSession;
import com.sun.wbem.utility.log.LogUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.Debug;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.CIMAssociatorProvider;
import javax.wbem.provider.CIMInstanceProvider;
import javax.wbem.provider.CIMMethodProvider;
import javax.wbem.provider.EventProvider;
import javax.wbem.provider.PropertyProvider;
import javax.wbem.query.NonJoinExp;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectExp;
import javax.wbem.query.SelectList;

public class SolarisNative
implements CIMInstanceProvider,
PropertyProvider,
CIMMethodProvider,
EventProvider,
Authorizable,
CIMAssociatorProvider {
    private ProviderCIMOMHandle cimomhandle = null;
    private String mCimClassName = null;
    private String mLibName = null;
    private int mProviderFlags = 0;
    public static final long TIMEOUT = 60000L;
    private static int mRequestID = 0;
    private static Map queuedResults = Collections.synchronizedMap(new HashMap());
    private static final String nativelib = "SolarisNative";
    private static Exception loadLibraryError = null;

    private String getLibName() {
        return this.mLibName;
    }

    private String getCimClassName() {
        return this.mCimClassName;
    }

    private void writeLogMessage(String pSumMsg, String pMsg) {
        Debug.trace1((String)("" + pMsg));
        try {
            LogUtil log = LogUtil.getInstance((CIMOMHandle)this.cimomhandle);
            log.writeLog("JNIAdapter:SolarisNative", pSumMsg, pMsg, null, this.getCimClassName(), true, 2, 2, null);
        }
        catch (CIMException ce) {
            Debug.trace1((String)"Unable to log msg", (Throwable)ce);
        }
    }

    private synchronized int getRequestID() {
        if (mRequestID < 0) {
            mRequestID = 0;
        }
        return mRequestID++;
    }

    private static final String[] getPropertyNames(Vector pProps) {
        int count = 0;
        String[] propList = new String[pProps.size()];
        Iterator iP = pProps.iterator();
        Debug.trace3((String)"Determining the names of the properties returned");
        while (iP.hasNext()) {
            CIMProperty prop = (CIMProperty)iP.next();
            if (prop != null) {
                propList[count] = prop.getName();
            }
            ++count;
        }
        return propList;
    }

    private final CIMInstance filterInstance(CIMInstance pInst, boolean pLocalOnly, boolean pIncludeQualifiers, boolean pIncludeClassOrigin, boolean pDetermineList, String[] pPropList, CIMClass pClz) throws CIMException {
        CIMInstance inst = null;
        if (pInst == null) {
            return null;
        }
        Vector properties = pInst.getProperties();
        if (pClz == null) {
            inst = pInst;
        } else {
            inst = pClz.newInstance();
            inst.updatePropertyValues(properties);
        }
        if (pLocalOnly) {
            inst = inst.localElements();
        }
        String[] propList = null;
        propList = pPropList == null && pDetermineList ? SolarisNative.getPropertyNames(properties) : pPropList;
        return inst.filterProperties(propList, pIncludeQualifiers, pIncludeClassOrigin);
    }

    private final CIMInstance[] convertList2Instance(List pList, boolean pLocalOnly, boolean pIncludeQualifiers, boolean pIncludeClassOrigin, boolean pDetermineList, String[] pPropList, CIMClass pClz) throws CIMException {
        int arraySize = pList.size();
        CIMInstance[] instArray = pList.toArray(new CIMInstance[arraySize]);
        CIMInstance[] retArray = new CIMInstance[arraySize];
        String[] propList = pPropList;
        boolean detList = pDetermineList;
        for (int x = 0; x < arraySize; ++x) {
            retArray[x] = this.filterInstance(instArray[x], pLocalOnly, pIncludeQualifiers, pIncludeClassOrigin, detList, propList, pClz);
            if (propList != null || !detList || retArray[x] == null) continue;
            propList = SolarisNative.getPropertyNames(retArray[x].getProperties());
            detList = false;
        }
        return retArray;
    }

    public SolarisNative(String pLibName, String pCimClassName) {
        this.mCimClassName = pCimClassName.toLowerCase();
        this.mLibName = pLibName;
    }

    public static void setQueuedResultClass(int key, Object result) {
        ResultClass retClz = (ResultClass)queuedResults.get(new Integer(key));
        if (retClz != null) {
            retClz.setResult(result);
        }
    }

    int getProviderFlags() {
        return this.mProviderFlags;
    }

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        if (loadLibraryError != null) {
            throw new CIMException("CIM_ERR_FAILED", (Object)loadLibraryError);
        }
        this.cimomhandle = (ProviderCIMOMHandle)cimomhandle;
        this.initNative(this.cimomhandle);
        this.mProviderFlags = this.getProviderFlags(this.getCimClassName(), this.getLibName());
    }

    public void cleanup() throws CIMException {
        String className = this.getCimClassName();
        if (className == null) {
            throw new CIMException("CIM_ERR_FAILED", (Object)new NullPointerException("No CIM Class available"));
        }
        this.shutdownProvider(className);
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        ContextHelper h = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + h.getKey()));
        this.createInstance(h.getProviderContext(), this.getLibName(), op, ci);
        Debug.trace2((String)"Native method returned");
        h.waitForRemoteProvider(60000L);
        Object ret = h.getResult();
        if (ret == null) {
            return null;
        }
        if (ret instanceof CIMObjectPath) {
            return (CIMObjectPath)ret;
        }
        if (ret instanceof CIMException) {
            Debug.trace2((String)"Remote provider threw a CIMException", (Throwable)((CIMException)((Object)ret)));
            throw (CIMException)((Object)ret);
        }
        Debug.trace1((String)("Invalid type returned from provider: " + ret.getClass().getName()));
        throw new CIMProviderException("CIM_ERR_FAILED");
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        ContextHelper h = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + h.getKey()));
        this.deleteInstance(h.getProviderContext(), this.getLibName(), op);
        Debug.trace2((String)"Native method returned");
        h.waitForRemoteProvider(60000L);
        Object ret = h.getResult();
        if (ret != null) {
            if (ret instanceof CIMException) {
                Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((Exception)ret));
                throw (CIMException)((Object)ret);
            }
            Debug.trace1((String)("Invalid type returned from provider: " + ret.getClass().getName()));
            throw new CIMProviderException("CIM_ERR_FAILED");
        }
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci, boolean includeQualifiers, String[] propertyList) throws CIMException {
        ContextHelper h = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + h.getKey()));
        this.setInstance(h.getProviderContext(), this.getLibName(), op, ci, propertyList);
        Debug.trace2((String)"Native method returned");
        h.waitForRemoteProvider(60000L);
        Object ret = h.getResult();
        if (ret != null) {
            if (ret instanceof CIMException) {
                Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((Exception)ret));
                throw (CIMException)((Object)ret);
            }
            Debug.trace1((String)("Invalid type returned from provider: " + ret.getClass().getName()));
            throw new CIMProviderException("CIM_ERR_FAILED");
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        ContextHelper h = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + h.getKey()));
        this.enumInstanceNames(h.getProviderContext(), this.getLibName(), op);
        Debug.trace2((String)"Native method returned");
        h.waitForRemoteProvider(60000L);
        Object ret = h.getResult();
        if (ret == null) {
            return null;
        }
        if (ret instanceof CIMException) {
            Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((CIMException)((Object)ret)));
            throw (CIMException)((Object)ret);
        }
        if (ret instanceof List) {
            List retList = (List)ret;
            CIMObjectPath[] copArray = new CIMObjectPath[retList.size()];
            copArray = retList.toArray(copArray);
            return copArray;
        }
        Debug.trace1((String)("Invalid type returned from provider: " + ret.getClass().getName()));
        throw new CIMProviderException("CIM_ERR_FAILED");
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        ContextHelper h = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + h.getKey()));
        this.enumInstances(h.getProviderContext(), this.getLibName(), op);
        Debug.trace2((String)"Native method returned");
        h.waitForRemoteProvider(60000L);
        Object ret = h.getResult();
        if (ret == null) {
            Debug.trace3((String)"result is null!");
            return null;
        }
        if (ret instanceof CIMException) {
            Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((CIMException)((Object)ret)));
            throw (CIMException)((Object)ret);
        }
        if (ret instanceof List) {
            return this.convertList2Instance((List)ret, localOnly, includeQualifiers, includeClassOrigin, false, propertyList, cc);
        }
        Debug.trace1((String)("Invalid type returned from provider: " + ret.getClass().getName()));
        throw new CIMProviderException("CIM_ERR_FAILED");
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        ContextHelper h = new ContextHelper();
        SelectList attrs = null;
        NonJoinExp from = null;
        QueryExp where = null;
        try {
            SelectExp q = new SelectExp(query);
            attrs = q.getSelectList();
            if (attrs == null) {
                Debug.trace3((String)"SelectList is null, aborting...");
                throw new NullPointerException("SelectList is null");
            }
            from = (NonJoinExp)q.getFromClause();
            if (from == null) {
                Debug.trace3((String)"from clause is null, aborting...");
                throw new NullPointerException("from clause is null");
            }
            where = q.getWhereClause();
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", (Object)e.toString());
        }
        Debug.trace2((String)("Calling Native method, request ID: " + h.getKey()));
        this.execQuery(h.getProviderContext(), this.getLibName(), op, attrs.toString(), from.toString(), where == null ? null : where.toString(), ql);
        Debug.trace2((String)"Native method returned");
        h.waitForRemoteProvider(60000L);
        Object ret = h.getResult();
        if (ret == null) {
            return null;
        }
        if (ret instanceof CIMException) {
            Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((CIMException)((Object)ret)));
            throw (CIMException)((Object)ret);
        }
        if (ret instanceof List) {
            return this.convertList2Instance((List)ret, false, true, true, true, null, cc);
        }
        Debug.trace1((String)("Invalid type returned from provider: " + ret.getClass().getName()));
        throw new CIMProviderException("CIM_ERR_FAILED");
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        ContextHelper h = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + h.getKey()));
        this.getInstance(h.getProviderContext(), this.getLibName(), op);
        Debug.trace2((String)"Native method returned");
        h.waitForRemoteProvider(60000L);
        Object ret = h.getResult();
        if (ret == null) {
            return null;
        }
        if (ret instanceof CIMException) {
            Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((CIMException)((Object)ret)));
            throw (CIMException)((Object)ret);
        }
        if (ret instanceof CIMInstance) {
            return this.filterInstance((CIMInstance)ret, localOnly, includeQualifiers, includeClassOrigin, false, propertyList, cc);
        }
        Debug.trace1((String)("Invalid type returned from provider: " + ret.getClass().getName()));
        throw new CIMProviderException("CIM_ERR_FAILED");
    }

    public CIMValue getPropertyValue(CIMObjectPath op, String className, String propName) throws CIMException {
        ContextHelper h = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + h.getKey()));
        this.getProperty(h.getProviderContext(), this.getLibName(), op, propName);
        Debug.trace2((String)"Native method returned");
        h.waitForRemoteProvider(60000L);
        Object ret = h.getResult();
        if (ret == null) {
            return null;
        }
        if (ret instanceof CIMException) {
            Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((CIMException)((Object)ret)));
            throw (CIMException)((Object)ret);
        }
        if (ret instanceof CIMProperty) {
            CIMProperty prop = (CIMProperty)ret;
            return prop.getValue();
        }
        Debug.trace1((String)("Invalid type returned from provider: " + ret.getClass().getName()));
        throw new CIMProviderException("CIM_ERR_FAILED");
    }

    public void setPropertyValue(CIMObjectPath op, String className, String propName, CIMValue cv) throws CIMException {
        if (propName == null) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        ContextHelper h = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + h.getKey()));
        this.setProperty(h.getProviderContext(), this.getLibName(), op, propName, cv);
        Debug.trace2((String)"Native method returned");
        h.waitForRemoteProvider(60000L);
        Object ret = h.getResult();
        if (ret == null) {
            return;
        }
        if (ret instanceof CIMException) {
            Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((CIMException)((Object)ret)));
            throw (CIMException)((Object)ret);
        }
        Debug.trace1((String)("Invalid type returned from provider: " + ret.getClass().getName()));
        throw new CIMProviderException("CIM_ERR_FAILED");
    }

    public CIMValue invokeMethod(CIMObjectPath op, String methodName, CIMArgument[] inParams, CIMArgument[] outParams) throws CIMException {
        if (methodName == null) {
            Debug.trace2((String)"method name is null");
            return null;
        }
        ContextHelper h = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + h.getKey()));
        this.invokeMethod(h.getProviderContext(), this.getLibName(), op, methodName, inParams);
        Debug.trace2((String)"Native method returned");
        h.waitForRemoteProvider(60000L);
        Object ret = h.getResult();
        if (ret == null) {
            Debug.trace3((String)"Provider returned null");
            return null;
        }
        if (ret instanceof CIMException) {
            Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((CIMException)((Object)ret)));
            throw (CIMException)((Object)ret);
        }
        if (ret instanceof CIMValue) {
            CIMValue cv = (CIMValue)ret;
            return cv;
        }
        if (ret instanceof List) {
            List retList = (List)ret;
            CIMArgument ca = (CIMArgument)retList.remove(0);
            CIMValue cv = ca.getValue();
            if (outParams != null) {
                CIMArgument[] args = retList.toArray(new CIMArgument[retList.size()]);
                try {
                    System.arraycopy(args, 0, outParams, 0, outParams.length);
                }
                catch (Exception e) {
                    Debug.trace1((String)"Exception occurred while copying array", (Throwable)e);
                    throw new CIMException("CIM_ERR_FAILED", (Object)e);
                }
            }
            return cv;
        }
        Debug.trace1((String)("Invalid type returned from provider: " + ret.getClass().getName()));
        throw new CIMProviderException("CIM_ERR_FAILED");
    }

    public void activateFilter(SelectExp filter, String eventType, CIMObjectPath classPath, boolean firstActivation) throws CIMException {
        ContextHelper h = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + h.getKey()));
        this.activateFilter(h.getProviderContext(), this.getLibName(), filter.toString(), eventType, classPath, firstActivation);
        Debug.trace2((String)"Native method returned");
        h.waitForRemoteProvider(60000L);
        Object ret = h.getResult();
        if (ret != null) {
            if (ret instanceof CIMException) {
                Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((Exception)ret));
                throw (CIMException)((Object)ret);
            }
            Debug.trace1((String)("Invalid type returned from provider: " + ret.getClass().getName()));
            throw new CIMProviderException("CIM_ERR_FAILED");
        }
    }

    public void authorizeFilter(SelectExp filter, String eventType, CIMObjectPath classPath, String owner) throws CIMException {
        ContextHelper h = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + h.getKey()));
        this.authorizeFilter(h.getProviderContext(), this.getLibName(), filter.toString(), eventType, classPath, owner);
        Debug.trace2((String)"Native method returned");
        h.waitForRemoteProvider(60000L);
        Object ret = h.getResult();
        if (ret != null) {
            if (ret instanceof CIMException) {
                Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((Exception)ret));
                throw (CIMException)((Object)ret);
            }
            Debug.trace1((String)("Invalid type returned from provider: " + ret.getClass().getName()));
            throw new CIMProviderException("CIM_ERR_FAILED");
        }
    }

    public void deActivateFilter(SelectExp filter, String eventType, CIMObjectPath classPath, boolean lastActivation) throws CIMException {
        ContextHelper h = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + h.getKey()));
        this.deActivateFilter(h.getProviderContext(), this.getLibName(), filter.toString(), eventType, classPath, lastActivation);
        Debug.trace2((String)"Native method returned");
        h.waitForRemoteProvider(60000L);
        Object ret = h.getResult();
        if (ret != null) {
            if (ret instanceof CIMException) {
                Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((Exception)ret));
                throw (CIMException)((Object)ret);
            }
            Debug.trace1((String)("Invalid type returned from provider: " + ret.getClass().getName()));
            throw new CIMProviderException("CIM_ERR_FAILED");
        }
    }

    public boolean mustPoll(SelectExp filter, String eventType, CIMObjectPath classPath) throws CIMException {
        ContextHelper h = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + h.getKey()));
        this.mustPoll(h.getProviderContext(), this.getLibName(), filter.toString(), eventType, classPath);
        Debug.trace2((String)"Native method returned");
        h.waitForRemoteProvider(60000L);
        Object ret = h.getResult();
        if (ret == null) {
            return false;
        }
        if (ret instanceof Boolean) {
            return (Boolean)ret;
        }
        if (ret instanceof CIMException) {
            Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((Exception)ret));
            throw (CIMException)((Object)ret);
        }
        Debug.trace1((String)("Invalid type returned from provider: " + ret.getClass().getName()));
        throw new CIMProviderException("CIM_ERR_FAILED");
    }

    public CIMObjectPath[] associatorNames(CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole) throws CIMException {
        ContextHelper h = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + h.getKey()));
        this.associatorNames(h.getProviderContext(), this.getLibName(), assocName, objectName, resultClass, role, resultRole);
        Debug.trace2((String)"Native method returned");
        h.waitForRemoteProvider(60000L);
        Object ret = h.getResult();
        if (ret == null) {
            return null;
        }
        if (ret instanceof CIMException) {
            Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((CIMException)((Object)ret)));
            throw (CIMException)((Object)ret);
        }
        if (ret instanceof List) {
            List retList = (List)ret;
            CIMObjectPath[] copArray = new CIMObjectPath[retList.size()];
            copArray = retList.toArray(copArray);
            return copArray;
        }
        Debug.trace1((String)("Invalid type returned from provider: " + ret.getClass().getName()));
        throw new CIMProviderException("CIM_ERR_FAILED");
    }

    public CIMInstance[] associators(CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        ContextHelper h = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + h.getKey()));
        this.associators(h.getProviderContext(), this.getLibName(), assocName, objectName, resultClass, role, resultRole);
        Debug.trace2((String)"Native method returned");
        h.waitForRemoteProvider(60000L);
        Object ret = h.getResult();
        if (ret == null) {
            Debug.trace3((String)"result is null!");
            return null;
        }
        if (ret instanceof CIMException) {
            Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((CIMException)((Object)ret)));
            throw (CIMException)((Object)ret);
        }
        if (ret instanceof List) {
            return this.convertList2Instance((List)ret, false, includeQualifiers, includeClassOrigin, false, propertyList, null);
        }
        Debug.trace1((String)("Invalid type returned from provider: " + ret.getClass().getName()));
        throw new CIMProviderException("CIM_ERR_FAILED");
    }

    public CIMObjectPath[] referenceNames(CIMObjectPath assocName, CIMObjectPath objectName, String role) throws CIMException {
        ContextHelper h = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + h.getKey()));
        this.referenceNames(h.getProviderContext(), this.getLibName(), assocName, objectName, role);
        Debug.trace2((String)"Native method returned");
        h.waitForRemoteProvider(60000L);
        Object ret = h.getResult();
        if (ret == null) {
            return null;
        }
        if (ret instanceof CIMException) {
            Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((CIMException)((Object)ret)));
            throw (CIMException)((Object)ret);
        }
        if (ret instanceof List) {
            List retList = (List)ret;
            CIMObjectPath[] copArray = new CIMObjectPath[retList.size()];
            copArray = retList.toArray(copArray);
            return copArray;
        }
        Debug.trace1((String)("Invalid type returned from provider: " + ret.getClass().getName()));
        throw new CIMProviderException("CIM_ERR_FAILED");
    }

    public CIMInstance[] references(CIMObjectPath assocName, CIMObjectPath objectName, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        ContextHelper h = new ContextHelper();
        Debug.trace2((String)("Calling Native method, request ID: " + h.getKey()));
        this.references(h.getProviderContext(), this.getLibName(), assocName, objectName, role);
        Debug.trace2((String)"Native method returned");
        h.waitForRemoteProvider(60000L);
        Object ret = h.getResult();
        if (ret == null) {
            Debug.trace3((String)"result is null!");
            return null;
        }
        if (ret instanceof CIMException) {
            Debug.trace2((String)"Remote provider thru a CIMException", (Throwable)((CIMException)((Object)ret)));
            throw (CIMException)((Object)ret);
        }
        if (ret instanceof List) {
            return this.convertList2Instance((List)ret, false, includeQualifiers, includeClassOrigin, false, propertyList, null);
        }
        Debug.trace1((String)("Invalid type returned from provider: " + ret.getClass().getName()));
        throw new CIMProviderException("CIM_ERR_FAILED");
    }

    public native void initNative(ProviderCIMOMHandle var1);

    public native void createInstance(ProviderContext var1, String var2, CIMObjectPath var3, CIMInstance var4);

    public native void deleteInstance(ProviderContext var1, String var2, CIMObjectPath var3);

    public native void enumInstanceNames(ProviderContext var1, String var2, CIMObjectPath var3);

    public native void enumInstances(ProviderContext var1, String var2, CIMObjectPath var3);

    public native void getInstance(ProviderContext var1, String var2, CIMObjectPath var3);

    public native void getProperty(ProviderContext var1, String var2, CIMObjectPath var3, String var4);

    private native void setInstance(ProviderContext var1, String var2, CIMObjectPath var3, CIMInstance var4, String[] var5);

    private native void setProperty(ProviderContext var1, String var2, CIMObjectPath var3, String var4, CIMValue var5);

    public native void invokeMethod(ProviderContext var1, String var2, CIMObjectPath var3, String var4, CIMArgument[] var5);

    public native void execQuery(ProviderContext var1, String var2, CIMObjectPath var3, String var4, String var5, String var6, String var7);

    public native void activateFilter(ProviderContext var1, String var2, String var3, String var4, CIMObjectPath var5, boolean var6);

    public native void deActivateFilter(ProviderContext var1, String var2, String var3, String var4, CIMObjectPath var5, boolean var6);

    public native void authorizeFilter(ProviderContext var1, String var2, String var3, String var4, CIMObjectPath var5, String var6);

    public native void mustPoll(ProviderContext var1, String var2, String var3, String var4, CIMObjectPath var5);

    public native void associatorNames(ProviderContext var1, String var2, CIMObjectPath var3, CIMObjectPath var4, String var5, String var6, String var7);

    public native void associators(ProviderContext var1, String var2, CIMObjectPath var3, CIMObjectPath var4, String var5, String var6, String var7);

    public native void referenceNames(ProviderContext var1, String var2, CIMObjectPath var3, CIMObjectPath var4, String var5);

    public native void references(ProviderContext var1, String var2, CIMObjectPath var3, CIMObjectPath var4, String var5);

    public native void shutdownProvider(String var1);

    private native boolean isDoorRunning(String var1);

    private native int getProviderFlags(String var1, String var2);

    static {
        try {
            System.loadLibrary(nativelib);
        }
        catch (Exception e) {
            Debug.trace1((String)"Unable to load SolarisNative", (Throwable)e);
            loadLibraryError = e;
        }
    }

    private final class ContextHelper {
        private ProviderContext ctx = this.createProviderContext();
        private Integer key = new Integer(this.ctx.getRequestId());
        private ResultClass result = new ResultClass();

        public ContextHelper() {
            queuedResults.put(this.key, this.result);
        }

        private ProviderContext createProviderContext() {
            ProviderContext pc = new ProviderContext();
            pc.setUserName(SolarisNative.this.cimomhandle.getCurrentUser());
            pc.setRoleName(SolarisNative.this.cimomhandle.getCurrentRole());
            pc.setHostName(SolarisNative.this.cimomhandle.getCurrentClientHost());
            pc.setAuditId(SolarisNative.this.cimomhandle.getCurrentAuditId());
            pc.setRequestId(SolarisNative.this.getRequestID());
            return pc;
        }

        public ProviderContext getProviderContext() {
            return this.ctx;
        }

        public Integer getKey() {
            return this.key;
        }

        public ResultClass getResultClass() {
            return this.result;
        }

        public Object getResult() {
            if (this.result != null) {
                return this.result.getResult();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void waitForRemoteProvider(long timeOut) throws CIMException {
            try {
                try {
                    ResultClass resultClass = this.result;
                    synchronized (resultClass) {
                        Debug.trace2((String)"Waiting for remote provider to process request");
                        if (this.result.getTimedOut()) {
                            this.result.wait(timeOut);
                        }
                        Debug.trace2((String)"Remote process has completed, or timed out");
                    }
                }
                catch (InterruptedException ie) {
                    Debug.trace2((String)"Wait was interrupted", (Throwable)ie);
                    throw new CIMProviderException("CIM_ERR_FAILED", (Object)ie);
                }
                Object var6_4 = null;
                queuedResults.remove(this.key);
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                queuedResults.remove(this.key);
                if (!this.result.getTimedOut()) {
                    throw throwable;
                }
                Debug.trace2((String)("Remote process timed out for request " + this.getKey()));
                if (SolarisNative.this.isDoorRunning(SolarisNative.this.getCimClassName())) {
                    throw new CIMProviderException("TIMED_OUT");
                }
                SolarisNative.this.writeLogMessage("Remote provider abnormally terminated", "The provider for the CIM Class: " + SolarisNative.this.getCimClassName() + " has terminated!");
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)"Provider is no longer available!");
            }
            if (!this.result.getTimedOut()) {
                return;
            }
            Debug.trace2((String)("Remote process timed out for request " + this.getKey()));
            if (SolarisNative.this.isDoorRunning(SolarisNative.this.getCimClassName())) {
                throw new CIMProviderException("TIMED_OUT");
            }
            SolarisNative.this.writeLogMessage("Remote provider abnormally terminated", "The provider for the CIM Class: " + SolarisNative.this.getCimClassName() + " has terminated!");
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)"Provider is no longer available!");
        }

        private byte[] getPlatformAuditSession() {
            try {
                WbemAuditSession auditSession = null;
                WbemAuditService auditService = (WbemAuditService)ServiceRegistry.getService((String)"auditservice");
                if (auditService != null) {
                    auditSession = auditService.getAuditSession();
                } else {
                    Debug.trace3((String)"ServiceRegistry returned null auditService");
                }
                if (auditSession != null) {
                    try {
                        byte[] as = auditSession.exportSession();
                        if (as == null) {
                            Debug.trace3((String)"auditSession.exportSession() returned null");
                        }
                        return as;
                    }
                    catch (CIMException cex) {
                        return null;
                    }
                }
                Debug.trace3((String)"auditService.getAuditSession() returned null");
                return null;
            }
            catch (Exception e) {
                Debug.trace3((String)"Unexpected exception in ContextHelper.getPlatformAuditSession()");
                return null;
            }
        }
    }

    private static class ResultClass {
        boolean mTimedOut = true;
        Object mOp = null;

        public synchronized Object getResult() {
            Debug.trace3((String)("Returning result: " + this.mOp));
            return this.mOp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setResult(Object pResult) {
            Debug.trace3((String)("Setting result to: " + pResult));
            ResultClass resultClass = this;
            synchronized (resultClass) {
                this.mOp = pResult;
                this.mTimedOut = false;
                this.notifyAll();
            }
        }

        public synchronized boolean getTimedOut() {
            Debug.trace3((String)("returning timedout: " + this.mTimedOut));
            return this.mTimedOut;
        }
    }

    private static class ProviderContext {
        private String user = null;
        private String role = null;
        private String host = null;
        private int request_id = 0;
        private int audit_id = 0;
        private byte[] audit_session = null;

        public String getUserName() {
            return this.user;
        }

        public String getRoleName() {
            return this.role;
        }

        public String getHostName() {
            return this.host;
        }

        public byte[] getAuditSession() {
            return this.audit_session;
        }

        public int getAuditId() {
            return this.audit_id;
        }

        public int getRequestId() {
            return this.request_id;
        }

        public void setUserName(String username) {
            this.user = username;
        }

        public void setRoleName(String rolename) {
            this.role = rolename;
        }

        public void setHostName(String hostname) {
            this.host = hostname;
        }

        public void setAuditSession(byte[] audit_session) {
            this.audit_session = audit_session;
        }

        public void setAuditId(int aud_id) {
            this.audit_id = aud_id;
        }

        public void setRequestId(int req_id) {
            this.request_id = req_id;
        }
    }
}

