/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom.adapters.client.snmp;

import com.sun.wbem.cimom.adapters.client.snmp.SnmpImpl;
import com.sun.wbem.cimom.adapters.client.snmp.SnmpMapEntry;
import com.sun.wbem.cimom.adapters.client.snmp.SnmpReaderWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import javax.wbem.cim.CIMException;
import javax.wbem.client.Debug;

public class SnmpCache
extends SnmpReaderWriter {
    private static final String MAP_DIRECTORY = "/var/sadm/wbem/snmp/map/";
    private static final String MAP_TABLE_SUFFIX = ".map";
    private static final String SNMP_MAP_TABLE_VERSION = "1.0";
    private static final String MAP_TABLE_VERSION_LABEL = "Version";
    private static final String MAP_TABLE_COMMENT = "#";
    private static final int DEFAULT_CACHE_SIZE = 101;
    private SnmpImpl impl = null;
    private Hashtable hashCache = null;
    private boolean debugOn = false;
    private static Random rn = null;

    public SnmpCache(SnmpImpl impl, boolean debugOn) {
        this.impl = impl;
        this.debugOn = debugOn;
        this.write_();
    }

    protected Object read_(String s) {
        return this.cacheLookup(s);
    }

    protected void write_() {
        this.refreshCache();
    }

    private List getMapTableFiles() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            File f = new File(MAP_DIRECTORY);
            if (!f.isDirectory()) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            File[] fileList = f.listFiles();
            SnmpCache.sort(fileList);
            if (fileList != null) {
                for (int i = 0; i < fileList.length; ++i) {
                    String s;
                    f = fileList[i];
                    if (!f.isFile() || !(s = f.getName()).endsWith(MAP_TABLE_SUFFIX)) continue;
                    list.add(s);
                }
            }
        }
        catch (CIMException e) {
            String[] subArgs = new String[]{};
            String logMsg = this.impl.logError("SNMPA_100", "SNMPA_200", subArgs);
        }
        catch (Exception e) {
            String[] subArgs = new String[]{"getMapTableFiles"};
            String logMsg = this.impl.logException("SNMPA_100", "SNMPA_200", subArgs, e);
        }
        return list;
    }

    private void checkMapTableVersion(BufferedReader reader) throws CIMException, Exception {
        try {
            String entry;
            while ((entry = reader.readLine()) != null) {
                String s;
                StringTokenizer str = new StringTokenizer(entry);
                int tokenCount = str.countTokens();
                if (tokenCount == 0 || (s = str.nextToken()).startsWith(MAP_TABLE_COMMENT)) continue;
                if (tokenCount != 2) {
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                }
                if (!s.equals(MAP_TABLE_VERSION_LABEL)) {
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                }
                s = str.nextToken();
                if (s.equals(SNMP_MAP_TABLE_VERSION)) break;
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
        }
        catch (CIMException e) {
            String[] subArgs = new String[]{};
            String logMsg = this.impl.logError("SNMPA_100", "SNMPA_204", subArgs);
        }
        catch (Exception e) {
            String[] subArgs = new String[]{"checkMapTableVersion"};
            String logMsg = this.impl.logException("SNMPA_100", "SNMPA_200", subArgs, e);
        }
    }

    private void refreshCache() {
        Debug.trace3((String)"Refreshing SNMP Adapter cache");
        Hashtable oldCache = this.hashCache;
        this.hashCache = new Hashtable(101);
        ArrayList list = (ArrayList)this.getMapTableFiles();
        for (int i = 0; i < list.size(); ++i) {
            try {
                String fileInputName = (String)list.get(i);
                this.cacheExternalMap(MAP_DIRECTORY + fileInputName);
                continue;
            }
            catch (CIMException e) {
                continue;
            }
            catch (IOException e) {
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.hashCache.isEmpty()) {
            Debug.trace3((String)"New cache is empty");
            if (oldCache != null && !oldCache.isEmpty()) {
                Debug.trace3((String)"Reverting to old cache");
                String[] subArgs = new String[]{};
                String logMsg = this.impl.logError("SNMPA_100", "SNMPA_211", subArgs);
                this.hashCache = oldCache;
            }
        }
        this.traceCache(this.hashCache);
    }

    private void cacheExternalMap(String fileInputName) throws IOException, CIMException, Exception {
        String entry;
        FileInputStream in = new FileInputStream(fileInputName);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        this.checkMapTableVersion(reader);
        while ((entry = reader.readLine()) != null) {
            String s;
            StringTokenizer str = new StringTokenizer(entry);
            if (str.countTokens() < 4 || (s = str.nextToken()).startsWith(MAP_TABLE_COMMENT)) continue;
            SnmpMapEntry mappedEntry = new SnmpMapEntry();
            mappedEntry.oid = s;
            mappedEntry.className = str.nextToken();
            mappedEntry.propertyName = str.nextToken();
            mappedEntry.asn1Type = str.nextToken();
            SnmpMapEntry oldEntry = this.hashCache.put(s, mappedEntry);
            if (oldEntry == null) continue;
            this.hashCache.put(s, oldEntry);
            Debug.trace3((String)("File " + fileInputName + " contains duplicate entry for " + s));
        }
    }

    public SnmpMapEntry cacheLookup(String oidString) {
        SnmpMapEntry mappedEntry = null;
        mappedEntry = (SnmpMapEntry)this.hashCache.get(oidString);
        this.traceLookupResult(oidString, mappedEntry);
        return mappedEntry;
    }

    private void traceCache(Hashtable hash) {
        if (!this.debugOn) {
            return;
        }
        Debug.trace3((String)"**************************");
        Debug.trace3((String)"Printing entries in cache:");
        if (hash != null) {
            Debug.trace3((String)hash.toString());
        } else {
            Debug.trace3((String)"No entries found.");
        }
        Debug.trace3((String)"**************************");
    }

    private void traceLookupResult(String s, SnmpMapEntry mapEntry) {
        if (!this.debugOn) {
            return;
        }
        Debug.trace3((String)"*********************************");
        if (mapEntry != null) {
            Debug.trace3((String)("Cache contains map entry for OID " + s + ":"));
            Debug.trace3((String)mapEntry.toString());
        } else {
            Debug.trace3((String)("Cache does not contain map entry for OID " + s));
        }
        Debug.trace3((String)"*********************************");
    }

    private static int doCompare(Object obj1, Object obj2) {
        File f1 = (File)obj1;
        File f2 = (File)obj2;
        String s1 = f1.getName();
        String s2 = f2.getName();
        return s1.compareTo(s2);
    }

    private static void swap(Object[] arr, int i, int j) {
        Object tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    private static void quicksort(Object[] arr, int left, int right) {
        if (left >= right) {
            return;
        }
        SnmpCache.swap(arr, left, left + (Math.abs(rn.nextInt()) % (right - left) + 1));
        int last = left;
        for (int i = left + 1; i <= right; ++i) {
            if (SnmpCache.doCompare(arr[i], arr[left]) >= 0) continue;
            SnmpCache.swap(arr, ++last, i);
        }
        SnmpCache.swap(arr, left, last);
        SnmpCache.quicksort(arr, left, last - 1);
        SnmpCache.quicksort(arr, last + 1, right);
    }

    public static void sort(Object[] arr) {
        if (rn == null) {
            rn = new Random();
        }
        SnmpCache.quicksort(arr, 0, arr.length - 1);
    }
}

