/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deg.sunvts.ms;

import com.sun.deg.sunvts.data.HostConfig;
import com.sun.deg.sunvts.data.LTPageData;
import com.sun.deg.sunvts.ms.DataEncoder;
import com.sun.deg.sunvts.ms.DataParser;
import com.sun.deg.sunvts.ms.Server;
import java.util.ArrayList;
import java.util.List;

public class ServerAdapter {
    private Server server;
    private static ServerAdapter serveradapter;
    private DataEncoder encoder = new DataEncoder();
    private DataParser parser = new DataParser();

    private ServerAdapter() {
        this.server = Server.getServer();
    }

    public static ServerAdapter getServerAdapter() {
        if (serveradapter == null) {
            serveradapter = new ServerAdapter();
        }
        return serveradapter;
    }

    public boolean isDeviceOptExist(String testName) throws Exception {
        String returnValue;
        String command = "does_deviceOpt_exist";
        if (testName != null) {
            command = command + " " + testName;
        }
        if ((returnValue = this.server.executeCommand(command)) == null) {
            throw new Exception(returnValue);
        }
        boolean returnVal = Boolean.parseBoolean(returnValue);
        return returnVal;
    }

    public HostConfig getHostConfig() throws Exception {
        String command = "get_host_config";
        String hostConfigString = this.server.executeCommand(command);
        return this.parser.parseHostConfig(hostConfigString);
    }

    public String getVersion() throws Exception {
        String command = "get_version";
        String versionString = this.server.executeCommand(command);
        return versionString;
    }

    public void saveSession(boolean overwrite, String defaultMode, String sessionType, String sessionName) throws Exception {
        String returnValue;
        String command = "save_session";
        if (sessionName != null) {
            command = command + " " + this.encoder.encodeSaveSessionParams(overwrite, defaultMode, sessionType, sessionName);
        }
        if (!(returnValue = this.server.executeCommand(command)).equalsIgnoreCase("DONE")) {
            throw new Exception(returnValue);
        }
    }

    public void deleteSession(String sessionName) throws Exception {
        String returnValue;
        String command = "delete_session";
        if (sessionName != null) {
            command = command + " " + sessionName;
        }
        if (!(returnValue = this.server.executeCommand(command)).equalsIgnoreCase("DONE")) {
            throw new Exception(returnValue);
        }
    }

    public List listSessions() throws Exception {
        String command = "list_sessions";
        String sessions = this.server.executeCommand(command);
        return this.parser.parseDelimitedNames(sessions, ",");
    }

    public void loadSession(String defaultMode, String sessionName) throws Exception {
        String returnValue;
        String command = "load_session";
        if (sessionName != null) {
            command = command + " " + this.encoder.encodeLoadSessionParams(defaultMode, sessionName);
        }
        if (!(returnValue = this.server.executeCommand(command)).equalsIgnoreCase("DONE")) {
            throw new Exception(returnValue);
        }
    }

    public void resetSession() throws Exception {
        String command = "reset_session";
        String returnValue = this.server.executeCommand(command);
        if (!returnValue.equalsIgnoreCase("DONE")) {
            throw new Exception(returnValue);
        }
    }

    public void reprobe() throws Exception {
        String command = "reprobe";
        String returnValue = this.server.executeCommand(command);
        if (!returnValue.equalsIgnoreCase("DONE")) {
            throw new Exception(returnValue);
        }
    }

    public void setMode(String mode) throws Exception {
        String command = "set_mode";
        if (mode == null) {
            throw new Exception("No mode is selected");
        }
        String returnValue = this.server.executeCommand(command = command + " [" + mode + "]");
        if (!returnValue.equalsIgnoreCase("DONE")) {
            throw new Exception(returnValue);
        }
    }

    public void setGlobalOptions(List optionList) throws Exception {
        String returnValue;
        String command = "set_global_options";
        String options = this.encoder.encodeTestOptions(optionList);
        if (options != null) {
            command = command + " " + options;
        }
        if (!(returnValue = this.server.executeCommand(command)).equalsIgnoreCase("DONE")) {
            throw new Exception(returnValue);
        }
    }

    public List getGlobalOptions() throws Exception {
        String command = "get_global_options";
        String options = this.server.executeCommand(command);
        return this.parser.parseTestOptions(options);
    }

    public void setModeSequencer(List optionList) throws Exception {
        String returnValue;
        String command = "set_modesequencer_options";
        String options = this.encoder.encodeTestOptions(optionList);
        if (options != null) {
            command = command + " " + options;
        }
        if (!(returnValue = this.server.executeCommand(command)).equalsIgnoreCase("DONE")) {
            throw new Exception(returnValue);
        }
    }

    public List getModeSequencer() throws Exception {
        String command = "get_modesequencer_options";
        String options = this.server.executeCommand(command);
        return this.parser.parseTestOptions(options);
    }

    public LTPageData getLTPageData() throws Exception {
        String command = "get_ltpage_data";
        String ltPageDataString = this.server.executeCommand(command);
        return this.parser.parseLTPageData(ltPageDataString);
    }

    public void enableTest(String testName) throws Exception {
        String returnValue;
        String command = "enable_test";
        if (testName != null) {
            command = command + " " + testName;
        }
        if (!(returnValue = this.server.executeCommand(command)).equalsIgnoreCase("DONE")) {
            throw new Exception(returnValue);
        }
    }

    public void disableTest(String testName) throws Exception {
        String returnValue;
        String command = "disable_test";
        if (testName != null) {
            command = command + " " + testName;
        }
        if (!(returnValue = this.server.executeCommand(command)).equalsIgnoreCase("DONE")) {
            throw new Exception(returnValue);
        }
    }

    public void setTestOptions(String testName, List optionList) throws Exception {
        String returnValue;
        String options;
        String command = "set_test_options";
        if (testName != null) {
            command = command + " " + testName;
        }
        if ((options = this.encoder.encodeTestOptions(optionList)) != null) {
            command = command + " " + options;
        }
        if (!(returnValue = this.server.executeCommand(command)).equalsIgnoreCase("DONE")) {
            throw new Exception(returnValue);
        }
    }

    public List getTestOptions(String testName) throws Exception {
        String command = "get_test_options";
        if (testName != null) {
            command = command + " " + testName;
        }
        String options = this.server.executeCommand(command);
        return this.parser.parseTestOptions(options);
    }

    public void setDeviceOptions(String testName, String deviceName, List optionList) throws Exception {
        String returnValue;
        String options;
        String command = "set_device_options";
        if (testName != null) {
            command = command + " " + testName.concat(".").concat(deviceName);
        }
        if ((options = this.encoder.encodeDeviceOptions(optionList)) != null) {
            command = command + " " + options;
        }
        if (!(returnValue = this.server.executeCommand(command)).equalsIgnoreCase("DONE")) {
            throw new Exception(returnValue);
        }
    }

    public List getDeviceOptions(String testName, String deviceName) throws Exception {
        String options;
        String command = "get_device_options";
        if (testName != null) {
            command = command + " " + testName.concat(".").concat(deviceName);
        }
        if ((options = this.server.executeCommand(command)).contains("Cannot retrieve") || options.contains("No options")) {
            ArrayList<String> tempList = new ArrayList<String>();
            tempList.add(options);
            return tempList;
        }
        return this.parser.parseDeviceOptions(options);
    }

    public void start() throws Exception {
        String command = "start";
        String returnValue = this.server.executeCommand(command);
        if (!returnValue.equalsIgnoreCase("DONE")) {
            throw new Exception(returnValue);
        }
    }

    public void stop() throws Exception {
        String command = "stop";
        String returnValue = this.server.executeCommand(command);
        if (!returnValue.equalsIgnoreCase("DONE")) {
            throw new Exception(returnValue);
        }
    }

    public void resetTestCounters() throws Exception {
        String command = "reset";
        String returnValue = this.server.executeCommand(command);
        if (!returnValue.equalsIgnoreCase("DONE")) {
            throw new Exception(returnValue);
        }
    }

    public void deleteLog(String logName) throws Exception {
        String returnValue;
        String command = "delete_log";
        if (logName != null) {
            command = command + " " + logName;
        }
        if (!(returnValue = this.server.executeCommand(command)).equalsIgnoreCase("DONE")) {
            throw new Exception(returnValue);
        }
    }

    public String getLog(String logName, int noOfLines) throws Exception {
        String command = "get_log";
        if (logName != null) {
            command = command + " " + logName;
        }
        if (noOfLines >= 0) {
            command = command + " " + noOfLines;
        }
        return this.server.executeCommand(command);
    }

    public String checkManuf() throws Exception {
        String command = "check_manuf";
        return this.server.executeCommand(command);
    }

    public void createTSSRLog() throws Exception {
        String command = "create_tssr_log";
        String returnValue = this.server.executeCommand(command);
        if (!returnValue.equalsIgnoreCase("DONE")) {
            throw new Exception(command + " " + returnValue);
        }
    }

    public void createReportLog() throws Exception {
        String command = "create_vtsreport_log";
        String returnValue = this.server.executeCommand(command);
        if (!returnValue.equalsIgnoreCase("DONE")) {
            throw new Exception(command.concat(returnValue));
        }
    }

    public void quit() throws Exception {
        String command = "quit";
        String returnValue = this.server.executeCommand(command);
        if (!returnValue.equalsIgnoreCase("DONE")) {
            throw new Exception(returnValue);
        }
    }
}

