/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.fsmgr.share;

import com.sun.audit.AuditEvent_filesystem_add;
import com.sun.audit.AuditEvent_filesystem_delete;
import com.sun.audit.AuditSession;
import com.sun.wbem.cimom.audit.WbemAuditSession;
import com.sun.wbem.solarisprovider.fsmgr.common.FsMgrException;
import com.sun.wbem.solarisprovider.fsmgr.common.FsMgrProvider;
import com.sun.wbem.solarisprovider.fsmgr.common.Solaris_FileSystem_Native;
import com.sun.wbem.solarisprovider.fsmgr.share.FsMgrDfsTable;
import com.sun.wbem.solarisprovider.fsmgr.share.FsMgrShare;
import com.sun.wbem.solarisprovider.fsmgr.share.FsMgrShareData;
import com.sun.wbem.solarisprovider.fsmgr.share.FsMgrShareTable;
import com.sun.wbem.solarisprovider.fsmgr.share.FsMgrShareWrapper;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.Debug;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.MethodProvider;

public class Solaris_NFSExport
extends FsMgrProvider
implements Authorizable,
MethodProvider {
    private static final String shareTable = FsMgrShareTable.SHARETAB;
    private static final String dfsTable = FsMgrDfsTable.DFSTAB;
    private static final String DIRECTORY = "Directory";
    private static final String LFS = "LocalFS";
    private static final String NAME = "Name";
    private static final String CS_CREATION_CLASS = "CSCreationClassName";
    private static final String FS_CREATION_CLASS = "FSCreationClassName";
    private static final String CREATION_CLASS = "CreationClassName";
    private static final String SOLARIS_CS = "Solaris_ComputerSystem";
    private static final String CS_NAME = "CSName";
    private static final String FSNAME = "FSName";
    private static final String OPTIONS = "ShareOptions";
    private static final String EXPORTED_DIR_NAME = "ExportedDirectoryName";
    private static final String DESCRIPTION = "Description";
    private static final String NFS_TYPE = "nfs";
    private static final String UFS_TYPE = "ufs";
    private static final String HSFS_TYPE = "hsfs";
    private static final String SOLARIS_DIR = "Solaris_Directory";
    protected static final String SOLARIS_UFS = "Solaris_UFS";
    protected static final String SOLARIS_HSFS = "Solaris_HSFS";
    private static final String SHARE_AT_BOOT = "ShareAtBootEntry";
    private static final String NAME_SPACE = "/root/cimv2";
    private int[] sabIndex;

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        Object object;
        FsMgrShareData fsMgrShareData;
        FsMgrShare fsMgrShare;
        String string;
        this.provUtil.checkRights("solaris.admin.fsmgr.write", cIMObjectPath);
        String string2 = null;
        CIMObjectPath cIMObjectPath2 = (CIMObjectPath)cIMInstance.getProperty(DIRECTORY).getValue().getValue();
        cIMObjectPath2.setNameSpace(NAME_SPACE);
        Enumeration enumeration = cIMObjectPath2.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            string = (CIMProperty)enumeration.nextElement();
            if (!string.getName().equalsIgnoreCase(NAME)) continue;
            string2 = (String)string.getValue().getValue();
        }
        string = NFS_TYPE;
        String string3 = (String)cIMInstance.getProperty(EXPORTED_DIR_NAME).getValue().getValue();
        String string4 = (String)cIMInstance.getProperty(OPTIONS).getValue().getValue();
        String string5 = (String)cIMInstance.getProperty(DESCRIPTION).getValue().getValue();
        boolean bl = (Boolean)cIMInstance.getProperty(SHARE_AT_BOOT).getValue().getValue();
        FsMgrShare fsMgrShare2 = new FsMgrShare(string2, string3, string, string4, string5);
        if (fsMgrShare2 == null) {
            return null;
        }
        FsMgrShareWrapper fsMgrShareWrapper = new FsMgrShareWrapper(this);
        try {
            fsMgrShare = null;
            boolean bl2 = false;
            fsMgrShare = fsMgrShareWrapper.getShareEntry(dfsTable, string2);
            if (fsMgrShare != null) {
                fsMgrShareData = new FsMgrShareData(fsMgrShare2);
                object = new FsMgrShareData(fsMgrShare);
                bl2 = fsMgrShareData.equals(object);
            }
            fsMgrShareWrapper.addShare(fsMgrShare2, shareTable);
            if (bl) {
                if (!bl2) {
                    if (!bl2 && fsMgrShare != null) {
                        fsMgrShareWrapper.removeShare(fsMgrShare, dfsTable);
                        fsMgrShareWrapper.addShare(fsMgrShare2, dfsTable);
                    } else if (fsMgrShare == null) {
                        fsMgrShareWrapper.addShare(fsMgrShare2, dfsTable);
                    }
                }
            } else if (!bl2 && fsMgrShare != null) {
                fsMgrShareWrapper.removeShare(fsMgrShare, dfsTable);
            }
        }
        catch (FsMgrException fsMgrException) {
            String string6 = this.provUtil.writeLog(2, (Exception)((Object)fsMgrException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string6);
        }
        try {
            fsMgrShare = this.provUtil.getAuditSession();
            if (fsMgrShare == null) {
                Debug.trace3((String)"Solaris_NFSExport createInstance() : null WbemAuditSession.");
                return null;
            }
            AuditSession auditSession = (AuditSession)fsMgrShare.getPlatformAuditSession();
            if (auditSession == null) {
                Debug.trace3((String)"Solaris_NFSExport createInstance() : null platform AuditSession.");
                return null;
            }
            fsMgrShareData = new AuditEvent_filesystem_add(auditSession);
            if (fsMgrShareData == null) {
                Debug.trace3((String)"Solaris_NFSExport createInstance() : null AuditEvent_filesystem_add.");
                return null;
            }
            object = this.provUtil.formatAuditToken(cIMInstance);
            String string7 = this.provUtil.getMgmtScope(cIMObjectPath);
            fsMgrShareData.object_name(cIMObjectPath.getObjectName());
            fsMgrShareData.domain(this.provUtil.getDomainToken(string7));
            fsMgrShareData.name_service(this.provUtil.getNameServiceToken(string7));
            fsMgrShareData.auth_used("solaris.admin.fsmgr.write");
            fsMgrShareData.initial_values((String)object);
            fsMgrShareData.putEvent(0, 0);
        }
        catch (Exception exception) {
            Debug.trace3((String)"Solaris_NFSExport createInstance() : Auditing threw exception", (Throwable)exception);
            return null;
        }
        return null;
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        Object object;
        this.provUtil.checkRights("solaris.admin.fsmgr.write", cIMObjectPath);
        CIMObjectPath cIMObjectPath2 = null;
        String string = null;
        FsMgrShare fsMgrShare = null;
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            object = (CIMProperty)enumeration.nextElement();
            if (!object.getName().equalsIgnoreCase(LFS)) continue;
            cIMObjectPath2 = (CIMObjectPath)object.getValue().getValue();
            cIMObjectPath2.setNameSpace(NAME_SPACE);
        }
        enumeration = cIMObjectPath2.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            object = (CIMProperty)enumeration.nextElement();
            if (!object.getName().equalsIgnoreCase(NAME)) continue;
            string = (String)object.getValue().getValue();
        }
        if (string == null) {
            return;
        }
        object = new FsMgrShareWrapper(this);
        try {
            fsMgrShare = ((FsMgrShareWrapper)object).getShareEntry(shareTable, string);
            if (fsMgrShare == null) {
                return;
            }
            ((FsMgrShareWrapper)object).removeShare(fsMgrShare, shareTable);
        }
        catch (FsMgrException fsMgrException) {
            String string2 = this.provUtil.writeLog(2, (Exception)((Object)fsMgrException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        try {
            WbemAuditSession wbemAuditSession = this.provUtil.getAuditSession();
            if (wbemAuditSession == null) {
                Debug.trace3((String)"Solaris_NFSExport deleteInstance() : null WbemAuditSession.");
                return;
            }
            AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
            if (auditSession == null) {
                Debug.trace3((String)"Solaris_NFSExport deleteInstance() : null platform AuditSession.");
                return;
            }
            AuditEvent_filesystem_delete auditEvent_filesystem_delete = new AuditEvent_filesystem_delete(auditSession);
            if (auditEvent_filesystem_delete == null) {
                Debug.trace3((String)"Solaris_NFSExport deleteInstance() : null AuditEvent_filesystem_delete.");
                return;
            }
            String string3 = this.provUtil.getMgmtScope(cIMObjectPath);
            auditEvent_filesystem_delete.object_name(cIMObjectPath.getObjectName());
            auditEvent_filesystem_delete.domain(this.provUtil.getDomainToken(string3));
            auditEvent_filesystem_delete.name_service(this.provUtil.getNameServiceToken(string3));
            auditEvent_filesystem_delete.auth_used("solaris.admin.fsmgr.write");
            auditEvent_filesystem_delete.delete_values(string);
            auditEvent_filesystem_delete.putEvent(0, 0);
        }
        catch (Exception exception) {
            Debug.trace3((String)"Solaris_NFSExport deleteInstance() : Auditing threw exception", (Throwable)exception);
            return;
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        Serializable serializable;
        this.provUtil.checkRights("solaris.admin.fsmgr.read", cIMObjectPath);
        CIMObjectPath cIMObjectPath2 = null;
        Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
        Vector vector2 = null;
        String string = null;
        FsMgrShareWrapper fsMgrShareWrapper = new FsMgrShareWrapper(this);
        try {
            Vector vector3 = fsMgrShareWrapper.getShareList(shareTable);
            serializable = fsMgrShareWrapper.getShareList(dfsTable);
            if (vector3.size() <= 0) {
                return null;
            }
            vector2 = this.mergeShareLists(vector3, (Vector)serializable);
        }
        catch (FsMgrException fsMgrException) {
            String string2 = this.provUtil.writeLog(2, (Exception)((Object)fsMgrException));
            fsMgrException.printStackTrace();
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        for (int i = 0; vector2 != null && i < vector2.size(); ++i) {
            serializable = (FsMgrShare)vector2.elementAt(i);
            string = Solaris_FileSystem_Native.GetFSType(((FsMgrShare)serializable).getPathname());
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath(SOLARIS_DIR);
            boolean bl = string.equalsIgnoreCase(HSFS_TYPE);
            cIMObjectPath2 = bl ? new CIMObjectPath(SOLARIS_HSFS) : new CIMObjectPath(SOLARIS_UFS);
            CIMObjectPath cIMObjectPath4 = new CIMObjectPath(cIMObjectPath3.getObjectName(), cIMObjectPath3.getNameSpace());
            CIMObjectPath cIMObjectPath5 = new CIMObjectPath(cIMObjectPath2.getObjectName(), cIMObjectPath2.getNameSpace());
            cIMObjectPath5.addKey(NAME, new CIMValue((Object)((FsMgrShare)serializable).getPathname()));
            cIMObjectPath5.addKey(CS_CREATION_CLASS, new CIMValue((Object)SOLARIS_CS));
            try {
                cIMObjectPath5.addKey(CS_NAME, new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) {
                cIMObjectPath5.addKey(CREATION_CLASS, new CIMValue((Object)SOLARIS_HSFS));
            } else {
                cIMObjectPath5.addKey(CREATION_CLASS, new CIMValue((Object)SOLARIS_UFS));
            }
            cIMObjectPath4.addKey(NAME, new CIMValue((Object)((FsMgrShare)serializable).getPathname()));
            cIMObjectPath4.addKey(CS_CREATION_CLASS, new CIMValue((Object)SOLARIS_CS));
            try {
                cIMObjectPath4.addKey(CS_NAME, new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            cIMObjectPath4.addKey(CREATION_CLASS, new CIMValue((Object)SOLARIS_DIR));
            cIMObjectPath4.addKey(FSNAME, new CIMValue((Object)string));
            cIMObjectPath4.addKey(FS_CREATION_CLASS, new CIMValue((Object)string));
            CIMObjectPath cIMObjectPath6 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
            cIMObjectPath6.addKey(LFS, new CIMValue((Object)cIMObjectPath5));
            cIMObjectPath6.addKey(DIRECTORY, new CIMValue((Object)cIMObjectPath4));
            vector.addElement(cIMObjectPath6);
        }
        CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[vector.size()];
        vector.toArray(cIMObjectPathArray);
        return cIMObjectPathArray;
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        Vector vector;
        this.provUtil.checkRights("solaris.admin.fsmgr.read", cIMObjectPath);
        Vector vector2 = null;
        Vector<CIMInstance> vector3 = new Vector<CIMInstance>();
        String string = null;
        CIMObjectPath cIMObjectPath2 = null;
        FsMgrShareWrapper fsMgrShareWrapper = new FsMgrShareWrapper(this);
        try {
            Vector vector4 = fsMgrShareWrapper.getShareList(shareTable);
            vector = fsMgrShareWrapper.getShareList(dfsTable);
            if (vector4.size() <= 0) {
                return null;
            }
            vector2 = this.mergeShareLists(vector4, vector);
        }
        catch (FsMgrException fsMgrException) {
            String string2 = this.provUtil.writeLog(2, (Exception)((Object)fsMgrException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        for (int i = 0; vector2 != null && i < vector2.size(); ++i) {
            vector = cIMClass.newInstance();
            FsMgrShare fsMgrShare = (FsMgrShare)vector2.elementAt(i);
            string = Solaris_FileSystem_Native.GetFSType(fsMgrShare.getPathname());
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath(SOLARIS_DIR);
            boolean bl4 = string.equalsIgnoreCase(HSFS_TYPE);
            cIMObjectPath2 = bl4 ? new CIMObjectPath(SOLARIS_HSFS) : new CIMObjectPath(SOLARIS_UFS);
            CIMObjectPath cIMObjectPath4 = new CIMObjectPath(cIMObjectPath3.getObjectName(), cIMObjectPath3.getNameSpace());
            CIMObjectPath cIMObjectPath5 = new CIMObjectPath(cIMObjectPath2.getObjectName(), cIMObjectPath2.getNameSpace());
            cIMObjectPath5.addKey(NAME, new CIMValue((Object)fsMgrShare.getPathname()));
            cIMObjectPath5.addKey(CS_CREATION_CLASS, new CIMValue((Object)SOLARIS_CS));
            try {
                cIMObjectPath5.addKey(CS_NAME, new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl4) {
                cIMObjectPath5.addKey(CREATION_CLASS, new CIMValue((Object)SOLARIS_HSFS));
            } else {
                cIMObjectPath5.addKey(CREATION_CLASS, new CIMValue((Object)SOLARIS_UFS));
            }
            cIMObjectPath4.addKey(NAME, new CIMValue((Object)fsMgrShare.getPathname()));
            cIMObjectPath4.addKey(CS_CREATION_CLASS, new CIMValue((Object)SOLARIS_CS));
            try {
                cIMObjectPath4.addKey(CS_NAME, new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            cIMObjectPath4.addKey(CREATION_CLASS, new CIMValue((Object)SOLARIS_DIR));
            cIMObjectPath4.addKey(FSNAME, new CIMValue((Object)string));
            cIMObjectPath4.addKey(FS_CREATION_CLASS, new CIMValue((Object)string));
            vector.setProperty(LFS, new CIMValue((Object)cIMObjectPath5));
            vector.setProperty(DIRECTORY, new CIMValue((Object)cIMObjectPath4));
            vector.setProperty(EXPORTED_DIR_NAME, new CIMValue((Object)fsMgrShare.getResource()));
            vector.setProperty(OPTIONS, new CIMValue((Object)fsMgrShare.getOptions()));
            vector.setProperty(DESCRIPTION, new CIMValue((Object)fsMgrShare.getDescription()));
            if (this.sabIndex[i] == 1) {
                vector.setProperty(SHARE_AT_BOOT, new CIMValue((Object)new Boolean("true")));
            } else {
                vector.setProperty(SHARE_AT_BOOT, new CIMValue((Object)new Boolean("false")));
            }
            if (bl) {
                vector = vector.localElements();
            }
            vector3.addElement(vector.filterProperties(stringArray, bl2, bl3));
        }
        CIMInstance[] cIMInstanceArray = new CIMInstance[vector3.size()];
        vector3.toArray(cIMInstanceArray);
        return cIMInstanceArray;
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        FsMgrShareData fsMgrShareData;
        Object object;
        Object object2;
        Object object3;
        this.provUtil.checkRights("solaris.admin.fsmgr.read", cIMObjectPath);
        CIMObjectPath cIMObjectPath2 = null;
        CIMObjectPath cIMObjectPath3 = null;
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            object3 = (CIMProperty)enumeration.nextElement();
            if (object3.getName().equalsIgnoreCase(LFS)) {
                cIMObjectPath2 = (CIMObjectPath)object3.getValue().getValue();
            }
            if (!object3.getName().equalsIgnoreCase(DIRECTORY)) continue;
            cIMObjectPath3 = (CIMObjectPath)object3.getValue().getValue();
        }
        object3 = null;
        enumeration = cIMObjectPath2.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            object2 = (CIMProperty)enumeration.nextElement();
            if (!object2.getName().equalsIgnoreCase(NAME)) continue;
            object3 = (String)object2.getValue().getValue();
        }
        object2 = new FsMgrShareWrapper(this);
        if (object3 == null) {
            return null;
        }
        FsMgrShare fsMgrShare = null;
        FsMgrShare fsMgrShare2 = null;
        boolean bl4 = false;
        try {
            fsMgrShare = ((FsMgrShareWrapper)object2).getShareEntry(shareTable, (String)object3);
            fsMgrShare2 = ((FsMgrShareWrapper)object2).getShareEntry(dfsTable, (String)object3);
            if (fsMgrShare2 != null && ((FsMgrShareData)(object = new FsMgrShareData(fsMgrShare))).equals(fsMgrShareData = new FsMgrShareData(fsMgrShare2))) {
                bl4 = true;
            }
        }
        catch (FsMgrException fsMgrException) {
            String string = this.provUtil.writeLog(2, (Exception)((Object)fsMgrException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        object = null;
        if (fsMgrShare == null) {
            return null;
        }
        object = fsMgrShare;
        fsMgrShareData = cIMClass.newInstance();
        fsMgrShareData.setProperty(LFS, new CIMValue((Object)cIMObjectPath2));
        fsMgrShareData.setProperty(DIRECTORY, new CIMValue((Object)cIMObjectPath3));
        fsMgrShareData.setProperty(EXPORTED_DIR_NAME, new CIMValue((Object)((FsMgrShare)object).getResource()));
        fsMgrShareData.setProperty(OPTIONS, new CIMValue((Object)((FsMgrShare)object).getOptions()));
        fsMgrShareData.setProperty(DESCRIPTION, new CIMValue((Object)((FsMgrShare)object).getDescription()));
        fsMgrShareData.setProperty(SHARE_AT_BOOT, new CIMValue((Object)new Boolean(bl4)));
        if (bl) {
            fsMgrShareData = fsMgrShareData.localElements();
        }
        return fsMgrShareData.filterProperties(stringArray, bl2, bl3);
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        if (string.equalsIgnoreCase("deleteDfstabEntry")) {
            String string2 = (String)((CIMValue)vector.elementAt(0)).getValue();
            Integer n = this.deleteDfstabEntry(string2);
            if (n == -1) {
                return new CIMValue((Object)n);
            }
            try {
                WbemAuditSession wbemAuditSession = this.provUtil.getAuditSession();
                if (wbemAuditSession == null) {
                    Debug.trace3((String)"Solaris_NFSExport deleteDfstabEntry() : null WbemAuditSession.");
                    return new CIMValue((Object)n);
                }
                AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
                if (auditSession == null) {
                    Debug.trace3((String)"Solaris_NFSExport deleteDfstabEntry() : null platform AuditSession.");
                    return new CIMValue((Object)n);
                }
                AuditEvent_filesystem_delete auditEvent_filesystem_delete = new AuditEvent_filesystem_delete(auditSession);
                if (auditEvent_filesystem_delete == null) {
                    Debug.trace3((String)"Solaris_NFSExport deleteDfstabEntry() : null AuditEvent_filesystem_delete.");
                    return new CIMValue((Object)n);
                }
                String string3 = this.provUtil.getMgmtScope(cIMObjectPath);
                auditEvent_filesystem_delete.object_name(cIMObjectPath.getObjectName());
                auditEvent_filesystem_delete.domain(this.provUtil.getDomainToken(string3));
                auditEvent_filesystem_delete.name_service(this.provUtil.getNameServiceToken(string3));
                auditEvent_filesystem_delete.auth_used("solaris.admin.fsmgr.write");
                auditEvent_filesystem_delete.delete_values(string2);
                auditEvent_filesystem_delete.putEvent(0, 0);
            }
            catch (Exception exception) {
                Debug.trace3((String)"Solaris_NFSExport deleteDfstabEntry() : Auditing threw exception", (Throwable)exception);
                return new CIMValue((Object)n);
            }
            return new CIMValue((Object)n);
        }
        return null;
    }

    public Integer deleteDfstabEntry(String string) throws CIMException {
        FsMgrShareWrapper fsMgrShareWrapper = new FsMgrShareWrapper(this);
        try {
            FsMgrShare fsMgrShare = fsMgrShareWrapper.getShareEntry(dfsTable, string);
            if (fsMgrShare == null) {
                return new Integer(-1);
            }
            fsMgrShareWrapper.removeShare(fsMgrShare, dfsTable);
        }
        catch (FsMgrException fsMgrException) {
            String string2 = this.provUtil.writeLog(2, (Exception)((Object)fsMgrException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        return new Integer(0);
    }

    private Vector mergeShareLists(Vector vector, Vector vector2) {
        Vector<FsMgrShare> vector3 = new Vector<FsMgrShare>();
        this.sabIndex = new int[vector.size()];
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            FsMgrShare fsMgrShare = (FsMgrShare)vector.elementAt(i);
            FsMgrShareData fsMgrShareData = new FsMgrShareData(fsMgrShare);
            int n = 0;
            for (int j = 0; vector2 != null && j < vector2.size(); ++j) {
                FsMgrShare fsMgrShare2 = (FsMgrShare)vector2.elementAt(j);
                FsMgrShareData fsMgrShareData2 = new FsMgrShareData(fsMgrShare2);
                if (!fsMgrShareData.equals(fsMgrShareData2)) continue;
                n = 1;
                break;
            }
            vector3.addElement(fsMgrShare);
            this.sabIndex[i] = n;
        }
        return vector3;
    }
}

