/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sql.rowset.internal;

import com.sun.sql.rowset.CachedRowSetX;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetReader;
import javax.sql.rowset.CachedRowSet;

public class CachedRowSetXReader
implements RowSetReader,
Serializable {
    private static ResourceBundle rb = ResourceBundle.getBundle("com.sun.sql.rowset.internal.Bundle", Locale.getDefault());
    private int writerCalls = 0;
    private boolean userCon = false;
    private int startPosition;

    /*
     * Loose catch block
     */
    public void readData(RowSetInternal caller) throws SQLException {
        block52: {
            boolean printStatements;
            Connection con;
            block51: {
                CachedRowSet crs;
                block50: {
                    con = null;
                    printStatements = caller instanceof CachedRowSetX ? ((CachedRowSetX)((Object)caller)).getPrintStatements() : false;
                    crs = (CachedRowSet)((Object)caller);
                    if (crs.getPageSize() == 0 && crs.size() > 0) {
                        crs.close();
                    }
                    this.writerCalls = 0;
                    this.userCon = false;
                    con = this.connect(caller);
                    if (con == null || crs.getCommand() == null) {
                        throw new SQLException("Internal Error in RowSetReader: no connection or command.");
                    }
                    try {
                        con.setTransactionIsolation(crs.getTransactionIsolation());
                    }
                    catch (Exception ex) {
                        if (!printStatements) break block50;
                        System.out.println("setTransactionIsolation() failed " + crs.getTransactionIsolation());
                    }
                }
                PreparedStatement pstmt = con.prepareStatement(crs.getCommand());
                this.decodeParams(caller.getParams(), pstmt);
                StringBuffer msg = null;
                if (printStatements) {
                    msg = new StringBuffer(200);
                    msg.append(crs.getCommand());
                    msg.append("\n");
                    Object[] params = caller.getParams();
                    if (params.length > 0) {
                        for (int i = 0; i < params.length; ++i) {
                            msg.append("  Param[" + (i + 1) + "]=(");
                            if (params[i] != null) {
                                msg.append(params[i].getClass().getName() + "," + params[i].toString() + ")");
                                continue;
                            }
                            msg.append("null)");
                        }
                    } else {
                        msg.append(" No Params");
                    }
                }
                try {
                    pstmt.setMaxRows(crs.getMaxRows());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    pstmt.setMaxFieldSize(crs.getMaxFieldSize());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    pstmt.setEscapeProcessing(crs.getEscapeProcessing());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    pstmt.setQueryTimeout(crs.getQueryTimeout());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (crs.getCommand().toLowerCase().indexOf("select") != -1) {
                    ResultSet rs;
                    if (crs.getPageSize() == 0) {
                        if (printStatements) {
                            System.out.println("Reader executing query ps=0 " + msg);
                        }
                        rs = pstmt.executeQuery();
                        crs.populate(rs);
                        if (printStatements) {
                            System.out.println("Reader executing finished");
                        }
                    } else {
                        pstmt = con.prepareStatement(crs.getCommand(), 1004, 1008);
                        this.decodeParams(caller.getParams(), pstmt);
                        try {
                            pstmt.setMaxRows(crs.getMaxRows());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            pstmt.setMaxFieldSize(crs.getMaxFieldSize());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            pstmt.setEscapeProcessing(crs.getEscapeProcessing());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            pstmt.setQueryTimeout(crs.getQueryTimeout());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        if (printStatements) {
                            System.out.println("Reader executing query ps=" + crs.getPageSize() + " " + msg);
                        }
                        rs = pstmt.executeQuery();
                        crs.populate(rs, this.startPosition);
                        if (printStatements) {
                            System.out.println("Reader executing finished");
                        }
                    }
                    rs.close();
                } else {
                    if (printStatements) {
                        System.out.println("Reader executing non-select " + msg);
                    }
                    pstmt.executeUpdate();
                    if (printStatements) {
                        System.out.println("Reader executing finished");
                    }
                }
                pstmt.close();
                try {
                    con.commit();
                }
                catch (SQLException ex) {
                    if (!printStatements) break block51;
                    ex.printStackTrace();
                }
            }
            Object var10_20 = null;
            try {
                if (con == null || !this.getCloseConnection()) break block52;
                try {
                    if (!con.getAutoCommit()) {
                        con.rollback();
                    }
                }
                catch (Exception dummy) {
                    // empty catch block
                }
                con.close();
                con = null;
            }
            catch (SQLException e) {}
            break block52;
            {
                catch (SQLException ex) {
                    if (printStatements) {
                        ex.printStackTrace();
                    }
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                block54: {
                    Object var10_21 = null;
                    try {
                        if (con == null || !this.getCloseConnection()) break block54;
                        try {
                            if (!con.getAutoCommit()) {
                                con.rollback();
                            }
                        }
                        catch (Exception dummy) {
                            // empty catch block
                        }
                        con.close();
                        con = null;
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public boolean reset() throws SQLException {
        ++this.writerCalls;
        return this.writerCalls == 1;
    }

    public Connection connect(RowSetInternal caller) throws SQLException {
        if (caller.getConnection() != null) {
            this.userCon = true;
            return caller.getConnection();
        }
        if (((RowSet)((Object)caller)).getDataSourceName() != null) {
            try {
                InitialContext ctx = new InitialContext();
                DataSource ds = (DataSource)ctx.lookup(((RowSet)((Object)caller)).getDataSourceName());
                if (((RowSet)((Object)caller)).getUsername() != null) {
                    return ds.getConnection(((RowSet)((Object)caller)).getUsername(), ((RowSet)((Object)caller)).getPassword());
                }
                return ds.getConnection();
            }
            catch (NamingException ex) {
                SQLException sqlEx = new SQLException();
                sqlEx.initCause(ex);
                throw sqlEx;
            }
        }
        if (((RowSet)((Object)caller)).getUrl() != null) {
            return DriverManager.getConnection(((RowSet)((Object)caller)).getUrl(), ((RowSet)((Object)caller)).getUsername(), ((RowSet)((Object)caller)).getPassword());
        }
        return null;
    }

    private void decodeParams(Object[] params, PreparedStatement pstmt) throws SQLException {
        Object[] param = null;
        for (int i = 0; i < params.length; ++i) {
            if (params[i] instanceof Object[]) {
                param = (Object[])params[i];
                if (param.length == 2) {
                    if (param[0] == null) {
                        pstmt.setNull(i + 1, (Integer)param[1]);
                        continue;
                    }
                    if (param[0] instanceof Date || param[0] instanceof Time || param[0] instanceof Timestamp) {
                        System.err.println(rb.getString("DETECTED_A_DATE"));
                        if (param[1] instanceof Calendar) {
                            System.err.println(rb.getString("DETECTED_A_CALENDAR"));
                            pstmt.setDate(i + 1, (Date)param[0], (Calendar)param[1]);
                            continue;
                        }
                        throw new SQLException(rb.getString("UNABLE_TO_DEDUCE_PARAM_TYPE"));
                    }
                    if (param[0] instanceof Reader) {
                        pstmt.setCharacterStream(i + 1, (Reader)param[0], (Integer)param[1]);
                        continue;
                    }
                    if (!(param[1] instanceof Integer)) continue;
                    pstmt.setObject(i + 1, param[0], (Integer)param[1]);
                    continue;
                }
                if (param.length == 3) {
                    if (param[0] == null) {
                        pstmt.setNull(i + 1, (Integer)param[1], (String)param[2]);
                        continue;
                    }
                    if (param[0] instanceof InputStream) {
                        switch ((Integer)param[2]) {
                            case 0: {
                                pstmt.setUnicodeStream(i + 1, (InputStream)param[0], (Integer)param[1]);
                            }
                            case 1: {
                                pstmt.setBinaryStream(i + 1, (InputStream)param[0], (Integer)param[1]);
                            }
                            case 2: {
                                pstmt.setAsciiStream(i + 1, (InputStream)param[0], (Integer)param[1]);
                            }
                        }
                        throw new SQLException(rb.getString("UNABLE_TO_DEDUCE_PARAM_TYPE"));
                    }
                    if (param[1] instanceof Integer && param[2] instanceof Integer) {
                        pstmt.setObject(i + 1, param[0], (Integer)param[1], (int)((Integer)param[2]));
                        continue;
                    }
                    throw new SQLException(rb.getString("UNABLE_TO_DEDUCE_PARAM_TYPE"));
                }
                pstmt.setObject(i + 1, params[i]);
                continue;
            }
            pstmt.setObject(i + 1, params[i]);
        }
    }

    protected boolean getCloseConnection() {
        return !this.userCon;
    }

    public void setStartPosition(int pos) {
        this.startPosition = pos;
    }
}

