/*
 * Decompiled with CFR 0.152.
 */
package proxy.socks;

import java.io.IOException;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Properties;
import proxy.ProxyConnector;
import proxy.ProxyConnectorException;
import proxy.socks.SOCKSProps;
import uiutil.ChangeListener;
import uiutil.PropertySheet;
import util.KeyBindings;
import util.Log;

public class SOCKSConnector
implements ProxyConnector {
    public static String HOSTNAME_KEY = "hostname";
    public static String PORT_KEY = "port";
    public static String VERSION_KEY = "version";
    public static String USEDNS_KEY = "dnsLookup";

    public String getProxyName() {
        return "SOCKS";
    }

    public void configure(KeyBindings keyBindings) {
        String string = keyBindings.getValueDefault(HOSTNAME_KEY, "localhost");
        String string2 = keyBindings.getValueDefault(PORT_KEY, "1080");
        Log.log((String)"SOCKS", (int)Log.INFO, (String)("socksHost = " + string));
        Log.log((String)"SOCKS", (int)Log.INFO, (String)("socksPort = " + string2));
        Properties properties = System.getProperties();
        ((Hashtable)properties).put("socksProxyHost", string);
        ((Hashtable)properties).put("socksProxyPort", string2);
    }

    public Socket makeConnection(String string, int n) throws IOException, ProxyConnectorException {
        return new Socket(string, n);
    }

    public void unconfigure(KeyBindings keyBindings) {
        Properties properties = System.getProperties();
        ((Hashtable)properties).remove("socksProxyHost");
        ((Hashtable)properties).remove("socksProxyPort");
    }

    public boolean hasPropertySheet() {
        return true;
    }

    public PropertySheet getPropertySheet(KeyBindings keyBindings, ChangeListener changeListener) {
        return new SOCKSProps(keyBindings, changeListener);
    }
}

