/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import util.JarClassLoader;

public class JarFile {
    private ZipFile zipf;
    private JarClassLoader loader;
    private String jarName;
    Vector classList;
    private String mTitle;
    private String mVersion;
    private String mDescription;
    private String mAuthor;
    private Vector beanNames = new Vector();

    public JarFile(String string) throws FileNotFoundException, IOException {
        this.loader = JarClassLoader.ourLoader;
        this.jarName = string;
        File file = new File(string);
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
    }

    public Vector getBeanNames() {
        return this.beanNames;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loader.loadClass(string);
    }

    public Enumeration getEntries() {
        try {
            if (this.zipf == null) {
                this.zipf = new ZipFile(this.jarName);
            }
            Enumeration<? extends ZipEntry> enumeration = this.zipf.entries();
            return enumeration;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public byte[] getBytes(String string) {
        try {
            if (this.zipf == null) {
                this.zipf = new ZipFile(this.jarName);
            }
            ZipEntry zipEntry = this.zipf.getEntry(string);
            InputStream inputStream = this.zipf.getInputStream(zipEntry);
            byte[] byArray = new byte[(int)zipEntry.getSize()];
            int n = 0;
            while (n < byArray.length) {
                int n2 = inputStream.read(byArray, n, byArray.length - n);
                n += n2;
            }
            return byArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public InputStream getInputStream(String string) {
        try {
            if (this.zipf == null) {
                this.zipf = new ZipFile(this.jarName);
            }
            ZipEntry zipEntry = this.zipf.getEntry(string);
            return this.zipf.getInputStream(zipEntry);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void loadManifest() {
        try {
            this.readManifest(this.getInputStream("META-INF/MANIFEST.MF"));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void readManifest(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string2 = null;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.startsWith("ModuleTitle: ")) {
                this.mTitle = string.substring(13);
                continue;
            }
            if (string.startsWith("ModuleVersion: ")) {
                this.mVersion = string.substring(15);
                continue;
            }
            if (string.startsWith("ModuleDescription: ")) {
                this.mDescription = string.substring(19);
                continue;
            }
            if (string.startsWith("ModuleAuthor: ")) {
                this.mAuthor = string.substring(14);
                continue;
            }
            if (string.startsWith("Name: ")) {
                string2 = string.substring(6);
                continue;
            }
            if (!string.equals("Java-Bean: True")) continue;
            String string3 = string2.substring(0, string2.length() - 6);
            string3 = string3.replace('/', '.');
            this.beanNames.addElement(string3);
        }
    }

    public void loadEntireJar() throws IOException {
        ZipInputStream zipInputStream = null;
        this.classList = new Vector();
        byte[] byArray = new byte[1024];
        zipInputStream = new ZipInputStream(new FileInputStream(this.jarName));
        ZipEntry zipEntry = null;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            int n;
            String string = zipEntry.getName();
            if (string.equals("META-INF/MANIFEST.MF")) {
                this.readManifest(zipInputStream);
                continue;
            }
            if (!string.endsWith(".class")) continue;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = zipInputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            String string2 = string.substring(0, string.length() - 6);
            string2 = string2.replace('/', '.');
            this.loader.setDefinition(string2, byArray2);
            this.classList.addElement(string2);
        }
        if (zipInputStream != null) {
            try {
                zipInputStream.close();
            }
            catch (Exception exception) {}
        }
        this.loader.applyDefinitions(this.classList);
    }

    public String getModuleTitle() {
        return this.mTitle;
    }

    public String getModuleVersion() {
        return this.mVersion;
    }

    public String getModuleDescription() {
        return this.mDescription;
    }

    public String getModuleAuthor() {
        return this.mAuthor;
    }
}

