/*
 * Decompiled with CFR 0.152.
 */
package snac;

import flap.FLAPSock;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import snac.DispatcherListener;
import snac.Listener;
import snac.SNACHeader;
import snac.ServiceListener;
import snac.SnacHandler;
import snac.SnacNicknameWinfo;
import snac.SnacRateClassMembers;
import snac.SnacRateParameters;
import snac.SnacTlv;
import snac.SnacVersion;
import snac.TLV;
import uiutil.ErrorMgr;
import util.Log;
import util.OutputBuffer;

public class ServiceHandler
extends SnacHandler {
    private static final String MODULE = "SNAC";

    public ServiceHandler(DispatcherListener dispatcherListener) {
        this.dispatcher = dispatcherListener;
        dispatcherListener.registerSNACHandler(1, 2, this);
    }

    public void clientOnline(FLAPSock fLAPSock, ServiceListener serviceListener, Object object, Vector vector) {
        Log.log(MODULE, Log.DB1, "writing serviceClientOnline SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < vector.size()) {
                ((SnacVersion)vector.elementAt(n)).write(outputBuffer);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, serviceListener, object, 1, 2, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceClientOnline " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeHostOnline(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got serviceHostOnline SNAC");
        ServiceListener serviceListener = (ServiceListener)listener;
        try {
            block10: {
                int n;
                int n2;
                int[] nArray;
                block9: {
                    int n3 = dataInputStream.available();
                    if (n3 > 8192) {
                        throw new IOException("read overflow");
                    }
                    if (n3 / 2 < 0) {
                        throw new IOException("read underflow");
                    }
                    nArray = new int[n3 / 2];
                    n2 = 0;
                    while (n2 < n3 / 2) {
                        nArray[n2] = dataInputStream.readUnsignedShort();
                        ++n2;
                    }
                    n = this.initHandledState();
                    if (serviceListener != null) {
                        n = this.updateHandledState(n, serviceListener.serviceHostOnline(fLAPSock, object, sNACHeader.reqID, n, nArray));
                    }
                    n2 = 0;
                    if (!true) break block9;
                    if (vector == null) return;
                    if (n2 >= vector.size()) return;
                    if (!this.proceed(n)) break block10;
                }
                do {
                    ServiceListener serviceListener2;
                    if ((serviceListener2 = (ServiceListener)vector.elementAt(n2)) != serviceListener) {
                        n = this.updateHandledState(n, serviceListener2.serviceHostOnline(fLAPSock, object, sNACHeader.reqID, n, nArray));
                    }
                    ++n2;
                    if (vector == null) return;
                    if (n2 >= vector.size()) return;
                } while (this.proceed(n));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceHostOnline " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void serviceRequest(FLAPSock fLAPSock, ServiceListener serviceListener, Object object, int n, TLV tLV) {
        Log.log(MODULE, Log.DB1, "writing serviceServiceRequest SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            outputBuffer.writeShort(n);
            int n2 = 0;
            while (n2 < tLV.size()) {
                ((SnacTlv)tLV.elementAt(n2)).write(outputBuffer);
                ++n2;
            }
            this.dispatcher.queueOutput(fLAPSock, serviceListener, object, 1, 4, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceServiceRequest " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeServiceResponse(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got serviceServiceResponse SNAC");
        ServiceListener serviceListener = (ServiceListener)listener;
        try {
            block8: {
                int n;
                int n2;
                TLV tLV;
                block7: {
                    tLV = new TLV();
                    while (dataInputStream.available() > 0) {
                        tLV.addElement(new SnacTlv(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (serviceListener != null) {
                        n2 = this.updateHandledState(n2, serviceListener.serviceServiceResponse(fLAPSock, object, sNACHeader.reqID, n2, tLV));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    ServiceListener serviceListener2;
                    if ((serviceListener2 = (ServiceListener)vector.elementAt(n)) != serviceListener) {
                        n2 = this.updateHandledState(n2, serviceListener2.serviceServiceResponse(fLAPSock, object, sNACHeader.reqID, n2, tLV));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceServiceResponse " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void rateParamsQuery(FLAPSock fLAPSock, ServiceListener serviceListener, Object object) {
        Log.log(MODULE, Log.DB1, "writing serviceRateParamsQuery SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            this.dispatcher.queueOutput(fLAPSock, serviceListener, object, 1, 6, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceRateParamsQuery " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeRateParamsReply(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got serviceRateParamsReply SNAC");
        ServiceListener serviceListener = (ServiceListener)listener;
        try {
            int n = dataInputStream.readUnsignedShort();
            Vector<SnacRateParameters> vector2 = new Vector<SnacRateParameters>();
            int n2 = 0;
            while (true) {
                if (n2 >= n || dataInputStream.available() <= 0) {
                    if (n2 >= n) break;
                    throw new IOException("read underflow");
                }
                vector2.addElement(new SnacRateParameters(dataInputStream));
                ++n2;
            }
            Vector<SnacRateClassMembers> vector3 = new Vector<SnacRateClassMembers>();
            n2 = 0;
            while (true) {
                if (n2 >= n || dataInputStream.available() <= 0) {
                    if (n2 >= n) break;
                    throw new IOException("read underflow");
                }
                vector3.addElement(new SnacRateClassMembers(dataInputStream));
                ++n2;
            }
            int n3 = this.initHandledState();
            if (serviceListener != null) {
                n3 = this.updateHandledState(n3, serviceListener.serviceRateParamsReply(fLAPSock, object, sNACHeader.reqID, n3, n, vector2, vector3));
            }
            n2 = 0;
            while (vector != null) {
                if (n2 >= vector.size()) return;
                if (!this.proceed(n3)) {
                    return;
                }
                ServiceListener serviceListener2 = (ServiceListener)vector.elementAt(n2);
                if (serviceListener2 != serviceListener) {
                    n3 = this.updateHandledState(n3, serviceListener2.serviceRateParamsReply(fLAPSock, object, sNACHeader.reqID, n3, n, vector2, vector3));
                }
                ++n2;
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceRateParamsReply " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void rateAddParamSub(FLAPSock fLAPSock, ServiceListener serviceListener, Object object, int[] nArray) {
        Log.log(MODULE, Log.DB1, "writing serviceRateAddParamSub SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            if (nArray.length * 2 < 0) {
                throw new IOException("write underflow");
            }
            if (nArray.length * 2 > 8192) {
                throw new IOException("write overflow");
            }
            int n = 0;
            while (n < nArray.length) {
                outputBuffer.writeShort(nArray[n]);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, serviceListener, object, 1, 8, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceRateAddParamSub " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void rateDelParamSub(FLAPSock fLAPSock, ServiceListener serviceListener, Object object, int[] nArray) {
        Log.log(MODULE, Log.DB1, "writing serviceRateDelParamSub SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            if (nArray.length * 2 < 0) {
                throw new IOException("write underflow");
            }
            if (nArray.length * 2 > 8192) {
                throw new IOException("write overflow");
            }
            int n = 0;
            while (n < nArray.length) {
                outputBuffer.writeShort(nArray[n]);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, serviceListener, object, 1, 9, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceRateDelParamSub " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeRateParamChange(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got serviceRateParamChange SNAC");
        ServiceListener serviceListener = (ServiceListener)listener;
        try {
            block8: {
                int n;
                int n2;
                Vector<SnacRateParameters> vector2;
                int n3;
                block7: {
                    n3 = dataInputStream.readUnsignedShort();
                    vector2 = new Vector<SnacRateParameters>();
                    while (dataInputStream.available() > 0) {
                        vector2.addElement(new SnacRateParameters(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (serviceListener != null) {
                        n2 = this.updateHandledState(n2, serviceListener.serviceRateParamChange(fLAPSock, object, sNACHeader.reqID, n2, n3, vector2));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    ServiceListener serviceListener2;
                    if ((serviceListener2 = (ServiceListener)vector.elementAt(n)) != serviceListener) {
                        n2 = this.updateHandledState(n2, serviceListener2.serviceRateParamChange(fLAPSock, object, sNACHeader.reqID, n2, n3, vector2));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceRateParamChange " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodePause(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got servicePause SNAC");
        ServiceListener serviceListener = (ServiceListener)listener;
        try {
            block10: {
                int n;
                int n2;
                int[] nArray;
                block9: {
                    int n3 = dataInputStream.available();
                    if (n3 > 8192) {
                        throw new IOException("read overflow");
                    }
                    if (n3 / 2 < 0) {
                        throw new IOException("read underflow");
                    }
                    nArray = new int[n3 / 2];
                    n2 = 0;
                    while (n2 < n3 / 2) {
                        nArray[n2] = dataInputStream.readUnsignedShort();
                        ++n2;
                    }
                    n = this.initHandledState();
                    if (serviceListener != null) {
                        n = this.updateHandledState(n, serviceListener.servicePause(fLAPSock, object, sNACHeader.reqID, n, nArray));
                    }
                    n2 = 0;
                    if (!true) break block9;
                    if (vector == null) return;
                    if (n2 >= vector.size()) return;
                    if (!this.proceed(n)) break block10;
                }
                do {
                    ServiceListener serviceListener2;
                    if ((serviceListener2 = (ServiceListener)vector.elementAt(n2)) != serviceListener) {
                        n = this.updateHandledState(n, serviceListener2.servicePause(fLAPSock, object, sNACHeader.reqID, n, nArray));
                    }
                    ++n2;
                    if (vector == null) return;
                    if (n2 >= vector.size()) return;
                } while (this.proceed(n));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in servicePause " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void pauseAck(FLAPSock fLAPSock, ServiceListener serviceListener, Object object, int[] nArray) {
        Log.log(MODULE, Log.DB1, "writing servicePauseAck SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            if (nArray.length * 2 < 0) {
                throw new IOException("write underflow");
            }
            if (nArray.length * 2 > 8192) {
                throw new IOException("write overflow");
            }
            int n = 0;
            while (n < nArray.length) {
                outputBuffer.writeShort(nArray[n]);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, serviceListener, object, 1, 12, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in servicePauseAck " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeResume(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got serviceResume SNAC");
        ServiceListener serviceListener = (ServiceListener)listener;
        try {
            block10: {
                int n;
                int n2;
                int[] nArray;
                block9: {
                    int n3 = dataInputStream.available();
                    if (n3 > 8192) {
                        throw new IOException("read overflow");
                    }
                    if (n3 / 2 < 0) {
                        throw new IOException("read underflow");
                    }
                    nArray = new int[n3 / 2];
                    n2 = 0;
                    while (n2 < n3 / 2) {
                        nArray[n2] = dataInputStream.readUnsignedShort();
                        ++n2;
                    }
                    n = this.initHandledState();
                    if (serviceListener != null) {
                        n = this.updateHandledState(n, serviceListener.serviceResume(fLAPSock, object, sNACHeader.reqID, n, nArray));
                    }
                    n2 = 0;
                    if (!true) break block9;
                    if (vector == null) return;
                    if (n2 >= vector.size()) return;
                    if (!this.proceed(n)) break block10;
                }
                do {
                    ServiceListener serviceListener2;
                    if ((serviceListener2 = (ServiceListener)vector.elementAt(n2)) != serviceListener) {
                        n = this.updateHandledState(n, serviceListener2.serviceResume(fLAPSock, object, sNACHeader.reqID, n, nArray));
                    }
                    ++n2;
                    if (vector == null) return;
                    if (n2 >= vector.size()) return;
                } while (this.proceed(n));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceResume " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void nickInfoQuery(FLAPSock fLAPSock, ServiceListener serviceListener, Object object) {
        Log.log(MODULE, Log.DB1, "writing serviceNickInfoQuery SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            this.dispatcher.queueOutput(fLAPSock, serviceListener, object, 1, 14, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceNickInfoQuery " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeNickInfoUpdate(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got serviceNickInfoUpdate SNAC");
        ServiceListener serviceListener = (ServiceListener)listener;
        try {
            SnacNicknameWinfo snacNicknameWinfo = new SnacNicknameWinfo(dataInputStream);
            int n = this.initHandledState();
            if (serviceListener != null) {
                n = this.updateHandledState(n, serviceListener.serviceNickInfoUpdate(fLAPSock, object, sNACHeader.reqID, n, snacNicknameWinfo));
            }
            int n2 = 0;
            while (vector != null) {
                if (n2 >= vector.size()) return;
                if (!this.proceed(n)) {
                    return;
                }
                ServiceListener serviceListener2 = (ServiceListener)vector.elementAt(n2);
                if (serviceListener2 != serviceListener) {
                    n = this.updateHandledState(n, serviceListener2.serviceNickInfoUpdate(fLAPSock, object, sNACHeader.reqID, n, snacNicknameWinfo));
                }
                ++n2;
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceNickInfoUpdate " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeEvilNotification(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got serviceEvilNotification SNAC");
        ServiceListener serviceListener = (ServiceListener)listener;
        try {
            block8: {
                int n;
                int n2;
                Vector<SnacNicknameWinfo> vector2;
                int n3;
                block7: {
                    n3 = dataInputStream.readUnsignedShort();
                    vector2 = new Vector<SnacNicknameWinfo>();
                    while (dataInputStream.available() > 0) {
                        vector2.addElement(new SnacNicknameWinfo(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (serviceListener != null) {
                        n2 = this.updateHandledState(n2, serviceListener.serviceEvilNotification(fLAPSock, object, sNACHeader.reqID, n2, n3, vector2));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    ServiceListener serviceListener2;
                    if ((serviceListener2 = (ServiceListener)vector.elementAt(n)) != serviceListener) {
                        n2 = this.updateHandledState(n2, serviceListener2.serviceEvilNotification(fLAPSock, object, sNACHeader.reqID, n2, n3, vector2));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceEvilNotification " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void idleNotification(FLAPSock fLAPSock, ServiceListener serviceListener, Object object, long l) {
        Log.log(MODULE, Log.DB1, "writing serviceIdleNotification SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            outputBuffer.writeInt((int)l);
            this.dispatcher.queueOutput(fLAPSock, serviceListener, object, 1, 17, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceIdleNotification " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeMigrateGroups(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got serviceMigrateGroups SNAC");
        ServiceListener serviceListener = (ServiceListener)listener;
        try {
            block10: {
                int n;
                TLV tLV;
                int n2;
                int[] nArray;
                int n3;
                block9: {
                    n3 = dataInputStream.readUnsignedShort();
                    int n4 = dataInputStream.available();
                    if (n4 / 2 < n3) {
                        throw new IOException("read underflow");
                    }
                    nArray = new int[n3];
                    n2 = 0;
                    while (n2 < n3) {
                        nArray[n2] = dataInputStream.readUnsignedShort();
                        ++n2;
                    }
                    tLV = new TLV();
                    while (dataInputStream.available() > 0) {
                        tLV.addElement(new SnacTlv(dataInputStream));
                    }
                    n = this.initHandledState();
                    if (serviceListener != null) {
                        n = this.updateHandledState(n, serviceListener.serviceMigrateGroups(fLAPSock, object, sNACHeader.reqID, n, n3, nArray, tLV));
                    }
                    n2 = 0;
                    if (!true) break block9;
                    if (vector == null) return;
                    if (n2 >= vector.size()) return;
                    if (!this.proceed(n)) break block10;
                }
                do {
                    ServiceListener serviceListener2;
                    if ((serviceListener2 = (ServiceListener)vector.elementAt(n2)) != serviceListener) {
                        n = this.updateHandledState(n, serviceListener2.serviceMigrateGroups(fLAPSock, object, sNACHeader.reqID, n, n3, nArray, tLV));
                    }
                    ++n2;
                    if (vector == null) return;
                    if (n2 >= vector.size()) return;
                } while (this.proceed(n));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceMigrateGroups " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeMotd(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got serviceMotd SNAC");
        ServiceListener serviceListener = (ServiceListener)listener;
        try {
            block8: {
                int n;
                int n2;
                TLV tLV;
                int n3;
                block7: {
                    n3 = dataInputStream.readUnsignedShort();
                    tLV = new TLV();
                    while (dataInputStream.available() > 0) {
                        tLV.addElement(new SnacTlv(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (serviceListener != null) {
                        n2 = this.updateHandledState(n2, serviceListener.serviceMotd(fLAPSock, object, sNACHeader.reqID, n2, n3, tLV));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    ServiceListener serviceListener2;
                    if ((serviceListener2 = (ServiceListener)vector.elementAt(n)) != serviceListener) {
                        n2 = this.updateHandledState(n2, serviceListener2.serviceMotd(fLAPSock, object, sNACHeader.reqID, n2, n3, tLV));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceMotd " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void setPrivacyFlags(FLAPSock fLAPSock, ServiceListener serviceListener, Object object, byte[] byArray) {
        Log.log(MODULE, Log.DB1, "writing serviceSetPrivacyFlags SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            if (byArray.length < 4) {
                throw new IOException("write underflow");
            }
            if (byArray.length > 4) {
                throw new IOException("write overflow");
            }
            outputBuffer.write(byArray, 0, byArray.length);
            this.dispatcher.queueOutput(fLAPSock, serviceListener, object, 1, 20, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceSetPrivacyFlags " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeWellKnownUrls(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got serviceWellKnownUrls SNAC");
        ServiceListener serviceListener = (ServiceListener)listener;
        try {
            block8: {
                int n;
                int n2;
                TLV tLV;
                block7: {
                    tLV = new TLV();
                    while (dataInputStream.available() > 0) {
                        tLV.addElement(new SnacTlv(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (serviceListener != null) {
                        n2 = this.updateHandledState(n2, serviceListener.serviceWellKnownUrls(fLAPSock, object, sNACHeader.reqID, n2, tLV));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    ServiceListener serviceListener2;
                    if ((serviceListener2 = (ServiceListener)vector.elementAt(n)) != serviceListener) {
                        n2 = this.updateHandledState(n2, serviceListener2.serviceWellKnownUrls(fLAPSock, object, sNACHeader.reqID, n2, tLV));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceWellKnownUrls " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void noop(FLAPSock fLAPSock, ServiceListener serviceListener, Object object) {
        Log.log(MODULE, Log.DB1, "writing serviceNoop SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            this.dispatcher.queueOutput(fLAPSock, serviceListener, object, 1, 22, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceNoop " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    private void decodeNoop(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got serviceNoop SNAC");
        ServiceListener serviceListener = (ServiceListener)listener;
        int n = this.initHandledState();
        if (serviceListener != null) {
            n = this.updateHandledState(n, serviceListener.serviceNoop(fLAPSock, object, sNACHeader.reqID, n));
        }
        int n2 = 0;
        while (vector != null && n2 < vector.size() && this.proceed(n)) {
            ServiceListener serviceListener2 = (ServiceListener)vector.elementAt(n2);
            if (serviceListener2 != serviceListener) {
                n = this.updateHandledState(n, serviceListener2.serviceNoop(fLAPSock, object, sNACHeader.reqID, n));
            }
            ++n2;
        }
    }

    public void decodeSNAC(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        if (sNACHeader.subtype == 1) {
            this.decodeSnacError(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 3) {
            this.decodeHostOnline(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 5) {
            this.decodeServiceResponse(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 7) {
            this.decodeRateParamsReply(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 10) {
            this.decodeRateParamChange(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 11) {
            this.decodePause(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 13) {
            this.decodeResume(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 15) {
            this.decodeNickInfoUpdate(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 16) {
            this.decodeEvilNotification(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 18) {
            this.decodeMigrateGroups(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 19) {
            this.decodeMotd(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 21) {
            this.decodeWellKnownUrls(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 22) {
            this.decodeNoop(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        ErrorMgr.warn("Service", " got unrecognized SNAC " + sNACHeader + " ignoring");
        fLAPSock.close("server sending bad data", 23);
    }
}

