/*
 * Decompiled with CFR 0.152.
 */
package snac;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ReqID {
    static int SERVER_BIT = Integer.MIN_VALUE;
    int id;

    public static ReqID generateClientReqID() {
        return new ReqID(false);
    }

    public static ReqID generateServerReqID() {
        return new ReqID(true);
    }

    ReqID(boolean bl) {
        this.id = (int)System.currentTimeMillis();
        if (bl) {
            this.id |= SERVER_BIT;
            return;
        }
        this.id &= ~SERVER_BIT;
    }

    ReqID(DataInputStream dataInputStream) throws IOException {
        this.id = dataInputStream.readInt();
    }

    public boolean isServerID() {
        return (this.id & SERVER_BIT) != 0;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.id);
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return "ReqID " + Integer.toHexString(this.id) + ((this.id & SERVER_BIT) == SERVER_BIT ? "S" : "C");
    }
}

