/*
 * Decompiled with CFR 0.152.
 */
package snac;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import snac.SnacConstants;

public class ChatRoomID
implements SnacConstants {
    private static final String MODULE = "SNAC";
    public int exchange;
    public int cookieLength;
    public byte[] cookie;
    public int instancenum;

    public ChatRoomID(int n, int n2, byte[] byArray, int n3) {
        this.exchange = n;
        this.cookieLength = n2;
        this.cookie = byArray;
        this.instancenum = n3;
    }

    public ChatRoomID(DataInputStream dataInputStream) throws IOException {
        this.exchange = dataInputStream.readUnsignedShort();
        this.cookieLength = dataInputStream.readUnsignedByte();
        int n = dataInputStream.available();
        if (n < this.cookieLength) {
            throw new IOException("read underflow");
        }
        this.cookie = new byte[this.cookieLength];
        if (this.cookieLength > 0) {
            dataInputStream.read(this.cookie, 0, this.cookieLength);
        }
        this.instancenum = dataInputStream.readShort();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.exchange);
        dataOutputStream.writeByte(this.cookieLength);
        if (this.cookie.length < this.cookieLength) {
            throw new IOException("write underflow");
        }
        if (this.cookie.length > this.cookieLength) {
            throw new IOException("write overflow");
        }
        dataOutputStream.write(this.cookie, 0, this.cookie.length);
        dataOutputStream.writeShort(this.instancenum);
    }
}

