/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.ChatMonitor;
import component.ChatProtoNavUI;
import component.ChatProtoNavUIListener;
import component.FolderInfo;
import component.SetupUI;
import component.Tool;
import component.Tools;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import main.ChatExchange;
import main.ChatNavAPI;
import main.ChatNavCore;
import main.ChatNavCoreAPI;
import main.ChatRoom;
import main.Nickname;
import main.Oscar;
import uiutil.ErrorMgr;
import uiutil.PropertySheet;
import util.JUtil;
import util.KeyBindings;
import util.Log;
import util.Timer;
import util.TimerListener;

public class ChatProtoNavTool
implements ActionListener,
ChatNavAPI,
Tool,
TimerListener {
    private static final String MODULE = "ChatProtoNavTool";
    private static final String MODULE_NAME = "tool.chatnav";
    private static final String[] UIPACK_NAMES = new String[]{"tool.chatnav"};
    private static final String DISPLAY_NAME = "ChatProtoNav";
    private ChatNavCoreAPI chatNavCore;
    private Hashtable requests = new Hashtable();
    private Tools tools;
    private boolean enabled;
    private MenuItem menuItem;
    private ChatProtoNavUI chatNavUI;
    private ChatMonitor chatMonitor;
    private ChatExchange[] exchanges;
    private Object[] rootRooms;
    private Hashtable queuedRequests = new Hashtable();
    private String state = "d";
    private final String DORMANT = "d";
    private final String INITIALIZING = "i";
    private final String OPERATIONAL = "o";
    private final int PROCESSING_DELAY = 1000;
    private int exchangeRequestsOutstanding;
    private final String REQUEST_CHAT_RIGHTS = "rights";
    private final String REQUEST_ROOM_CREATION = "create";
    private final String REQUEST_EXCHANGE_INFO = "exinfo";
    private final String REQUEST_ROOM_INFO = "rminfo";

    public ChatProtoNavTool(ChatNavCore chatNavCore, Tools tools) {
        Log.log(MODULE, Log.DEBUG, "registering self w/tools...");
        this.chatNavCore = chatNavCore;
        this.tools = tools;
        tools.register(this.getModuleName(), this);
        Log.log(MODULE, Log.DEBUG, "adding chat demo to People menu...");
        this.menuItem = new MenuItem("Chat Demo");
        this.menuItem.addActionListener(this);
        Oscar.mainTool.addMenuItem("People", this.menuItem);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Log.log(MODULE, Log.DEBUG, "actionPerformed: People->Chat Demo chosen.");
        Object object = actionEvent.getSource();
        if (object.equals(this.menuItem)) {
            this.initiate(null, null);
        }
    }

    public void clearRequests(Vector vector) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            this.requests.remove(vector.elementAt(n2));
            this.queuedRequests.remove(vector.elementAt(n2));
            ++n2;
        }
    }

    public Object requestChatRights(ChatProtoNavUIListener chatProtoNavUIListener) {
        Integer n = new Integer(this.getRequestId());
        String string = this.state;
        synchronized (string) {
            if (this.state == "o") {
                this.makeChatRightsRequest(n, chatProtoNavUIListener);
            } else {
                Vector<Object> vector = new Vector<Object>();
                vector.addElement(n);
                vector.addElement(chatProtoNavUIListener);
                vector.addElement("rights");
                this.queuedRequests.put(n, vector);
                if (this.state == "d") {
                    this.state = "i";
                    this.log("REQUEST: Chat nav connection (from ChatNavTool.requestChatRights)");
                    this.chatNavCore.requestConnection();
                }
            }
        }
        return n;
    }

    public Object requestExchangeInfo(ChatProtoNavUIListener chatProtoNavUIListener, int n) {
        Integer n2 = new Integer(this.getRequestId());
        String string = this.state;
        synchronized (string) {
            if (this.state == "o") {
                this.makeExchangeInfoRequest(n2, chatProtoNavUIListener, n);
            } else {
                Vector<Object> vector = new Vector<Object>();
                vector.addElement(n2);
                vector.addElement(chatProtoNavUIListener);
                vector.addElement("exinfo");
                vector.addElement(new Integer(n));
                this.queuedRequests.put(n2, vector);
                if (this.state == "d") {
                    this.state = "i";
                    this.log("REQUEST: Chat nav connection (from ChatNavTool.requestExchangeInfo)");
                    this.chatNavCore.requestConnection();
                }
            }
        }
        return n2;
    }

    public Object requestRoomCreation(ChatProtoNavUIListener chatProtoNavUIListener, ChatRoom chatRoom) {
        Integer n = new Integer(this.getRequestId());
        String string = this.state;
        synchronized (string) {
            if (this.state == "o") {
                this.makeRoomCreationRequest(n, chatProtoNavUIListener, chatRoom);
            } else {
                Vector<Object> vector = new Vector<Object>();
                vector.addElement(n);
                vector.addElement(chatProtoNavUIListener);
                vector.addElement("create");
                vector.addElement(chatRoom);
                this.queuedRequests.put(n, vector);
                if (this.state == "d") {
                    this.state = "i";
                    this.log("REQUEST: Chat nav connection (from ChatNavTool.requestRoomCreation)");
                    this.chatNavCore.requestConnection();
                }
            }
        }
        return n;
    }

    public void setChatRights(Object object, int n, ChatExchange[] chatExchangeArray) {
        ChatProtoNavUIListener chatProtoNavUIListener;
        String string = this.state;
        synchronized (string) {
            if (this.state == "i") {
                this.state = "o";
                Timer.createEvent("System", this, 0, null, 1000);
            }
        }
        this.log("REPLY: Setting chat rights (reqId " + object + ")\n" + "  maxConcurrentRooms: " + n);
        int n2 = 0;
        while (n2 < chatExchangeArray.length) {
            this.log("  Chat Rights Exchange " + n2 + ":\n" + chatExchangeArray[n2].toString("    "));
            ++n2;
        }
        if (object != null && (chatProtoNavUIListener = (ChatProtoNavUIListener)this.requests.remove(object)) != null) {
            chatProtoNavUIListener.setChatRights(object, n, chatExchangeArray);
        }
    }

    public void setExchangeInfo(Object object, ChatExchange chatExchange, ChatRoom[] chatRoomArray) {
        Log.log(MODULE, Log.DEBUG, "setExchangeInfo");
        int n = 0;
        while (this.exchanges != null && n < this.exchanges.length) {
            if (this.exchanges[n].getId() == chatExchange.getId()) {
                this.exchanges[n] = chatExchange;
            }
            ++n;
        }
        this.rootRooms[n] = chatRoomArray;
        Object object2 = this.state;
        synchronized (object2) {
            if (this.state == "i") {
                --this.exchangeRequestsOutstanding;
                if (this.exchangeRequestsOutstanding == 0) {
                    this.state = "o";
                    Timer.createEvent("System", this, 0, null, 1000);
                }
            }
        }
        if (object != null && (object2 = (ChatProtoNavUIListener)this.requests.remove(object)) != null) {
            object2.setExchangeInfo(object, chatExchange, chatRoomArray);
        }
    }

    public void setRoomInfo() {
    }

    public void setMoreRoomInfo() {
    }

    public void setOccupantList() {
    }

    public void setRoomSearchResults() {
    }

    public void roomCreated(Object object, ChatRoom chatRoom) {
        this.log("REPLY: Chat room created: (reqId " + object + ")\n" + chatRoom.toString("  "));
        ChatProtoNavUIListener chatProtoNavUIListener = (ChatProtoNavUIListener)this.requests.remove(object);
        if (chatProtoNavUIListener != null) {
            chatProtoNavUIListener.roomCreated(object, chatRoom);
            return;
        }
        ErrorMgr.warn(MODULE, "Missing reqId for room creation callback.");
    }

    public void connect() {
        this.log("connect");
    }

    public void disconnect() {
        this.log("disconnect");
        this.setEnabled(false);
        String string = this.state;
        synchronized (string) {
            this.state = "d";
            return;
        }
    }

    public void setEnabled(boolean bl) {
        this.log("setEnabled " + bl);
        this.enabled = bl;
        String string = this.state;
        synchronized (string) {
            if (this.state == "i") {
                this.log("REQUEST: Chat rights (from ChatNavTool.setEnabled)");
                this.chatNavCore.requestChatRights(null);
            }
            if (!bl) {
                this.state = "d";
            }
            return;
        }
    }

    public void service() {
    }

    public void updateRate() {
    }

    public void updateUserInfo(Nickname nickname) {
    }

    public void updateUserEvil(String string, int n) {
    }

    public int id() {
        return 1;
    }

    public int version() {
        return 1;
    }

    public FolderInfo[] configure(SetupUI setupUI) {
        return null;
    }

    public PropertySheet getPropertySheet(FolderInfo folderInfo, SetupUI setupUI) {
        return null;
    }

    public void exportProperties(KeyBindings keyBindings, KeyBindings keyBindings2) {
    }

    public void importProperties(KeyBindings keyBindings, KeyBindings keyBindings2, KeyBindings keyBindings3, boolean bl) {
    }

    public boolean initiate(Vector vector, KeyBindings keyBindings) {
        if (JUtil.isTrue(Oscar.config.getValue("debug.chatMonitor"))) {
            if (this.chatMonitor == null) {
                this.chatMonitor = new ChatMonitor(this, this.tools);
            }
            this.chatMonitor.setEnabled(true);
            this.chatMonitor.show();
        }
        return true;
    }

    public void shutdown() {
        this.log("ChatProtoNavTool got shutdown.");
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String[] getUIPackNames() {
        return UIPACK_NAMES;
    }

    private int getRequestId() {
        return (int)System.currentTimeMillis();
    }

    private void makeChatRightsRequest(Integer n, ChatProtoNavUIListener chatProtoNavUIListener) {
        this.requests.put(n, chatProtoNavUIListener);
        this.log("REQUEST: Chat rights (reqId " + n + ")");
        this.chatNavCore.requestChatRights(n);
    }

    private void makeExchangeInfoRequest(Integer n, ChatProtoNavUIListener chatProtoNavUIListener, int n2) {
        this.requests.put(n, chatProtoNavUIListener);
        this.log("REQUEST: Exchange info (reqId " + n + ")");
        this.chatNavCore.requestExchangeInfo(n, n2);
    }

    private void makeRoomCreationRequest(Integer n, ChatProtoNavUIListener chatProtoNavUIListener, ChatRoom chatRoom) {
        this.requests.put(n, chatProtoNavUIListener);
        this.log("REQUEST: Room creation (reqId " + n + ")");
        this.chatNavCore.createRoom(n, chatRoom);
    }

    private void log(String string) {
        if (this.chatMonitor != null) {
            this.chatMonitor.post(String.valueOf(string) + "\n");
        }
        Log.log(MODULE, Log.DEBUG, string);
    }

    private void warning(String string) {
        ErrorMgr.warn(MODULE, "No connection to chat navigation server! Your request for " + string + " failed.");
    }

    public void timerEvent(String string, int n, Object object) {
        Enumeration enumeration = this.queuedRequests.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            Integer n2 = (Integer)vector.firstElement();
            ChatProtoNavUIListener chatProtoNavUIListener = (ChatProtoNavUIListener)vector.elementAt(1);
            String string2 = (String)vector.elementAt(2);
            if (string2.equals("create")) {
                ChatRoom chatRoom = (ChatRoom)vector.elementAt(3);
                this.makeRoomCreationRequest(n2, chatProtoNavUIListener, chatRoom);
                continue;
            }
            if (string2.equals("rights")) {
                this.makeChatRightsRequest(n2, chatProtoNavUIListener);
                continue;
            }
            if (string2.equals("exinfo")) {
                int n3 = (Integer)vector.elementAt(3);
                this.makeExchangeInfoRequest(n2, chatProtoNavUIListener, n3);
                continue;
            }
            ErrorMgr.warn(MODULE, "Unrecognized queued request type \"" + string2 + "\". Unable to process queued request.");
        }
        this.queuedRequests.clear();
    }
}

