/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.ChatProtoGoUI;
import component.ChatProtoNavTool;
import component.Tools;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import main.ChatExchange;
import main.Oscar;
import uiutil.OFrame;
import uiutil.Spacer;

class ChatProtoCreateUI
extends OFrame
implements ActionListener,
ItemListener,
WindowListener {
    private static final String MODULE = "ChatProtoCreateUI";
    private static final String PRIVATE_EXCHANGE_TEXT = "This is the Private Chats exchange.";
    private ChatProtoNavTool chatNavTool;
    private Tools tools;
    private Choice exchangeChoice;
    private Label exchangeText;
    private ChatExchange[] exchanges;
    private Button createButton;

    public ChatProtoCreateUI(ChatProtoNavTool chatProtoNavTool, Tools tools, ChatExchange[] chatExchangeArray) {
        this.chatNavTool = chatProtoNavTool;
        this.tools = tools;
        this.exchanges = chatExchangeArray;
        this.setTitle("Chat Proto Create Your Own Chat");
        ((Component)this).setBackground(Oscar.backgroundColor);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        this.add("North", panel);
        panel.setLayout(new BorderLayout());
        panel.add("North", new Label("Chat Exchanges"));
        panel.add("West", new Spacer());
        this.exchangeChoice = new Choice();
        panel.add("Center", this.exchangeChoice);
        panel.add("East", new Spacer());
        this.exchangeChoice.add("Private Chats");
        panel = new Panel();
        this.add("Center", panel);
        this.exchangeText = new Label(PRIVATE_EXCHANGE_TEXT);
        panel.add(this.exchangeText);
        panel = new Panel();
        this.add("South", panel);
        this.createButton = new Button("Create Chat");
        panel.add(this.createButton);
        this.createButton.addActionListener(this);
        this.pack();
        this.initialize();
    }

    private void initialize() {
        int n = 0;
        while (this.exchanges != null && n < this.exchanges.length) {
            this.exchangeChoice.add(this.exchanges[n].getName());
            ++n;
        }
    }

    private void shutdown() {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.createButton)) {
            this.createAction();
        }
    }

    public void createAction() {
        ChatProtoGoUI chatProtoGoUI = new ChatProtoGoUI(this.chatNavTool, this.tools, "Create A Chat", 1, null);
        chatProtoGoUI.setEnabled(true);
        chatProtoGoUI.show();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object.equals(this.exchangeChoice)) {
            String string = this.exchangeChoice.getSelectedItem();
            int n = 0;
            while (this.exchanges != null && n < this.exchanges.length) {
                if (string.equals(this.exchanges[n].getName())) {
                    this.exchangeText.setText("This is the " + string + " exchange.");
                    return;
                }
                ++n;
            }
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.shutdown();
    }
}

