/*
 * Decompiled with CFR 0.152.
 */
package module.rendezvous.tester;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import module.rendezvous.tester.TestUI;
import module.rendezvous.tester.Tester;
import tool.icbm.RendezvousEvent;
import uiutil.ErrorMgr;
import uiutil.Spacer;

class SendPanel
extends Panel
implements ActionListener {
    private Tester tester;
    private TestUI testUI;
    private TextField nicknameField;
    private TextField serviceField;
    private TextField ipField;
    private TextField portField;
    private TextArea invitationArea;
    private Button sendButton;
    private Button cancelButton;

    public SendPanel(Tester tester, TestUI testUI, RendezvousEvent rendezvousEvent) {
        this.tester = tester;
        this.testUI = testUI;
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        this.add("North", panel);
        panel.setLayout(new BorderLayout());
        Panel panel2 = new Panel();
        panel.add("West", panel2);
        panel2.setLayout(new GridLayout(0, 1));
        panel2.add(new Label("Nickname:"));
        panel2.add(new Label("Service:"));
        panel2.add(new Label("Rendezvous IP:"));
        panel2.add(new Label("Rendezvous Port:"));
        panel2.add(new Label("Invitation:"));
        panel2 = new Panel(new GridLayout(0, 1));
        panel.add("Center", panel2);
        this.nicknameField = new TextField(16);
        panel2.add(this.nicknameField);
        this.serviceField = new TextField("09461342-4C7F-11D1-8222-444553540000");
        panel2.add(this.serviceField);
        this.ipField = new TextField(16);
        panel2.add(this.ipField);
        this.portField = new TextField(16);
        panel2.add(this.portField);
        panel2.add((Component)new Spacer());
        this.invitationArea = new TextArea(2, 40);
        this.add("Center", this.invitationArea);
        panel = new Panel();
        this.add("South", panel);
        panel.setLayout(new BorderLayout());
        panel2 = new Panel();
        panel.add("North", panel2);
        this.sendButton = new Button("Send Request");
        panel2.add(this.sendButton);
        this.sendButton.addActionListener(this);
        this.cancelButton = new Button("Cancel Request");
        panel2.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
    }

    public void setEnabled(boolean bl) {
        this.nicknameField.setEnabled(bl);
        this.serviceField.setEnabled(bl);
        this.invitationArea.setEnabled(bl);
        this.sendButton.setEnabled(bl);
        this.cancelButton.setEnabled(bl);
        if (bl) {
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.sendButton) {
            int n;
            try {
                n = new Integer(this.portField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMgr.warn((String)TestUI.MODULE, (String)"Invalid port specification");
                return;
            }
            this.tester.sendRequest(this.testUI.getCookie(), this.nicknameField.getText(), this.serviceField.getText(), this.invitationArea.getText(), this.ipField.getText(), n);
            return;
        }
        if (object == this.cancelButton) {
            this.tester.sendCancel(this.testUI.getCookie(), this.nicknameField.getText(), this.serviceField.getText());
        }
    }
}

