/*
 * Decompiled with CFR 0.152.
 */
package module.rendezvous.fileTransfer;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import module.rendezvous.fileTransfer.FileTransfer;
import module.rendezvous.fileTransfer.FtTLV;
import module.rendezvous.fileTransfer.FxferUI;
import snac.TLV;
import tool.icbm.RendezvousEvent;
import uiutil.AolRtfArea;
import uiutil.ChoiceUI;
import uiutil.MultiLineLabel;
import util.JUtil;

class ReceivePanel
extends Panel
implements ActionListener {
    FileTransfer fileTransfer;
    FxferUI fxferUI;
    String nickname;
    Button acceptButton;
    Button cancelButton;
    Button warnButton;
    Button helpButton;
    Button okButton;
    String message;
    String ipAddress;
    int port;
    byte[] ccookie;
    byte[] cookie;
    TLV params;
    AolRtfArea messageArea;
    String fileName;
    long fileSize;
    FtTLV ftTLV;

    public ReceivePanel() {
    }

    public ReceivePanel(FileTransfer fileTransfer, FxferUI fxferUI, RendezvousEvent rendezvousEvent) {
        this.fileTransfer = fileTransfer;
        this.fxferUI = fxferUI;
        int n = rendezvousEvent.getRendezvousType();
        this.cookie = rendezvousEvent.getCookie();
        this.ccookie = rendezvousEvent.getRendezvousCookie();
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        if (n == 0) {
            this.message = "<HTML>Press 'Accept' to get the file</HTML>";
            this.extractInfo(rendezvousEvent);
            Panel panel2 = new Panel(new BorderLayout());
            this.add("North", panel2);
            panel2.add("North", new Label("File: " + this.fileName));
            panel2.add("Center", new Label("Size: " + this.fileSize + " bytes"));
            panel2 = new Panel(new BorderLayout());
            this.add("Center", panel2);
            panel2.add("North", new Label("Message: "));
            this.messageArea = new AolRtfArea("messageArea", null, true, false, -1, -1);
            panel2.add("Center", (Component)this.messageArea);
            this.messageArea.setHTML(this.message);
            this.acceptButton = new Button("Accept");
            panel.add(this.acceptButton);
            this.cancelButton = new Button("Cancel");
            panel.add(this.cancelButton);
            this.warnButton = new Button("Warn");
            panel.add(this.warnButton);
            this.helpButton = new Button("Help");
            panel.add(this.helpButton);
            this.acceptButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
            this.warnButton.addActionListener(this);
            this.helpButton.addActionListener(this);
            fxferUI.frameTitle = "Request from: " + this.nickname;
        } else if (n == 2) {
            String string = "User " + rendezvousEvent.getNickname().nickname + "\nhas accepted your request to send a file.";
            this.add("Center", (Component)new MultiLineLabel(string, 0, 10));
            this.okButton = new Button("OK");
            panel.add(this.okButton);
            this.okButton.addActionListener(this);
            fxferUI.frameTitle = String.valueOf(fxferUI.frameTitle) + "Request accepted";
        } else if (n == 1) {
            String string = "User " + rendezvousEvent.getNickname().nickname + "\nhas declined your request to send a file.";
            this.add("Center", (Component)new MultiLineLabel(string, 0, 10));
            this.okButton = new Button("OK");
            panel.add(this.okButton);
            this.okButton.addActionListener(this);
            fxferUI.frameTitle = String.valueOf(fxferUI.frameTitle) + "Request declined";
        }
        this.add("South", panel);
    }

    private final void extractInfo(RendezvousEvent rendezvousEvent) {
        this.nickname = rendezvousEvent.getNickname().nickname;
        this.params = rendezvousEvent.getRendezvousParams();
        int n = 6;
        if (this.params.tlvTypePresent(n)) {
            this.message = new String(this.params.getTlvData(n));
        }
        this.message = FileTransfer.removeWheader(this.message);
        System.out.println("extractInfo: message = " + this.message);
        n = 2;
        if (this.params.tlvTypePresent(n)) {
            this.ipAddress = new String(this.params.getTlvData(n));
        } else {
            n = 4;
            if (this.params.tlvTypePresent(n)) {
                this.ipAddress = this.getQuad(JUtil.bytesToHexString((byte[])this.params.getTlvData(n)));
            } else {
                System.out.println("No IP Address found in rendezvous event");
                this.ipAddress = "127.0.0.1";
            }
        }
        n = 5;
        if (this.params.tlvTypePresent(n)) {
            this.port = this.params.getTlvDataAsU16(n);
        } else {
            System.out.println("No port info. found in rendezvous event");
            this.port = 1024;
        }
        n = 10001;
        this.ftTLV = null;
        if (this.params.tlvTypePresent(n)) {
            this.ftTLV = new FtTLV(this.params.getTlvData(n));
        } else {
            System.out.println("file info not found in rendezvous event");
        }
        int n2 = 0;
        int n3 = 0;
        if (this.ftTLV != null) {
            this.fileName = this.ftTLV.name;
            this.fileSize = this.ftTLV.totalSize;
            n2 = this.ftTLV.subtype;
            n3 = this.ftTLV.numFiles;
        } else {
            System.out.println("Cannot retrieve file information.");
        }
        System.out.println("nickname = " + this.nickname);
        System.out.println("ipAddress = " + this.ipAddress);
        System.out.println("port = " + this.port);
        System.out.println("subtype = " + n2);
        System.out.println("numFiles = " + n3);
        System.out.println("fileSize = " + this.fileSize);
        System.out.println("fileName = " + this.fileName);
        int n4 = Math.max(this.fileName.lastIndexOf(92), Math.max(this.fileName.lastIndexOf(47), this.fileName.lastIndexOf(58)));
        if (n4 == this.fileName.length() - 1) {
            this.fileName = this.fileName.substring(0, this.fileName.length() - 2);
            n4 = Math.max(this.fileName.lastIndexOf(92), Math.max(this.fileName.lastIndexOf(47), this.fileName.lastIndexOf(58)));
        }
        if (n4 >= 0) {
            try {
                this.fileName = this.fileName.substring(n4 + 1);
                return;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                this.fileName = this.fileName.substring(0, this.fileName.length() - 2);
                return;
            }
        }
    }

    private final String getQuad(String string) {
        if (string.length() != 8) {
            return "xx.xx.xx.xx";
        }
        String string2 = "";
        int n = 0;
        int n2 = 0;
        while (n < 8) {
            String string3 = string.substring(n, n + 2);
            try {
                n2 = Integer.parseInt(string3, 16);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = -1;
            }
            string2 = String.valueOf(string2) + n2;
            if ((n += 2) >= 8) continue;
            string2 = String.valueOf(string2) + ".";
        }
        return string2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof Button) {
            Button button = (Button)actionEvent.getSource();
            if (button == this.acceptButton) {
                ((Component)((Object)this.fxferUI)).setVisible(false);
                FileDialog fileDialog = new FileDialog((Frame)((Object)this.fxferUI), "Save As", 1);
                fileDialog.setFile(this.fileName);
                ((Component)fileDialog).setVisible(true);
                String string = fileDialog.getFile();
                String string2 = String.valueOf(fileDialog.getDirectory()) + string;
                if (string != null) {
                    if (string.length() < 1) {
                        string2 = String.valueOf(fileDialog.getDirectory()) + this.fileName;
                    }
                    this.fileTransfer.sendAccept(this.cookie, this.fxferUI.getCookie(), this.nickname, this.params, string2);
                } else {
                    this.fileTransfer.sendExplicitIgnore(this.fxferUI.getCookie(), this.nickname);
                }
                fileDialog.dispose();
                this.fxferUI.dispose();
                return;
            }
            if (button == this.cancelButton) {
                ((Component)((Object)this.fxferUI)).setVisible(false);
                this.fileTransfer.sendExplicitIgnore(this.fxferUI.getCookie(), this.nickname);
                this.fxferUI.dispose();
                return;
            }
            if (button == this.warnButton) {
                this.fileTransfer.sendEvil(this.nickname, true);
                return;
            }
            if (button == this.helpButton) {
                ChoiceUI.newChoiceUI((String)"Help", (String)"Press 'Accept' to accept file\nor press 'Cancel' to reject the file.");
                return;
            }
            if (button == this.okButton) {
                this.fxferUI.dispose();
            }
        }
    }
}

