/*
 * Decompiled with CFR 0.152.
 */
package module.aolim.ui;

import component.PermitProps;
import component.SLCommandHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import main.Oscar;
import module.aolim.ui.ImUI;
import module.aolim.ui.UiBean;
import tool.icbm.IcbmTool;
import uiutil.ACheckbox;
import uiutil.ChoiceUI;
import uiutil.IUtil;
import uiutil.ImagePanel;
import uiutil.MultiLineLabel;
import uiutil.OFrame;
import uiutil.SuperLayout;
import uiutil.UIPack;
import util.RefRegistry;

class ZapUI
extends OFrame
implements ActionListener {
    private static int FORMAT_WIDTH = 38;
    private UiBean uibean;
    private ImUI ui;
    private String nickname;
    private Component evilButton;
    private Component blockButton;
    private ACheckbox anonymousCheck;

    public ZapUI(UiBean uiBean, ImUI imUI, String string) {
        this.uibean = uiBean;
        this.ui = imUI;
        this.nickname = string;
        ((Frame)((Object)this)).setTitle("Zap " + string);
        ((Component)((Object)this)).setBackground(Oscar.backgroundColor);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ImagePanel imagePanel = new ImagePanel();
        ((Container)((Object)this)).add("Center", (Component)imagePanel);
        SuperLayout superLayout = new SuperLayout((Container)imagePanel, (UIPack)uiBean);
        imagePanel.setLayout((LayoutManager)superLayout);
        imagePanel.add("WarnT", (Component)new MultiLineLabel(IUtil.format((String)"Warnings are used to express disapproval of a member who contacted you (by using IM, for example). The more you warn another member, the more the system slows down for that member. Warnings wears off over time. You may choose to use an anonymous (but less powerful) warning.", (int)FORMAT_WIDTH)));
        this.anonymousCheck = new ACheckbox();
        imagePanel.add("Anonymous", (Component)this.anonymousCheck);
        String string2 = Oscar.config.getValue(String.valueOf(IcbmTool.IM_KEY) + "." + IcbmTool.ANONYMOUS_KEY);
        if (string2 != null) {
            this.anonymousCheck.setState(string2.equalsIgnoreCase("true"));
        }
        imagePanel.add("IgnoreT", (Component)new MultiLineLabel(IUtil.format((String)"When you block a member, that member can no longer contact you or see you online. Likewise, you will not be able to contact or see that member either. If you want to stop blocking a member, you may change your privacy preferences under Setup.", (int)FORMAT_WIDTH)));
        superLayout.loadLayout("zapwindow.lay");
        this.evilButton = superLayout.getLayoutComponent("Warn");
        SLCommandHandler.addActionListener((Component)this.evilButton, (ActionListener)this);
        this.blockButton = superLayout.getLayoutComponent("Ignore");
        SLCommandHandler.addActionListener((Component)this.blockButton, (ActionListener)this);
        ((Window)((Object)this)).pack();
        ((Component)((Object)this)).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        boolean bl = false;
        if (object == this.evilButton) {
            boolean bl2 = this.anonymousCheck.getState();
            this.uibean.sendEvil(this.nickname, bl2);
            if (bl2) {
                Oscar.config.setValue(String.valueOf(IcbmTool.IM_KEY) + "." + IcbmTool.ANONYMOUS_KEY, "true");
            } else {
                Oscar.config.setValue(String.valueOf(IcbmTool.IM_KEY) + "." + IcbmTool.ANONYMOUS_KEY, "false");
            }
            Oscar.saveConfiguration();
            bl = true;
            IUtil.playSound((UIPack)this.uibean, (String)"Strike");
        } else if (object == this.blockButton) {
            this.uibean.block(this.nickname);
            IUtil.playSound((UIPack)this.uibean, (String)"Ignore");
            ChoiceUI.newChoiceUI((String)("Block " + this.nickname), (String)("You have blocked " + this.nickname + "."));
            bl = true;
            Object object2 = RefRegistry.getReference((String)"component.PermitProps");
            if (object2 != null) {
                ((PermitProps)object2).setValues();
            }
        }
        if (bl) {
            this.dispose();
        }
    }

    public void removeNotify() {
        this.ui.zapRemove();
        this.ui = null;
        this.uibean = null;
        super.removeNotify();
    }

    public void setEnabled(boolean bl) {
        this.evilButton.setEnabled(bl);
        this.blockButton.setEnabled(bl);
        this.anonymousCheck.setEnabled(bl);
    }
}

