/*
 * Decompiled with CFR 0.152.
 */
package snac;

import flap.FLAPSock;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import snac.ChatHostListener;
import snac.ChatRoomDesc;
import snac.DispatcherListener;
import snac.Listener;
import snac.SNACHeader;
import snac.SnacHandler;
import snac.SnacIcbmCookie;
import snac.SnacNickname;
import snac.SnacNicknameWinfo;
import snac.SnacTlv;
import snac.TLV;
import uiutil.ErrorMgr;
import util.Log;
import util.OutputBuffer;

public class ChatHostHandler
extends SnacHandler {
    private static final String MODULE = "SNAC";

    public ChatHostHandler(DispatcherListener dispatcherListener) {
        this.dispatcher = dispatcherListener;
        dispatcherListener.registerSNACHandler(14, 1, this);
    }

    public void roomInfoUpdate(FLAPSock fLAPSock, ChatHostListener chatHostListener, Object object, ChatRoomDesc chatRoomDesc) {
        Log.log(MODULE, Log.DB1, "writing chatRoomInfoUpdate SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            chatRoomDesc.write(outputBuffer);
            this.dispatcher.queueOutput(fLAPSock, chatHostListener, object, 14, 2, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Chat", "got IOException in chatRoomInfoUpdate " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void usersJoined(FLAPSock fLAPSock, ChatHostListener chatHostListener, Object object, Vector vector) {
        Log.log(MODULE, Log.DB1, "writing chatUsersJoined SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < vector.size()) {
                ((SnacNicknameWinfo)vector.elementAt(n)).write(outputBuffer);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, chatHostListener, object, 14, 3, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Chat", "got IOException in chatUsersJoined " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void usersLeft(FLAPSock fLAPSock, ChatHostListener chatHostListener, Object object, Vector vector) {
        Log.log(MODULE, Log.DB1, "writing chatUsersLeft SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < vector.size()) {
                ((SnacNicknameWinfo)vector.elementAt(n)).write(outputBuffer);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, chatHostListener, object, 14, 4, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Chat", "got IOException in chatUsersLeft " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeChannelMsgTohost(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got chatChannelMsgTohost SNAC");
        ChatHostListener chatHostListener = (ChatHostListener)listener;
        try {
            block8: {
                int n;
                int n2;
                TLV tLV;
                int n3;
                SnacIcbmCookie snacIcbmCookie;
                block7: {
                    snacIcbmCookie = new SnacIcbmCookie(dataInputStream);
                    n3 = dataInputStream.readUnsignedShort();
                    tLV = new TLV();
                    while (dataInputStream.available() > 0) {
                        tLV.addElement(new SnacTlv(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (chatHostListener != null) {
                        n2 = this.updateHandledState(n2, chatHostListener.chatChannelMsgTohost(fLAPSock, object, sNACHeader.reqID, n2, snacIcbmCookie, n3, tLV));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    ChatHostListener chatHostListener2;
                    if ((chatHostListener2 = (ChatHostListener)vector.elementAt(n)) != chatHostListener) {
                        n2 = this.updateHandledState(n2, chatHostListener2.chatChannelMsgTohost(fLAPSock, object, sNACHeader.reqID, n2, snacIcbmCookie, n3, tLV));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Chat", "got IOException in chatChannelMsgTohost " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void channelMsgToclient(FLAPSock fLAPSock, ChatHostListener chatHostListener, Object object, SnacIcbmCookie snacIcbmCookie, int n, TLV tLV) {
        Log.log(MODULE, Log.DB1, "writing chatChannelMsgToclient SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            snacIcbmCookie.write(outputBuffer);
            outputBuffer.writeShort(n);
            int n2 = 0;
            while (n2 < tLV.size()) {
                ((SnacTlv)tLV.elementAt(n2)).write(outputBuffer);
                ++n2;
            }
            this.dispatcher.queueOutput(fLAPSock, chatHostListener, object, 14, 6, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Chat", "got IOException in chatChannelMsgToclient " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeEvilRequest(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got chatEvilRequest SNAC");
        ChatHostListener chatHostListener = (ChatHostListener)listener;
        try {
            block8: {
                int n;
                int n2;
                TLV tLV;
                int n3;
                SnacNickname snacNickname;
                int n4;
                block7: {
                    n4 = dataInputStream.readUnsignedShort();
                    snacNickname = new SnacNickname(dataInputStream);
                    n3 = dataInputStream.readUnsignedShort();
                    tLV = new TLV();
                    while (dataInputStream.available() > 0) {
                        tLV.addElement(new SnacTlv(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (chatHostListener != null) {
                        n2 = this.updateHandledState(n2, chatHostListener.chatEvilRequest(fLAPSock, object, sNACHeader.reqID, n2, n4, snacNickname, n3, tLV));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    ChatHostListener chatHostListener2;
                    if ((chatHostListener2 = (ChatHostListener)vector.elementAt(n)) != chatHostListener) {
                        n2 = this.updateHandledState(n2, chatHostListener2.chatEvilRequest(fLAPSock, object, sNACHeader.reqID, n2, n4, snacNickname, n3, tLV));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Chat", "got IOException in chatEvilRequest " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void evilReply(FLAPSock fLAPSock, ChatHostListener chatHostListener, Object object, int n, int n2) {
        Log.log(MODULE, Log.DB1, "writing chatEvilReply SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            outputBuffer.writeShort(n);
            outputBuffer.writeShort(n2);
            this.dispatcher.queueOutput(fLAPSock, chatHostListener, object, 14, 8, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Chat", "got IOException in chatEvilReply " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void clientErr(FLAPSock fLAPSock, ChatHostListener chatHostListener, Object object, SnacIcbmCookie snacIcbmCookie, int n, SnacNickname snacNickname, int n2, byte[] byArray) {
        Log.log(MODULE, Log.DB1, "writing chatClientErr SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            snacIcbmCookie.write(outputBuffer);
            outputBuffer.writeShort(n);
            snacNickname.write(outputBuffer);
            outputBuffer.writeShort(n2);
            if (byArray.length < 0) {
                throw new IOException("write underflow");
            }
            if (byArray.length > 8192) {
                throw new IOException("write overflow");
            }
            outputBuffer.write(byArray, 0, byArray.length);
            this.dispatcher.queueOutput(fLAPSock, chatHostListener, object, 14, 9, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Chat", "got IOException in chatClientErr " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeClientErr(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got chatClientErr SNAC");
        ChatHostListener chatHostListener = (ChatHostListener)listener;
        try {
            SnacIcbmCookie snacIcbmCookie = new SnacIcbmCookie(dataInputStream);
            int n = dataInputStream.readUnsignedShort();
            SnacNickname snacNickname = new SnacNickname(dataInputStream);
            int n2 = dataInputStream.readUnsignedShort();
            int n3 = dataInputStream.available();
            if (n3 > 8192) {
                throw new IOException("read overflow");
            }
            if (n3 < 0) {
                throw new IOException("read underflow");
            }
            byte[] byArray = new byte[n3];
            if (n3 > 0) {
                dataInputStream.read(byArray, 0, n3);
            }
            int n4 = this.initHandledState();
            if (chatHostListener != null) {
                n4 = this.updateHandledState(n4, chatHostListener.chatClientErr(fLAPSock, object, sNACHeader.reqID, n4, snacIcbmCookie, n, snacNickname, n2, byArray));
            }
            int n5 = 0;
            while (vector != null) {
                if (n5 >= vector.size()) return;
                if (!this.proceed(n4)) {
                    return;
                }
                ChatHostListener chatHostListener2 = (ChatHostListener)vector.elementAt(n5);
                if (chatHostListener2 != chatHostListener) {
                    n4 = this.updateHandledState(n4, chatHostListener2.chatClientErr(fLAPSock, object, sNACHeader.reqID, n4, snacIcbmCookie, n, snacNickname, n2, byArray));
                }
                ++n5;
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Chat", "got IOException in chatClientErr " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void decodeSNAC(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        if (sNACHeader.subtype == 1) {
            this.decodeSnacError(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 5) {
            this.decodeChannelMsgTohost(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 7) {
            this.decodeEvilRequest(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 9) {
            this.decodeClientErr(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        ErrorMgr.warn("Chat", " got unrecognized SNAC " + sNACHeader + " ignoring");
        fLAPSock.close("server sending bad data", 23);
    }
}

