/*
 * Decompiled with CFR 0.152.
 */
package main;

import component.FolderInfo;
import component.SetupUI;
import component.Tools;
import flap.FLAPSock;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import main.Ad;
import main.AdConstants;
import main.AdListener;
import main.CallbackData;
import main.ClientDispatcher;
import main.Nickname;
import main.Oscar;
import main.SnacConnectionHandler;
import main.UIAPI;
import snac.AdvertHandler;
import snac.AdvertListener;
import snac.ReqID;
import snac.ServiceHandler;
import snac.ServiceListener;
import snac.SnacConstants;
import snac.SnacNicknameWinfo;
import snac.SnacTlvBlock;
import snac.SnacVersion;
import snac.TLV;
import uiutil.MediaStore;
import uiutil.PropertySheet;
import uiutil.UrlViewer;
import util.KeyBindings;
import util.Log;
import util.OutputBuffer;
import util.Timer;
import util.TimerEvent;
import util.TimerListener;

public class AdCore
extends SnacConnectionHandler
implements SnacConstants,
AdConstants,
AdvertListener,
ServiceListener,
UIAPI,
TimerListener {
    private static final String MODULE = "Ad";
    public static final String MODULE_NAME = "tool.ad";
    private static final String[] UIPACK_NAMES = new String[]{"tool.ad"};
    private static final String DISPLAY_NAME = "AD";
    private static int ADCORE_VERSION = 1;
    private ClientDispatcher dispatcher;
    private FLAPSock adBall;
    private int[] families;
    private Vector familyVersions;
    private int defaultBuddyAdSpotNum = 15008000;
    private int AD_EXPIRE_EVENT = 1;
    private int AD_ROTATE_EVENT = 2;
    private int AD_UPDATE_EVENT = 3;
    TimerEvent updateEvent;
    private int AD_UPDATE_TIME = 1200000;
    private boolean needMenuAds = true;
    private Hashtable registeredSpots = new Hashtable();
    private Hashtable defaultAds;
    private Hashtable adsAvailable;
    Vector waitingAds;
    private Hashtable adsBeingViewed;

    AdCore(ClientDispatcher clientDispatcher, Tools tools) {
        this.dispatcher = clientDispatcher;
        this.adBall = null;
        clientDispatcher.registerListener(1, 2, this);
        clientDispatcher.registerListener(5, 1, this);
        this.adsAvailable = new Hashtable();
        this.defaultAds = new Hashtable();
        this.waitingAds = new Vector();
        this.adsBeingViewed = new Hashtable();
        this.loadDefaultAds();
    }

    private synchronized void loadDefaultAds() {
        this.defaultAds = new Hashtable();
        Ad ad = new Ad();
        ad.spot = this.defaultBuddyAdSpotNum;
        ad.id = 8;
        ad.image = MediaStore.getImage(null, "AIMAd.gif");
        ad.text = "default buddy ad";
        ad.url = "www.aol.com";
        this.defaultAds.put(String.valueOf(this.defaultBuddyAdSpotNum), ad);
    }

    private int[] getFamilies() {
        if (this.families == null) {
            this.families = new int[2];
            this.families[0] = 1;
            this.families[1] = 5;
        }
        return this.families;
    }

    private Vector getFamilyVersions() {
        if (this.familyVersions == null) {
            this.familyVersions = new Vector();
            this.familyVersions.addElement(new SnacVersion(1, 2, 1, Oscar.buildNumber));
            this.familyVersions.addElement(new SnacVersion(5, 1, 1, ADCORE_VERSION));
        }
        return this.familyVersions;
    }

    public void requestTimedOut(Object object) {
    }

    public boolean connectionSignOff(FLAPSock fLAPSock, TLV tLV, boolean bl) {
        return fLAPSock == this.adBall;
    }

    public boolean connectionClosed(FLAPSock fLAPSock, boolean bl, String string, int n, boolean bl2) {
        if (fLAPSock == this.adBall) {
            this.adBall = null;
            this.updateWaitingAds();
            AdCore adCore = this;
            synchronized (adCore) {
                this.updateEvent = Timer.createEvent(MODULE, this, this.AD_UPDATE_EVENT, null, this.AD_UPDATE_TIME);
            }
            return true;
        }
        return false;
    }

    private synchronized Ad fillAdRequest(int n, AdListener adListener, Ad ad) {
        Vector vector = (Vector)this.adsAvailable.get(String.valueOf(n));
        if (vector != null && vector.size() > 0) {
            Ad ad2 = this.selectAd(vector, ad);
            if (ad2 != null) {
                this.displayAd(adListener, ad2);
            }
            return ad2;
        }
        return null;
    }

    private synchronized void updateWaitingAds() {
        int n;
        Integer n2;
        AdListener adListener;
        Vector<Object> vector = new Vector<Object>();
        int n3 = 0;
        while (n3 < this.waitingAds.size()) {
            adListener = (AdListener)this.waitingAds.elementAt(n3);
            n2 = (Integer)this.waitingAds.elementAt(n3 + 1);
            n = n2;
            if (this.fillAdRequest(n, adListener, null) != null) {
                vector.addElement(adListener);
                vector.addElement(n2);
            }
            n3 += 2;
        }
        n3 = 0;
        while (n3 < vector.size()) {
            adListener = (AdListener)vector.elementAt(n3);
            n2 = (Integer)vector.elementAt(n3 + 1);
            n = n2;
            this.removeListenerWaitingForAd(n, adListener);
            n3 += 2;
        }
    }

    public int snacError(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, TLV tLV) {
        if (fLAPSock == this.adBall) {
            String string = tLV.getTlvDataAsString(4);
            int n3 = -1;
            if (tLV.tlvTypePresent(8)) {
                n3 = tLV.getTlvDataAsU16(8);
            }
            this.warn(object, this.lookup(SnacConnectionHandler.generalErrors, n2), string);
            return 1;
        }
        return 0;
    }

    public synchronized void flush() {
        Log.log("in AdCore FLUSH");
        Timer.removeEvent(this.updateEvent);
        this.needMenuAds = true;
        this.adsAvailable = new Hashtable();
        this.loadDefaultAds();
        this.waitingAds = new Vector();
        this.adsBeingViewed = new Hashtable();
    }

    private synchronized void displayAd(AdListener adListener, Ad ad) {
        Log.log("displayAd " + ad);
        adListener.displayAd(ad.spot, ad);
        Oscar.bosCore.reportEvent(2, ad.id);
        if (ad.minDisplaySecs != -1) {
            Vector<Object> vector = new Vector<Object>(2);
            vector.addElement(adListener);
            vector.addElement(ad);
            Timer.createEvent(MODULE, this, this.AD_ROTATE_EVENT, vector, ad.minDisplaySecs * 1000);
        }
        this.recordAdBeingViewed(adListener, ad);
    }

    private synchronized void recordAdBeingViewed(AdListener adListener, Ad ad) {
        Vector<AdListener> vector = (Vector<AdListener>)this.adsBeingViewed.get(ad);
        if (vector == null) {
            vector = new Vector<AdListener>();
            this.adsBeingViewed.put(ad, vector);
        }
        vector.addElement(adListener);
    }

    private synchronized boolean removeAdBeingViewed(AdListener adListener, Ad ad) {
        if (ad == null) {
            return false;
        }
        Vector vector = (Vector)this.adsBeingViewed.get(ad);
        if (vector == null) {
            return false;
        }
        return vector.removeElement(adListener);
    }

    private synchronized void addListenerWaitingForAd(int n, AdListener adListener) {
        int n2 = 0;
        while (n2 < this.waitingAds.size()) {
            Integer n3;
            AdListener adListener2 = (AdListener)this.waitingAds.elementAt(n2);
            if (adListener2 == adListener && (n3 = (Integer)this.waitingAds.elementAt(n2 + 1)) == n) {
                return;
            }
            n2 += 2;
        }
        this.waitingAds.addElement(adListener);
        this.waitingAds.addElement(new Integer(n));
    }

    private synchronized void removeListenerWaitingForAd(int n, AdListener adListener) {
        int n2 = 0;
        while (n2 < this.waitingAds.size()) {
            Integer n3;
            AdListener adListener2 = (AdListener)this.waitingAds.elementAt(n2);
            if (adListener2 == adListener && (n3 = (Integer)this.waitingAds.elementAt(n2 + 1)) == n) {
                this.waitingAds.removeElementAt(n2 + 1);
                this.waitingAds.removeElementAt(n2);
                return;
            }
            n2 += 2;
        }
    }

    private synchronized Ad selectAd(Vector vector, Ad ad) {
        Ad ad2 = null;
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        while (n2 < vector.size()) {
            Ad ad3 = (Ad)vector.elementAt(n2);
            if ((ad3 != ad || vector.size() <= 1) && ad3.timesDisplayed < n) {
                ad2 = ad3;
                n = ad3.timesDisplayed;
            }
            ++n2;
        }
        if (ad2 == null) {
            return null;
        }
        ++ad2.timesDisplayed;
        if (ad2.maxDisplayCount != -1 && ad2.timesDisplayed >= ad2.maxDisplayCount) {
            vector.removeElement(ad2);
        }
        return ad2;
    }

    private synchronized boolean isRegisteredSpot(int n) {
        Enumeration enumeration = this.registeredSpots.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            int n2 = 0;
            while (vector != null && n2 < vector.size()) {
                Integer n3 = (Integer)vector.elementAt(n2);
                if (n3 == n) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private synchronized void requestAds() {
        Object object;
        TLV tLV = new TLV(2);
        try {
            Object object2;
            object = new OutputBuffer(this.waitingAds.size() / 2);
            int n = 0;
            while (n < this.waitingAds.size()) {
                object2 = (Integer)this.waitingAds.elementAt(n + 1);
                ((DataOutputStream)object).writeInt(object2.intValue());
                n += 2;
            }
            object2 = ((OutputBuffer)object).bytes();
            if (object2 != null && ((byte[])object2).length > 0) {
                tLV.addTlv(12, (byte[])object2);
            }
        }
        catch (IOException iOException) {
            Log.log("couldn't request spots");
            this.adBall.close();
            return;
        }
        object = new CallbackData(null, true, true, 5, 2, "retrieve ads", null);
        AdvertHandler advertHandler = (AdvertHandler)this.dispatcher.getHandler(5);
        advertHandler.requestAds(this.adBall, this, object, tLV);
    }

    public int advertAds(FLAPSock fLAPSock, Object object, ReqID reqID, int n, Vector vector) {
        Log.log("advertAds " + vector.size() + " " + fLAPSock);
        AdCore adCore = this;
        synchronized (adCore) {
            long l = System.currentTimeMillis();
            int n2 = 0;
            while (n2 < vector.size()) {
                Vector<Ad> vector2;
                SnacTlvBlock snacTlvBlock = (SnacTlvBlock)vector.elementAt(n2);
                Ad ad = new Ad(snacTlvBlock.tlv, l);
                Log.log(ad.toString());
                if (ad.expireSecs != -1) {
                    Timer.createEvent(MODULE, this, this.AD_EXPIRE_EVENT, ad, ad.expireSecs * 1000);
                }
                if ((vector2 = (Vector<Ad>)this.adsAvailable.get(String.valueOf(ad.spot))) == null) {
                    vector2 = new Vector<Ad>();
                    this.adsAvailable.put(String.valueOf(ad.spot), vector2);
                }
                vector2.addElement(ad);
                ++n2;
            }
        }
        this.updateWaitingAds();
        return 1;
    }

    public void timerEvent(String string, int n, Object object) {
        Log.log("in AdCore timerEvent " + n + " callback = " + object);
        AdCore adCore = this;
        synchronized (adCore) {
            if (n == this.AD_EXPIRE_EVENT) {
                Ad ad = (Ad)object;
                ad.isGood = false;
                Vector vector = (Vector)this.adsAvailable.get(String.valueOf(ad.spot));
                if (vector != null) {
                    vector.removeElement(ad);
                }
                vector = (Vector)this.adsBeingViewed.get(ad);
                int n2 = 0;
                while (vector != null && n2 < vector.size()) {
                    AdListener adListener = (AdListener)vector.elementAt(n2);
                    this.rotateAd(adListener, ad);
                    ++n2;
                }
            } else if (n == this.AD_ROTATE_EVENT) {
                Vector vector = (Vector)object;
                AdListener adListener = (AdListener)vector.elementAt(0);
                Ad ad = (Ad)vector.elementAt(1);
                if (ad.isGood) {
                    this.rotateAd(adListener, ad);
                }
            } else if (n == this.AD_UPDATE_EVENT && this.waitingAds.size() > 0) {
                Log.log("There are " + this.waitingAds.size() + " spots waiting for ads.");
                Oscar.bosCore.requestService(this, "ad", null);
            }
            return;
        }
    }

    private synchronized void rotateAd(AdListener adListener, Ad ad) {
        Ad ad2 = this.fillAdRequest(ad.spot, adListener, ad);
        Log.log("AdCore in rotateAd new ad = " + ad2);
        if (ad2 == null) {
            this.addListenerWaitingForAd(ad.spot, adListener);
            return;
        }
        if (ad2 != ad) {
            this.removeAdBeingViewed(adListener, ad);
            return;
        }
        this.removeAdBeingViewed(adListener, ad);
    }

    private void internalError(String string) {
        this.adBall.close("ad connection dropped", 29);
        this.adBall = null;
    }

    public int serviceHostOnline(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int[] nArray) {
        if (this.adBall == null && this.compareGroups(nArray, this.getFamilies()) > 0) {
            this.adBall = fLAPSock;
            Log.log(MODULE, Log.DB0, "AdCore::serviceHostOnline()");
            ServiceHandler serviceHandler = (ServiceHandler)this.dispatcher.getHandler(1);
            serviceHandler.clientOnline(this.adBall, this, null, this.getFamilyVersions());
            this.requestAds();
            return 1;
        }
        return 0;
    }

    public int serviceServiceResponse(FLAPSock fLAPSock, Object object, ReqID reqID, int n, TLV tLV) {
        return 0;
    }

    public int serviceRateParamsReply(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, Vector vector, Vector vector2) {
        return 0;
    }

    public int serviceRateParamChange(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, Vector vector) {
        return 0;
    }

    public int servicePause(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int[] nArray) {
        return 0;
    }

    public int serviceResume(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int[] nArray) {
        return 0;
    }

    public int serviceNickInfoUpdate(FLAPSock fLAPSock, Object object, ReqID reqID, int n, SnacNicknameWinfo snacNicknameWinfo) {
        return 0;
    }

    public int serviceEvilNotification(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, Vector vector) {
        return 0;
    }

    public int serviceMigrateGroups(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, int[] nArray, TLV tLV) {
        return 0;
    }

    public int serviceMotd(FLAPSock fLAPSock, Object object, ReqID reqID, int n, int n2, TLV tLV) {
        return 0;
    }

    public int serviceWellKnownUrls(FLAPSock fLAPSock, Object object, ReqID reqID, int n, TLV tLV) {
        return 0;
    }

    public int serviceNoop(FLAPSock fLAPSock, Object object, ReqID reqID, int n) {
        return 1;
    }

    public synchronized void registerSpot(int n, int n2) {
        Vector<Integer> vector = (Vector<Integer>)this.registeredSpots.get(String.valueOf(n2));
        if (vector == null) {
            vector = new Vector<Integer>();
            this.registeredSpots.put(String.valueOf(n2), vector);
        }
        vector.addElement(new Integer(n));
    }

    public synchronized void spotAvailable(int n, AdListener adListener) {
        Log.log("spotAvailable " + n + " " + adListener);
        if (!this.isRegisteredSpot(n)) {
            return;
        }
        if (this.fillAdRequest(n, adListener, null) != null) {
            return;
        }
        Ad ad = (Ad)this.defaultAds.get(String.valueOf(n));
        if (ad != null) {
            adListener.displayAd(ad.spot, ad);
        }
        this.addListenerWaitingForAd(n, adListener);
    }

    public synchronized void spotUnavailable(int n, AdListener adListener, Ad ad) {
        Log.log("spotUnavailable " + n);
        if (!this.isRegisteredSpot(n)) {
            return;
        }
        this.removeListenerWaitingForAd(n, adListener);
        this.removeAdBeingViewed(adListener, ad);
    }

    public void adClicked(Ad ad, String string) {
        Log.log("adClicked " + ad + " " + string);
        Oscar.bosCore.reportEvent(1, ad.id);
        new UrlViewer(string);
    }

    public void updateUserInfo(Nickname nickname) {
    }

    public void updateUserEvil(String string, int n) {
    }

    public void updateRate() {
    }

    public void setEnabled(boolean bl) {
    }

    public void connect() {
    }

    public void disconnect() {
    }

    public int id() {
        return 1;
    }

    public int version() {
        return 1;
    }

    public FolderInfo[] configure(SetupUI setupUI) {
        return null;
    }

    public PropertySheet getPropertySheet(FolderInfo folderInfo, SetupUI setupUI) {
        return null;
    }

    public void exportProperties(KeyBindings keyBindings, KeyBindings keyBindings2) {
    }

    public void importProperties(KeyBindings keyBindings, KeyBindings keyBindings2, KeyBindings keyBindings3, boolean bl) {
    }

    public boolean initiate(Vector vector, KeyBindings keyBindings) {
        return true;
    }

    public void shutdown() {
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String[] getUIPackNames() {
        return UIPACK_NAMES;
    }
}

