/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.AdminTool;
import component.AdminUI;
import component.AdminUIListener;
import component.StatusFrame;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import main.Nickname;
import main.Oscar;
import uiutil.ChoiceUI;
import uiutil.IUtil;
import uiutil.ImageLabel;
import uiutil.TransparentPanel;

public class AdminNicknameUI
extends AdminUI
implements ActionListener,
AdminUIListener,
ComponentListener,
TextListener {
    private AdminTool admin;
    private TextField oldNameField;
    private TextField newNameField;
    private boolean dismiss = false;

    public AdminNicknameUI(AdminTool adminTool, String string) {
        super("Nickname", IUtil.format("This form enables you to change the appearance of your nickname by changing the capitalization and/or spacing. If you want to change the spelling of your nickname, please register a new nickname.", 60));
        this.admin = adminTool;
        TransparentPanel transparentPanel = new TransparentPanel(new GridLayout(0, 1));
        TransparentPanel transparentPanel2 = new TransparentPanel(new FlowLayout(2));
        transparentPanel.add(transparentPanel2);
        transparentPanel2.add(new ImageLabel("Current Nickname:"));
        this.oldNameField = new TextField(string, 24);
        transparentPanel2.add(this.oldNameField);
        this.oldNameField.setEditable(false);
        transparentPanel2 = new TransparentPanel(new FlowLayout(2));
        transparentPanel.add(transparentPanel2);
        transparentPanel2.add(new ImageLabel("New Nickname:"));
        if (string == null || string.equals(AdminTool.REQUESTING_STRING)) {
            string = "";
        }
        this.newNameField = new TextField(string, 24);
        transparentPanel2.add(this.newNameField);
        this.newNameField.addActionListener(this);
        this.newNameField.addComponentListener(this);
        this.newNameField.addTextListener(this);
        this.setContents(transparentPanel);
        this.show();
        this.admin.addAdminUIListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.newNameField) {
            this.requestChange(true);
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.newNameField.requestFocus();
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void setNickname(String string) {
        ((TextComponent)this.oldNameField).setText(string);
        String string2 = this.newNameField.getText();
        if (string2 == null || string2.length() == 0) {
            ((TextComponent)this.newNameField).setText(string);
            this.setChanged(false);
        }
    }

    public void setEmailAddress(String string) {
    }

    public void setRegistrationStatus(int n) {
    }

    public void error(int n, String string, String string2) {
        this.changeFailed(n, string, string2);
    }

    public void changeSuccessful(int n, Object object) {
        if (n == 0) {
            ((TextComponent)this.oldNameField).setText((String)object);
            this.setStatus(StatusFrame.STATUS_SUCCESS, "Nickname change successful.");
            IUtil.playSound(this.admin, "Save");
            this.setChanged(false);
            if (this.dismiss) {
                ((Component)this).setVisible(false);
                this.dispose();
            }
        }
    }

    public void changeFailed(int n, String string, String string2) {
        if (n == 0) {
            this.setStatus(StatusFrame.STATUS_FAILURE, "Error: " + string, string2);
            IUtil.playSound(this.admin, Oscar.ERROR_SOUND);
            this.dismiss = false;
            this.setChanged(false);
        }
    }

    public void removeNotify() {
        this.removeAll();
        if (this.admin != null) {
            this.admin.removeAdminUIListener(this);
            this.admin = null;
        }
        this.oldNameField = null;
        this.newNameField = null;
        this.setLayout(null);
        super.removeNotify();
    }

    public void requestChange(boolean bl) {
        String string = this.oldNameField.getText();
        String string2 = this.newNameField.getText();
        if (!string.equals(AdminTool.REQUESTING_STRING) && !Nickname.normalize(string).equals(Nickname.normalize(string2))) {
            ChoiceUI.newChoiceUI("Change Nickname", "The new nickname you entered is too different from your current nickname. If you want to make changes beyond capitalization and spacing, you will need to register a new nickname.", Oscar.WARNING_SOUND);
            return;
        }
        this.setStatus(StatusFrame.STATUS_WAITING, "Contacting server to change your nickname...");
        this.dismiss = bl;
        this.admin.changeNickname(string2);
    }

    public void textValueChanged(TextEvent textEvent) {
        this.setChanged(true);
    }
}

