#import <AppKit/AppKit.h>

/*
 File:       CalendarView.h

 Contains:   Header file for the custom View of the "Calendar" window

 Written by: Eric Simenel

 Created:    May 1997

 Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

 Change History (most recent first):

 You may incorporate this sample code into your applications without
 restriction, though the sample code has been provided "AS IS" and the
 responsibility for its operation is 100% yours.  However, what you are
 not permitted to do is to redistribute the source as "DSC Sample Code"
 after having made changes. If you're going to re-distribute the source,
 we require that you make it clear in the source that the code was
 descended from Apple Sample Code, but that you've made changes.
*/

@interface CalendarView : NSView
{
    NSMutableDictionary *dictionary;
    NSMutableArray *array;
    NSFont *font;
    short kind;
    short sort;
    short brand;
    short series;
    short nbSelTitles;
}

- (id)initWithFrame:(NSRect)rect;
- (void)drawRect:(NSRect)rect;
- (void)setKind:(short)value;
- (void)setSort:(short)value;
- (void)setBrand:(short)value;
- (void)setSeries:(short)value;
- (short)nbSelTitles;

@end
