/*
 File:       CalendarController.m

 Contains:   Source code for the Controller of the "Calendar" window

 Written by: Eric Simenel

 Created:    May 1997

 Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

 Change History (most recent first):

 You may incorporate this sample code into your applications without
 restriction, though the sample code has been provided "AS IS" and the
 responsibility for its operation is 100% yours.  However, what you are
 not permitted to do is to redistribute the source as "DSC Sample Code"
 after having made changes. If you're going to re-distribute the source,
 we require that you make it clear in the source that the code was
 descended from Apple Sample Code, but that you've made changes.
*/

#import "CalendarController.h"
#import "CalendarView.h"
#import "ComicsObj.h"

@implementation CalendarController

- (id)init
{
    if (self = [super init])
      {
        if (![NSBundle loadNibNamed:@"Calendar" owner:self])
          {
            NSLog(@"Unable to load Calendar.nib");
            [self release];
            return nil;
          }
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(comicsChanged:) name:ComicsDidChangeNotification object:nil];
      }
    return self;
}
- (void)comicsChanged:(NSNotification *)note
{
    [calendar display];
    [nbSelTitles setIntValue:[calendar nbSelTitles]];
}
- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self name:ComicsDidChangeNotification object:nil];
    [super dealloc];
}
- (void)awakeFromNib
{
#if debug
    NSLog(@"in CalendarController:awakeFromNib");
#endif
    [[calendar window] makeKeyAndOrderFront: nil];
    [nbSelTitles setIntValue:[calendar nbSelTitles]];
#if debug
    NSLog(@"end of CalendarController:awakeFromNib");
#endif
}

- (void)kindSelect:(id)sender
{
    [calendar setKind:[sender indexOfSelectedItem]];
    [calendar display];
    [nbSelTitles setIntValue:[calendar nbSelTitles]];
}
- (void)sortSelect:(id)sender
{
    [calendar setSort:[sender indexOfSelectedItem]];
    [calendar display];
    [nbSelTitles setIntValue:[calendar nbSelTitles]];
}
- (void)brandSelect:(id)sender
{
    [calendar setBrand:[sender indexOfSelectedItem]];
    [calendar display];
    [nbSelTitles setIntValue:[calendar nbSelTitles]];
}
- (void)seriesSelect:(id)sender
{
    [calendar setSeries:[sender indexOfSelectedItem]];
    [calendar display];
    [nbSelTitles setIntValue:[calendar nbSelTitles]];
}

@end
