/*
    File:       TransferServer.m

    Contains:   Sample server object, talked to through Distributed Objects.

    Written by: Quinn "The Eskimo!"

    Created:    Tue 10-Jun-1997

    Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

    Change History (most recent first):

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

#import "TransferServer.h"

#import "Controller.h"

// IMPORTANT: See the documentation ("ReadMe.rtf" under Supporting Files) for
// big picture information about this project.

@implementation TransferServer

+ (void)connectWithPorts:(NSArray *)portArray
    // See comments in implementation part.
{
    NSAutoreleasePool *pool;
    NSConnection *connectionToController;
    TransferServer *serverObject;

    // First we must create an autorelease pool.  Methods that we invoke
    // are going to expect to be able to do [object autorelease], but this
    // doesn't work unless we explicitly create an autorelease pool because
    // we're running in a new thread, and threads don't start off with a
    // default autorelease pool.
    
    pool = [[NSAutoreleasePool alloc] init];

    // Now we connect back to the main thread using the ports given in our
    // portArray argument.  Note the subtle difference in that we use
    // connectWithReceivePort here, whereas Controller's init method uses
    // initWithReceivePort.
    
    connectionToController = [NSConnection connectionWithReceivePort:[portArray objectAtIndex:0]
                                        sendPort:[portArray objectAtIndex:1]];

    // Now create a server object.  In this example, we only have one server
    // object to handle all requests.
    
    serverObject = [[self alloc] init];

    // Now get the proxy of the root object at the other end of the connection
    // (which was set to be the controller object in Controller's init method)
    // and send it the setServer message so that it knows about our server object.
    // Note that there is nothing magic about the method name "setServer"; it's
    // merely the name I decided to use when designing these two objects.
    
    [ ((Controller *)[connectionToController rootProxy]) setServer:serverObject];

    // We now release our server object, so the controller has the only reference
    // to it.
    
    [serverObject release];

    // Now we enter our run loop.  The run loop waits looking for events and
    // executes them.  In the case of a non-application thread, the source
    // of events is the NSConnections installed in the loop.  In our case, this
    // in the NSConnection we created earlier in this routine.  When a DO
    // message arrives on our receive port, the run loop unpackages the message
    // and executes the corresponding Objective-C method.
        
    [[NSRunLoop currentRunLoop] run];

    // Clean up.
    
    [pool release];
    [NSThread exit];

    return;
}

- (id)init
    // See comments in interface part.
{
    self = [super init];
    if (self != nil) {
        transferCount = 0;
    }
    return (self);
}

- (oneway void)slowTransfer:(Controller *)controller
    // See comments in interface part.
{
    long i;

    transferCount += 1;
    
    [controller outputString:[NSString stringWithFormat:@"Starting slowTransfer %d...\n", transferCount]];

    for (i = 0; i < 3; i++) {

        // Sleep for 1 second and then output a progress string to the controller.
        // You could substitute any other synchronous activity here, such as an
        // extended computation, or blocking I/O (file system or network).
        
        [NSThread sleepUntilDate:[NSDate dateWithTimeIntervalSinceNow:1.0]];
        [controller outputString:[NSString stringWithFormat:@"  Doing slowTransfer %d, Step=%d...\n",
                                                            transferCount , i]
            ];
    }

    [controller outputString:[NSString stringWithFormat:@"Finished slowTransfer %d...\n", transferCount]];
}

- (oneway void)slowerTransfer:(Controller *)controller
    // See comments in interface part.
{
    long i;

    transferCount += 1;
    
    [controller outputString:[NSString stringWithFormat:@"Starting slowerTransfer %d...\n", transferCount]];
    
    for (i = 0; i < 10; i++) {

        // See comment in slowTransfer:.

        [NSThread sleepUntilDate:[NSDate dateWithTimeIntervalSinceNow:1.0]];
        [controller outputString:[NSString stringWithFormat:@"  Doing slowerTransfer %d, Step=%d...\n",
                                                            transferCount , i]
            ];
    }

    [controller outputString:[NSString stringWithFormat:@"Finished slowerTransfer %d...\n", transferCount]];
}

@end
