
#import "ScoreView.h"
#import "xoxDefs.h"
#import "Actor.h"
#import "Xoxeroids.h"

@implementation ScoreView

- initWithFrame:(NSRect)frameRect
{
	[super initWithFrame:frameRect];
	[self allocateGState];		// For faster lock/unlockFocus
	[self setAutoresizesSubviews:YES];
	return self;
}

- (void)drawRect:(NSRect)rects
{
	PSsetrgbcolor(0,0,.2);
	NSRectFill(rects);
}

- oneStep
{
	int val;

	if (oldLevel != level)
	{
		[levelField setIntValue:level];
		[levelField display];
		oldLevel = level;
	}
	if (score != (val = [scenario score]))
	{
		[scoreField setIntValue:val];
		[scoreField display];
		score = val;
	}
	if (lives != (val = [scenario lives]))
	{
		[livesField setIntValue:val];
		[livesField display];
		lives = val;
	}
	return self;
}

@end
