
#import "Thinker.h"
#import "BackView.h"
#import "DisplayManager.h"
#import "CacheManager.h"
#import "ActorMgr.h"
#import "SoundMgr.h"
#import "psfuncts.h"
#import "EKProgressView.h"
#import <drivers/event_status_driver.h>
#import "xoxDefs.h"
#import "SimpleStorage.h"
#import "libc.h"


@implementation Thinker

unsigned timeInMS, lastTimeInMS, obscureTime;
float timeScale;
float maxTimeScale;
float collisionDistance;
id actorMgr, displayMgr, cacheMgr, soundMgr;
id scenario;
id mainView;
id abackView;
id gcontentView;
id gameList;
int gameIndex;
id sceneOneStepper;

BOOL pauseState;
BOOL fullScreen;
BOOL keepLooping;
BOOL obscureMouse;

NXEventHandle eventhandle;
double oldKeyThreshold;

int		BULLET1SND, 
		BULLET2SND, 
		EXP1SND, 
		EXP2SND, 
		EXP3SND, 
		SHIPSND, 
		WARPSND,
		FUTILITYSND;

static unsigned currentTimeInMs()
{
    struct timeval curTime;
    gettimeofday (&curTime, NULL);
    return (curTime.tv_sec) * 1000 + curTime.tv_usec / 1000;
}

NSZone *scenarioZone, *bundleZone;

- init
{
  [super init];
  imageNames = [[NSMutableArray alloc] init];
  imageRequestor = [[NSMutableArray alloc] init];
  soundsToCache = [[SimpleStorage allocWithZone:[self zone]]
                initCount:8
                            elementSize: sizeof(int)
                            description: @encode(int)];
  return self;
}

- (void)applicationDidFinishLaunching:(NSNotification *)notification
{
  NSZone *actorZone, *displayZone;
  id commonBundle;
  NSString *path;

  [NSClassFromString(@"SplashPanel") run];
  srandom(time(0));
  timeInMS = lastTimeInMS = currentTimeInMs();

  eventhandle = NXOpenEventStatus();
  oldKeyThreshold = NXKeyRepeatThreshold(eventhandle);
  NXSetKeyRepeatThreshold(eventhandle, 300.0);

  [self createTimer];
  mainView = abackView = backView;
  gameWindow = littleWindow;
  gcontentView = [littleWindow contentView];
  inspectorFrame = [nullInfoBox frame];

  actorZone = NSCreateZone(NSPageSize(), NSPageSize(), YES);
  displayZone = NSCreateZone(NSPageSize(), NSPageSize(), YES);
  scenarioZone = NSCreateZone(NSPageSize(), NSPageSize(), YES);
  bundleZone = NSCreateZone(NSPageSize(), NSPageSize(), YES);

  actorMgr = [[ActorMgr allocWithZone:actorZone] init];
  displayMgr = [[DisplayManager allocWithZone:displayZone] init];
  cacheMgr = [[CacheManager allocWithZone:displayZone] init];
  [self getSoundSetting];

  [self setupGameBrowser];

  path = [[NSBundle mainBundle] pathForResource:@"CommonEffects" ofType:@"XoXo"];
  commonBundle = [[NSBundle allocWithZone:bundleZone] initWithPath:path];
  [[[commonBundle classNamed:@"CommonStuff"] allocWithZone:scenarioZone] init];

  [self selectGame:nil];


  [[invisibleInfoBox window] makeKeyAndOrderFront:self];

  [littleWindow makeFirstResponder:mainView];
  [littleWindow setBackgroundColor:[NSColor blackColor]];
  [littleWindow makeKeyAndOrderFront:self];

  [self newGame:self];
}


- createTimer
{
  if (!timerValid)
    {
    timerValid = YES;
    timer = [[NSTimer scheduledTimerWithTimeInterval:0.02 target:self selector:@selector(doOneStepLoop:) userInfo:self repeats:YES] retain];
    }
  return self;
}

- removeTimer
{
  if (timerValid) {
    [timer invalidate];
    [timer release];
  }
	timerValid = NO;
	return self;
}

- doOneStepLoop:(NSTimer *)theTimer;
{
    NSEvent *dummyEvent, *pEvent;
  
	[mainView lockFocus];

	keepLooping = YES;

	do {

		[self oneStep];

		while ((dummyEvent = [NSApp nextEventMatchingMask:NSAnyEventMask untilDate:[NSDate dateWithTimeIntervalSinceNow:0] inMode:NSEventTrackingRunLoopMode dequeue:NO]))
		{
			if (([dummyEvent type] & (NSKeyDownMask|NSKeyUpMask)) && 
				(!([dummyEvent modifierFlags] & NSCommandKeyMask)))
			{
				// if it's a key event other than a command key, we save
				// ourselves the overhead of a focus change

				pEvent = [NSApp nextEventMatchingMask:NSAnyEventMask untilDate:[NSDate dateWithTimeIntervalSinceNow:0] inMode:NSEventTrackingRunLoopMode dequeue:YES];
				[NSApp sendEvent:pEvent];
			}
			else
			{
				keepLooping = NO;
				break;
			}
		}

	   } while (timerValid && keepLooping);

	[mainView unlockFocus];
	
	return self;

}

- justOneStep
{
	[mainView lockFocus];
//	[self oneStep];
	{	// new behavior to replace onestep above
		[actorMgr makeActorsPerform:@selector(erase)];
		[cacheMgr oneStep];
		[displayMgr oneStep];
	}
	[mainView unlockFocus];
	return self;
}

- oneStep
{
	float tinterval;
//  static int numFrames=0;
	lastTimeInMS = timeInMS;
	timeInMS = currentTimeInMs();
	tinterval = timeInMS - lastTimeInMS;
        
	if (obscureMouse && (timeInMS > obscureTime))
	{
		[NSCursor setHiddenUntilMouseMoves:YES];
		obscureTime = timeInMS + 5000;
	}

	if (tinterval < 1) tinterval = 1;
	timeScale = tinterval/100;
	if (timeScale > maxTimeScale) timeScale = maxTimeScale;
#if 0
        {
          float fps;
          numFrames++;
          if (numFrames == 100) {
            fps = numFrames;
            fps = numFrames/(timeInMS / 1000);
            fprintf(stderr,"%8.2f fps \r",fps);
            numFrames=0;
          }
        }
#endif
        
	[soundMgr oneStep];
	[sceneOneStepper oneStep];		// notify the scenario, if it cares
	[actorMgr oneStep];

	[cacheMgr oneStep];
	[displayMgr oneStep];

	PSWait ();	// Synchronize postscript for smoother animation
	return self;
}

// This should return a float between 0 and 1
float frandom()
{
	float val = (random() & 0x7fffffff);
	val /= 0x7fffffff;
	return val;
}

float randBetween(float a, float b)
{
	float val, scale, t;

	if (a > b)
	{	t = a; a = b; b = t;
	}
	
	scale = (b-a);
	val = scale * frandom();
	return (a + val);
}

- toggleFullScreen:sender;
{
	[self setFullScreen: !fullScreen];
	return self;
}

- setFullScreen:(BOOL)flag
{
	if (flag)
	{
		NSRect r={{0, 0}};
		if ([self bigWindowOK])
		{
			(r.size) = [[NSScreen mainScreen] frame].size;
			[self createBigWindowIfNecessary];
			tweakWindow([bigWindow windowNumber], 40);

			[self installGameViewsIntoWindow:bigWindow];

			[bigWindow setFrame:r display:NO];
			[bigWindow makeKeyAndOrderFront:self];
			[bigWindow display];
		}
		else flag = NO;
	}
	else
	{
		[bigWindow orderOut:self];
		[self installGameViewsIntoWindow:littleWindow];
		[littleWindow makeKeyAndOrderFront:self];
		[littleWindow display];
	}
	fullScreen = flag;
	return self;
}

- toggleUserPause:sender
{
	[self setPauseState: (pauseState ^ 1)];
	return self;
}

- setPauseState:(BOOL)flag
{
	if (flag) [self removeTimer];
	else [self createTimer];
	pauseState = flag;
	return self;
}

- (void)applicationDidHide:(NSNotification *)notification
{
    [self setPauseState:(pauseState | 2)];
}

- (void)applicationDidUnhide:(NSNotification *)notification
{
    [self setPauseState:(pauseState & ~2)];
}

- (void)applicationDidBecomeActive:(NSNotification *)notification
{
    [self setPauseState:(pauseState & ~4)];
	NXSetKeyRepeatThreshold(eventhandle, 300.0);
}

- (void)applicationDidResignActive:(NSNotification *)notification
{
    [self setPauseState:(pauseState | 4)];
	NXSetKeyRepeatThreshold(eventhandle, oldKeyThreshold);
}

- (void)windowDidBecomeKey:(NSNotification *)notification
{
	NSWindow *theWindow = [notification object];
    if (theWindow == littleWindow || theWindow == bigWindow)
		[self setPauseState:(pauseState & ~8)];
}

- (void)windowDidResignKey:(NSNotification *)notification
{
	NSWindow *theWindow = [notification object];
    if (theWindow == littleWindow || theWindow == bigWindow)
		[self setPauseState:(pauseState | 8)];
}

- (void)windowDidMove:(NSNotification *)notification
{
	NSWindow *theWindow = [notification object];
    if ((theWindow == littleWindow) && ([scenario respondsToSelector:@selector(windowDidMove:)]))
      [scenario windowDidMove:notification];
}

- (BOOL)applicationShouldTerminate:(id)sender
{
	NXSetKeyRepeatThreshold(eventhandle, oldKeyThreshold);
	return YES;
}

- newGame:sender
{
	[self setPauseState:(pauseState & ~1)];
	[actorMgr setGameStatus:GAME_RUNNING];
	[actorMgr requestLevel:0];
	return self;
}

// Image Loading status stuff was borrowed from Erik Kay, 
// slightly munged for xox by sam
// add an image filename to the image resource list
- addImageResource:(const char *)r for:whom
{
    //! we cheat here a bit and take advantage of the fact that a list just
    //! takes id's which are pointers, and therefore, character pointers work
    //! just fine too.  Probably not the best thing to do...
  [imageNames addObject:[NSString stringWithCString:r]];
  [imageRequestor addObject:whom];
  return self;
}

- addSoundResource:(int)sound
{
	[soundsToCache addElement:&sound];
	return self;
}

// preload resources for the app

- loadResources
{
  int i, count, progress = 0;
 NSString *str;
  id whom;
  int soundndx;

  // actually load the images
  count = [imageNames count];
  for (i = 0; i < count; i++)
    {
    str = [imageNames objectAtIndex:i];
    whom = [imageRequestor objectAtIndex:i];
    [statusText setStringValue:str];
    [statusText display];
    [whom cacheImage:str];
    // update the progress bar
    progress++;
    [progressView setProgress:progress];
    PSWait();
    }

  // convert/cache the sounds
  count = [soundsToCache count];
  for (i = 0; i < count; i++)
    {
    soundndx = *(int *)[soundsToCache elementAt:i];
    str = [soundMgr soundName:soundndx];
    if (str)
      {
      [statusText setStringValue:str];
      [statusText display];
      [soundMgr cacheSound:soundndx];
      }
    // update the progress bar
    progress++;
    [progressView setProgress:progress];
    PSWait();
    }

  [imageNames removeAllObjects];
  [imageRequestor removeAllObjects];
  [soundsToCache removeAllObjects];

  return self;
}
@end

@implementation NSMutableArray (XoxAdditions)

-(void) performInOrder:(SEL)aSelector
{
  NSEnumerator *objectEnumerator = [self objectEnumerator];
  id theObject;
  while (theObject=[objectEnumerator nextObject]) {
    [theObject performSelector:aSelector];
  }
}

@end
