
#import <AppKit/AppKit.h>
#import <SoundKit/SoundKit.h>
#import "GameList.h"

extern GameList *gameList;
extern int gameIndex;

@interface Thinker:NSObject
{
	BOOL timerValid;
    id	backView;
	NSTimer *timer;
	id scenarioBrowser;
	NSBox *invisibleInfoBox;
	id nullInfoBox;
	BOOL browserValid;
	NSRect inspectorFrame;
	id bigWindow;
	id littleWindow;
	id gameWindow;
	id progressView;

	id imageNames;
	id imageRequestor;

	id statusText;
	id soundsToCache;
	id soundButton;
}

- (void)applicationDidFinishLaunching:(NSNotification *)notification;
- createTimer;
- removeTimer;
- justOneStep;
- oneStep;
- toggleFullScreen:sender;
- setFullScreen:(BOOL)flag;
- toggleUserPause:sender;
- setPauseState:(BOOL)flag;
- newGame:sender;
- addImageResource:(const char *)r for:whom;
- addSoundResource:(int)sound;
- loadResources;

@end

@interface Thinker(thinker2)
- setupGameBrowser;
- getSoundSetting;
- (void)setSound:(Sound *)sender;
- selectGame:sender;
- installGameViewsIntoWindow:w;
- (BOOL)browser:(NSBrowser *)sender isColumnValid:(int)column;
- (void)browser:(NSBrowser *)sender createRowsForColumn:(int)column inMatrix:(NSMatrix *)matrix;
- loadGamesFrom: (NSString *) dirname;
- getScenario;
- createBigWindowIfNecessary;
- adjustLittleWindowSize;
- (BOOL)bigWindowOK;
@end

@interface NSMutableArray (XoxAdditions)
- (void)performInOrder:(SEL)aSelector;
@end

@interface NSObject (thinkerAdditions)
- (BOOL) shouldObscureCursor;
@end