#import <AppKit/AppKit.h>
#import "Thinker.h"
#import "xoxDefs.h"
#import "BackView.h"
#import "Scenario.h"
#import "ActorMgr.h"
#import "GameInfo.h"
#import "BackWindow.h"
#import "CacheManager.h"
#import "EKProgressView.h"
#import "SoundMgr.h"
#include <sys/types.h>
#include <sys/dir.h>

extern id sceneOneStepper;
extern BOOL pauseState;
extern BOOL obscureMouse;

@implementation Thinker(thinker2)

- setupGameBrowser
{
  id theMatrix;
  char buf[1024];
  const char *ptr;

  strcpy( buf, [NSHomeDirectory() cString]);
  strcat( buf, "/Library/XoxGames");

  gameList = [[GameList alloc] init];

  [self loadGamesFrom:[NSString stringWithCString:buf]];
  ptr = [[[NSUserDefaults standardUserDefaults] objectForKey:@"altGamePath"] cString];
  if (ptr) [self loadGamesFrom:[NSString stringWithCString:ptr]];

  [self loadGamesFrom: [NSString stringWithFormat:@"%@/%@",[[NSBundle mainBundle] bundlePath],@"Resources"]];

  [self loadGamesFrom: @"/LocalLibrary/XoxGames"];

  [gameList sort];

  [scenarioBrowser loadColumnZero];
  theMatrix = [scenarioBrowser matrixInColumn:0];
  [theMatrix selectCellAtRow:gameIndex column:0];
  [theMatrix scrollCellToVisibleAtRow:gameIndex column:0];

  return self;
}

- getSoundSetting
{
	NSZone *soundZone;
	const char *ptr;
	
	soundZone = NSCreateZone(NSPageSize(), NSPageSize(), YES);
	soundMgr = [[SoundMgr allocWithZone:soundZone] init];

	
	ptr = [[[NSUserDefaults standardUserDefaults] objectForKey:@"Sound"] cString];
	if (!ptr || !strcmp(ptr,"On"))
	{
		[soundMgr turnSoundOn:nil];
	}
	
	[soundButton setState:[soundMgr isSoundEnabled]];
	return self;
}

- (void)setSound:(Sound *)sender
{
	if ([soundButton state])
	{	if (![soundMgr turnSoundOn:sender]) [soundButton setState:0];
	}
	else
	{	[soundMgr turnSoundOff];
	}

	if ([soundMgr isSoundEnabled])
		[[NSUserDefaults standardUserDefaults] removeObjectForKey:@"Sound"];
	else [[NSUserDefaults standardUserDefaults] setObject:@"Off" forKey:@"Sound"];
}

- selectGame:sender
{
	// sender is the game browser, or nil if sent from within the app
	int i;
	int index = [[scenarioBrowser matrixInColumn:0] selectedRow];
	NSRect f1;
	id inspector;
	GAME_STATUS gs;
	
	if (sender && (index == gameIndex)) return self;

	[scenario scenarioDeselected];

	[cacheMgr setBackground:NO];

	gameIndex = index;

	scenario = [self getScenario];

	if (sender) [[NSUserDefaults standardUserDefaults] setObject:[gameList nameAt: index] forKey:@"whichGame"];

	gx = gy = 0;
	maxTimeScale = 1.5;
	collisionDistance = 1.25;
	if ([scenario respondsToSelector:@selector(oneStep)]) sceneOneStepper = scenario;
	else sceneOneStepper = nil;
	if ([scenario respondsToSelector:@selector(shouldObscureCursor)] && 
		![scenario shouldObscureCursor]) obscureMouse = NO;
	else obscureMouse = YES;

	[keyTimerList removeAllObjects];

	inspector = [scenario infoView];
	f1 = [inspector frame];
	[invisibleInfoBox setContentView:nullInfoBox];
	[nullInfoBox sizeTo:f1.size.width :f1.size.height byWindowCorner:3];
        [nullInfoBox retain];
	[inspector setFrame:f1];
	[invisibleInfoBox setContentView:inspector];
	[[invisibleInfoBox window] display];

	[self installGameViewsIntoWindow:littleWindow];

	if (i = [[gameList objectAtIndex:gameIndex] level]) [actorMgr requestLevel:i];
	else [actorMgr requestLevel:0];

	[self adjustLittleWindowSize];
	[scenario scenarioSelected];

	[self setPauseState: (pauseState & ~1)];
	gs = [(GameInfo *)[gameList objectAtIndex:gameIndex] status];
	if (gs == GAME_DYING || gs == GAME_DEAD)
		[self newGame:self];
	else [actorMgr setGameStatus:gs];

	[littleWindow display];
	[littleWindow makeKeyAndOrderFront:self];

	if (sender) [self justOneStep];		// yech! I should have a better way to get
										// everything set up...
	return self;
}

- installGameViewsIntoWindow:w
{
	int i;

	for (i=([[gcontentView subviews] count]-1); i>=0; i--)
	{	[[[gcontentView subviews] objectAtIndex:i] removeFromSuperview];
	}

	gameWindow = w;
	gcontentView = [w contentView];

        if ([scenario respondsToSelector:@selector(tileScenario)]) {mainView = [scenario tileScenario];}
	else
	{
		NSRect r;
		r = [gcontentView bounds];
		[abackView setFrame:r];
		[gcontentView addSubview:abackView];
		mainView = abackView;
	}

	[gameWindow makeFirstResponder:mainView];

	return self;
}


- (BOOL)browser:(NSBrowser *)sender isColumnValid:(int)column
{
	return browserValid;
}

- addCellWithString:(const char *)str at:(int)row toMatrix:matrix
{
	id theCell;
	
	[matrix insertRow:row];
	theCell = [matrix cellAtRow:row column:0];
	[theCell setStringValue:[NSString stringWithCString:str]];
	[theCell setLoaded:YES];
	[theCell setLeaf:YES];
	return self;
}

- (void)browser:(NSBrowser *)sender createRowsForColumn:(int)column inMatrix:(NSMatrix *)matrix
{
  const char *ptr;
  int i;

  // this shouldn't happen...
  if (browserValid) return ;

  for (i = 0; i < [gameList count]; i++)
    [self addCellWithString:[[[NSBundle mainBundle] localizedStringForKey:[gameList nameAt: i] value:nil table:nil] cString]
                         at:(i) toMatrix:matrix];

  ptr = [[[NSUserDefaults standardUserDefaults] objectForKey:@"whichGame"] cString];
  if (ptr)
    {
    for (i = 0; i < [gameList count]; i++)
      if (strcmp(ptr, [[gameList nameAt: i] cString]) == 0)
        {
        gameIndex = i;
        break;
        }
    }

    browserValid = YES;
}

//  Dynamically load all object files found in the specified directory
//	if we find a module in several places, we save the additional paths
//	in case they point to modules for different architectures

- loadGamesFrom: (NSString *) dirname
{
  DIR *dir;
  struct direct *de;
  char path[1024];
  char name[60];
  char *iptr;
  GameInfo *m;
  BOOL validName;


  dir = opendir([dirname cString]);
  if (dir == NULL)
    {
    return self;
    }

  while ((de = readdir(dir)) != NULL)
    {
    int i, numstrings;

    // Ignore '.'-files (not really necessary, I guess)
    if (de->d_name[0] == '.')
      continue;

    validName = NO;
    if (de->d_namlen > 4 &&
        !strcmp(&de->d_name[de->d_namlen-4], ".XoX"))
      {
      validName = YES;
      }

    if (!validName) continue;


    // check if the name matches a module already loaded
    numstrings = [gameList count];
    strcpy(name, de->d_name);

    // Smash out the '.' in "Foo.XoX"
    if (iptr = rindex(name, '.'))
      *iptr = '\0';

    for (i=0; i< numstrings; i++)
      {
      if (!strcmp(name, [[gameList nameAt:i] cString]))
        {
        // we already have a module with this name, but will save the path anyway
        validName = NO;
        sprintf(path,"%s/%s.XoX",[dirname cString],name);
        [[gameList objectAtIndex:i] appendPath:[NSString stringWithCString:path]];
        break;
        }
      }
    if (!validName) continue;

    sprintf(path,"%s/%s.XoX",[dirname cString],name);

    m = [[GameInfo alloc]
                        initWithScenario:NULL name:[NSString stringWithCString:name] path:[NSString stringWithCString:path]];
    [gameList addObject: m];
    }

  closedir(dir);

  return self;
}

extern NSZone *scenarioZone, *bundleZone;

- getScenario
{
  id progressWin = [progressView window];

  if (![gameList scenarioAt:gameIndex])
    {
    id theClass = nil;
    GameInfo *gi;
    id theScenario = nil;

    gi = [gameList objectAtIndex:gameIndex];

    if ([gi path])	// we have path but no instance, must load class
      {
      char str[80];
      [progressView setProgress:0];
      // fixme - these strings should be localizable...
      sprintf(str,"Loading %s",[[gi scenarioName] cString]);
      [[progressView window] setTitle:[NSString stringWithCString:str]];
      [statusText setStringValue:@"loading code"];
      [statusText display];
      [progressWin makeKeyAndOrderFront:self];
      PSWait();

      do
        {
          NSBundle *myBundle = [[NSBundle allocWithZone:bundleZone] initWithPath:[gi path]];

          theClass = [myBundle classNamed:[gi scenarioName]];

          if (theClass)
            {
            theScenario = [[theClass allocWithZone:scenarioZone] init];
            }
          else
            {
            [myBundle release];
            }

        } while ((!theClass) && [gi useNextPath]);

      [gi discardAltPaths];

      [[progressView setMin:0] setMax:[imageNames count] + [soundsToCache count]];
      [progressView setProgress:0];
      [self loadResources];
      [progressWin close];

      if (!theClass)
        {
        NSRunAlertPanel([[NSProcessInfo processInfo] processName], [[NSBundle mainBundle] localizedStringForKey:@"Could not load class: %@" value:nil table:nil], @"", nil, nil, [gi scenarioName]);
        }
      }
    [gi setScenario:theScenario];
    }

  return [gameList scenarioAt:gameIndex];
}

- createBigWindowIfNecessary
{
	if (!bigWindow)
	{
		NSRect r={{0, 0}};
		(r.size) = [[NSScreen mainScreen] frame].size;
// For some reason, AppKit won't let borderless windows become Key???  Temp fix is to give it a title (Yuk)
//		bigWindow = [[BackWindow allocWithZone:[self zone]] initWithContentRect:r styleMask:NSBorderlessWindowMask backing:NSBackingStoreNonretained defer:NO];
                bigWindow = [[NSWindow allocWithZone:[self zone]] initWithContentRect:r styleMask:NSTitledWindowMask backing:NSBackingStoreNonretained defer:NO];

		[bigWindow setBackgroundColor:[NSColor blackColor]];
		[bigWindow setDelegate:self];
	}

	return self;
}

// delegate method invoked by window
- (NSSize)windowWillResize:(NSWindow *)sender toSize:(NSSize)frameSize
{
  NSRect frm = {{0,0},{0,0}};
    NSRect cnt = {{0,0},{0,0}};

	if (![scenario respondsToSelector:@selector(newWindowContentSize:)])
		return frameSize;

	frm.size = frameSize;
	cnt = [NSWindow contentRectForFrameRect:frm styleMask:[sender styleMask]];
	if ([scenario newWindowContentSize:&(cnt.size)])
	{
		frm = [NSWindow frameRectForContentRect:cnt styleMask:[sender styleMask]];
		frameSize = frm.size;
	}
	return frameSize;
}

- adjustLittleWindowSize
{
	NSRect contRect;

	if (![scenario respondsToSelector:@selector(newWindowContentSize:)])
		return self;

	contRect = [[littleWindow contentView] bounds];
	if ([scenario newWindowContentSize:&contRect.size])
	{
		[[littleWindow contentView] sizeTo:contRect.size.width 
			:contRect.size.height byWindowCorner:3];
	}
	return self;
}

- (BOOL)bigWindowOK
{
  NSSize screenSize;

  if (![scenario respondsToSelector:@selector(newWindowContentSize:forFullScreen:)])
    return YES;

  screenSize = [[NSScreen mainScreen] frame].size;
  return (![scenario newWindowContentSize:&screenSize forFullScreen:YES]);
}


@end












