#import <AppKit/AppKit.h>
#import <Foundation/NSObject.h>
#import <SoundKit/SoundKit.h>
#import "xoxDefs.h"


#define MAX_STREAMS 8

@interface SoundMgr:NSObject
{
	int currentStream;
	NXSoundOut *device;
	NXPlayStream *streamList[MAX_STREAMS];
	SimpleStorage *soundList;
	BOOL glSoundEnabled;
        SimpleStorage *currentSounds;		// sounds played this iteration
}

- oneStep;
- (int) addSound:(NSString *)name sender:whom;
- (int) addSound:(NSString *)name sender:whom cache:(BOOL)cacheit;
- cacheSound:(int)whichSound;
- (NSString *)soundName:(int)whichSound;
- playSound: (int)whichSound at: (float)mix;
- (void)dealloc;
- (BOOL)turnSoundOn:sender;
- turnSoundOff;
- (BOOL)isSoundEnabled;

@end
