
// local headers
#import "Shoot.h"
#import "../CommonEffects.bproj/Explosion.h"
#import "PlayerGun.h"
#import "PlayerBullet.h"
#import "SBrick.h"
#import "SCloud.h"
#import "../CommonEffects.bproj/GOLetter.h"
#import "SoundMgr.h"

// XoX headers
#import "BackView.h"
#import "ActorMgr.h"
#import "CacheManager.h"
#import "xoxDefs.h"
#import "Thinker.h"

int SHOOTSND;

@implementation Shoot

// invoked only by the actor manager
- _createLevel:(int)lev
{
    int i;
    
    player1 = 
	    [actorMgr newActor:(int)[PlayerGun class] for:self tag:EVIL];
    player2 = 
	    [actorMgr newActor:(int)[PlayerGun class] for:self tag:GOOD];

    currentPlayer = player1;

    if ([actorMgr gameStatus] == GAME_DYING)
        [[mainView window] setTitle:@"Shoot! - Game Over"];
    else
        [[mainView window] setTitle:@"Shoot!"];
    
    shootOff = YES;
    //shootOff = NO;
    windSpeed = randBetween(-10,10);
    startPow1 = startPow2 = -1;
     
    for (i=3; i>=0; i--)
    	[actorMgr newActor:(int)[SCloud class] for:self tag:i];

    [actorMgr newActor:(int)[SBrick class] for:self tag:0];

    [NSObject cancelPreviousPerformRequestsWithTarget:self selector:@selector(updatePower) object:nil];
    [self performSelector:@selector(updatePower) withObject:nil afterDelay:(0.3) / 1000.0];
	
    [pow1 setFloatValue:0.0];
    [pow2 setFloatValue:0.0];
    if (lev == 1) {
	[score1 setIntValue:0];
	[score2 setIntValue:0];
    }

    // this is kind of a hack.  if the game is over and the window is resized,
    // we want _createLevel to be called so that it will create a new level
    // that makes sense for the size of the screen.  However, there's no way
    // to do that and to keep the game over text on the screen.  In addition,
    // there's no way to grab the game over letters and just drop them back on
    // the screen after the actor manager has removed them.  Oh, well.
    // So the solution is to restart the game over animation on resize.
    if ([actorMgr gameStatus] == GAME_DYING)
        [GOLetter gameOver:self];

    return self;
}

- updatePower
{
    int val;
    
    if (startPow1 != -1) {
	val = (timeInMS - startPow1);
	[pow1 setIntValue:val];
    }
    if (startPow2 != -1) {
	val = (timeInMS - startPow2);
	[pow2 setIntValue:val];
    }
    [NSObject cancelPreviousPerformRequestsWithTarget:self selector:@selector(updatePower) object:nil];
    [self performSelector:@selector(updatePower) withObject:nil afterDelay:(0.3) / 1000.0];
    return self;
}

- (float)windSpeed
{
    return windSpeed;
}

- currentPlayer
{
    return currentPlayer;
}

- infoView
{
    return infoView;
}

- didActivate:(Actor *)theActor
{
    if ([theActor isKindOfClass:[Explosion class]]) {
	[soundMgr playSound:EXP3SND at:0.5];
    }
    return self;
}

- didRetire:(Actor *)theActor
{
    if ([theActor isKindOfClass:[PlayerBullet class]]) {
	currentPlayer = ((lastPlayer == player1) ? player2 : player1);
    } else if ([theActor isKindOfClass:[Explosion class]]) {
	if ([score1 intValue] >= 10 || [score2 intValue] >= 10) {
            if ([actorMgr gameStatus] != GAME_DYING) {
		[GOLetter gameOver:self];
                [[mainView window] setTitle:@"Shoot! - Game Over"];
            }
	    [actorMgr setGameStatus: GAME_DYING];
	}
	if ([actorMgr gameStatus] != GAME_DYING)
	    [actorMgr requestLevel:2];
    } else if ([theActor isKindOfClass:[PlayerGun class]]) {
	if (theActor->alliance == GOOD) {
	    [score1 setIntValue:[score1 intValue]+1];
	} else {
	    [score2 setIntValue:[score2 intValue]+1];
	}
    }
    return self;
}

- (void)keyDown:(NSEvent *)theEvent 
{
NSString *theKeys = [theEvent characters];
char keyBuf[2];

[theKeys getCString:keyBuf maxLength:1];
if ([theEvent isARepeat] > 0) return;

switch(*keyBuf)
    {
	case ',':		// move left
	    if (!shootOff && (currentPlayer != player1))
		break;
	    [leftVal1 keyDownAt:[theEvent timestamp]];
	    break;
	case '2':		// move left
	    if (!shootOff && (currentPlayer != player2))
		break;
	    [leftVal2 keyDownAt:[theEvent timestamp]];
	    break;
	case '.':		// move right
	    if (!shootOff && (currentPlayer != player1))
		break;
	    [rightVal1 keyDownAt:[theEvent timestamp]];
	    break;
	case '3':		// move right
	    if (!shootOff && (currentPlayer != player2))
		break;
	    [rightVal2 keyDownAt:[theEvent timestamp]];
	    break;
	case ' ':		// fire
	    if (!shootOff && (currentPlayer != player1))
		break;
	    [shootVal1 keyDownAt:[theEvent timestamp]];
	    startPow1 = timeInMS;
	    break;
	case '0':		// fire
	    if (!shootOff && (currentPlayer != player2))
		break;
	    [shootVal2 keyDownAt:[theEvent timestamp]];
	    startPow2 = timeInMS;
	    break;
    }
}

- (void)keyUp:(NSEvent *)theEvent 
{
NSString *theKeys = [theEvent characters];
char keyBuf[2];

[theKeys getCString:keyBuf maxLength:1];
if ([theEvent isARepeat] > 0) return;

switch(*keyBuf)
    {
	case ',':		// move left
	    if (!shootOff && (currentPlayer != player1))
		break;
	    [leftVal1 keyUpAt:[theEvent timestamp]];
	    break;
	case '2':		// move left
	    if (!shootOff && (currentPlayer != player2))
		break;
	    [leftVal2 keyUpAt:[theEvent timestamp]];
	    break;
	case '.':		// move right
	    if (!shootOff && (currentPlayer != player1))
		break;
	    [rightVal1 keyUpAt:[theEvent timestamp]];
	    break;
	case '3':		// move right
	    if (!shootOff && (currentPlayer != player2))
		break;
	    [rightVal2 keyUpAt:[theEvent timestamp]];
	    break;
	case ' ':		// fire
	    if (!shootOff && (currentPlayer != player1))
		break;
	    [shootVal1 keyUpAt:[theEvent timestamp]];
	    [player1 fire:[shootVal1 val]*4];
	    lastPlayer = currentPlayer;
	    currentPlayer = nil;
	    [shootVal1 postOneStep];
	    startPow1 = -1;
	    break;
	case '0':		// fire
	    if (!shootOff && (currentPlayer != player2))
		break;
	    [shootVal2 keyUpAt:[theEvent timestamp]];
	    [player2 fire:[shootVal2 val]*4];
	    lastPlayer = currentPlayer;
	    currentPlayer = nil;
	    [shootVal2 postOneStep];
	    startPow2 = -1;
	    break;
    }
}

- scenarioSelected
{
    [keyTimerList addObject:leftVal1];
    [keyTimerList addObject:rightVal1];
    [keyTimerList addObject:leftVal2];
    [keyTimerList addObject:rightVal2];
    return self; 
}

- scenarioDeselected
{	
    [[gcontentView window] setBackgroundColor:[NSColor blackColor]];
    return self; 
}

- init
{
  NSString *path;
    [super init];

    if (path = [[NSBundle bundleForClass:[self class]] pathForResource:@"shoot" ofType:@"nib"])
    {
	[NSBundle loadNibFile:path externalNameTable:[NSDictionary dictionaryWithObjectsAndKeys:self, @"NSOwner", nil] withZone:[self zone]];
    }

    leftVal1 = [[KeyTimer allocWithZone:[self zone]] init];
    rightVal1 = [[KeyTimer allocWithZone:[self zone]] init];
    leftVal2 = [[KeyTimer allocWithZone:[self zone]] init];
    rightVal2 = [[KeyTimer allocWithZone:[self zone]] init];
    shootVal1 = [[KeyTimer allocWithZone:[self zone]] init];
    shootVal2 = [[KeyTimer allocWithZone:[self zone]] init];
    [leftVal1 setDelegate:rightVal1];
    [rightVal1 setDelegate:leftVal1];
    [leftVal2 setDelegate:rightVal2];
    [rightVal2 setDelegate:leftVal2];

    SHOOTSND = [soundMgr addSound:@"35" sender:self];
    [[NSApp delegate] addImageResource:"explosionM" for:[Explosion class]];
    [[NSApp delegate] addSoundResource:EXP3SND];
    [[NSApp delegate] addSoundResource:SHOOTSND];
    [[NSApp delegate] addSoundResource:FUTILITYSND];

    return self;
}

- (COLLISION_PARADIGM)collisionParadigm
{
    return GOOD_V_EVIL;
}

- newSize:(NSSize)s
{
    NSRect r, r2;
    r = [pow2 frame];
    [pow2 setFrameOrigin:NSMakePoint((s.width - r.size.width - 10), 10)];

    r2 = [pow1 frame];
    [score1 setFrameOrigin:NSMakePoint(NSMaxX(r2) + 10, 10)];
    r2 = [pow2 frame];
    r = [score2 frame];
    [score2 setFrameOrigin:NSMakePoint((NSMinX(r2) - NSWidth(r) - 10), 10)];

    [actorMgr requestLevel:2];

    return self;
}

- (void)tile
{
    NSRect r, r2;

    [[gcontentView window] setBackgroundColor:[NSColor lightGrayColor]];
    r = [gcontentView bounds];
    r.size.height -= 40;
    r.origin.y += 40;
    [abackView setFrame:r];
    r = [gcontentView bounds];
    r.size.height = 40;
    [scoreView setFrame:r];
    [gcontentView addSubview:abackView];
    [gcontentView addSubview:scoreView];
    [gcontentView addSubview:pow1];
    [gcontentView addSubview:pow2];
    [gcontentView addSubview:score1];
    [gcontentView addSubview:score2];
    [pow1 setFrameOrigin:NSMakePoint(10, 10)];
    r2 = [pow2 frame];
    [pow2 setFrameOrigin:NSMakePoint((NSWidth(r) - NSWidth(r2) - 10), 10)];

    r2 = [pow1 frame];
    [score1 setFrameOrigin:NSMakePoint(NSMaxX(r2) + 10, 10)];
    r2 = [pow2 frame];
    r = [score2 frame];
    [score2 setFrameOrigin:NSMakePoint((NSMinX(r2) - NSWidth(r) - 10), 10)];
}

- (float)rotValFor:(int)who
{
    float rot = 0;
    if (who) {
	if (shootOff || (currentPlayer == player1))
	    rot = [leftVal1 val] - [rightVal1 val];
    } else {
	if (shootOff || (currentPlayer == player2))
	    rot = [leftVal2 val] - [rightVal2 val];
    }
    return rot;
}

@end
