/*  
 * 
 * KaBLAM.m	-- A fast action, bomb dropping, bomb catching game.  This is the
 *             "controller" object.  It handles user preferences from the Xox
 *             panel.  It is responsible for the introduction screen, the demo,
 *             and creating the key actors.  Keyboard events are also caught
 *             and dispatched from here.
 * 
 * 
 * You may freely copy, distribute, and reuse the code in this example.
 * The author disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 *
 * Written by Mark G. Tacchi, mtacchi@next.com
 *
 * Wed Jul 27 1994
 */

#import <AppKit/AppKit.h>
#import "Scenario.h"

@interface KaBLAM:NSObject <Scenario>
{
	id	player, bomber, infoBomberHand;
	id	scoreView;
	id	scoreCell;
	id	highScoreCell;
	id	uselessView;
	id  KB_themeSongSnd;
	id	mouseSensitivitySlider;
	id 	playerInputMatrix;
	int badGuyCount;
	int playerCount;
	int nextLevel;
	
	id infoView;
	
	unsigned scoreTime;
	int score, highScore;
	int oldScore;
	int lives;
	int oldLives;
	int nextBonus;
	int oldBonus;
	BOOL		pauseForNextLevel;
	BOOL		gameOver;
	BOOL		mouseAsInput;
	BOOL		demoMode;
	float 		mouseSensitivity;
	
}

- createPlayer;
- gotoLevel:sender;
- (int) lives;
- (float) lowestBombLocation;	//used in demo mode so pails know where to head.
- adjustSettings:sender;
- (int) level;

//score accessors
- addScore: (int) moreScore;
- setScore: (int) newScore;
- (int) score;

- setPauseForNextLevel: (BOOL) pause;
- (BOOL) pauseForNextLevel;

- loseLife;

//from the control panel
- setMouseSensitivity: sender;
- (float) mouseSensitivity;
- setPlayerInput: sender;
- (BOOL) playerInput;

- (BOOL) demoMode;
- setDemoMode: (BOOL) mode;

@end
