/*  
 * 
 * KB_Player.m	-- An actor for the player's pails.
 * 
 * 
 * You may freely copy, distribute, and reuse the code in this example.
 * The author disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 *
 * Written by Mark G. Tacchi, mtacchi@next.com
 *
 * Wed Jul 27 1994
 */

#import "ActorMgr.h"
#import "KB_Player.h"
#import "KaBLAMDefs.h"
#import "KaBLAM.h"
#import "SoundMgr.h"
#import "Actor.h"

#define ACCEL			45.0
#define ROT_SPEED		37.0

#define PAIL_WIDTH		56
#define PAIL_HEIGHT		19

#define PAIL_HALF_WIDTH		28
#define PAIL_HALF_HEIGHT	9.5

#define MOVE_GRAN		3
#define DEMO_ACCEL			450.0
#define DEMO_THEME_DURATION 53000

@implementation KB_Player
- activate:sender :(int)numPails
{
	NSSize tsize = {PAIL_WIDTH, PAIL_HEIGHT};
	NSSize tsizeByTwo = {PAIL_HALF_WIDTH, PAIL_HALF_HEIGHT};
	
    tsize.height*= numPails;
    tsizeByTwo.height*= numPails;
	
	[super activate:sender :numPails];
	[self reinitWithImage:@"kb_pail"
		frameSize:&tsize
		numFrames:1
		shape: RECT
		alliance: GOOD
		radius: 10.0
		buffered: YES
		x: 0.0
		y: -(KB_SCREENHEIGHT/2.0) + tsizeByTwo.height
		theta: 0.0
		vel: 0.0
		interval: 50
		distToCorner: &tsizeByTwo];

	xv= yv= 0;
	rotation= STRAIGHT;
	demoMode= [(KaBLAM *)scoreTaker demoMode];
	//KB_Player is delegate
	if (demoMode) demoModeExpireTime= timeInMS + DEMO_THEME_DURATION;  
	
	[self setMouseAsInput: [(KaBLAM *)scoreTaker playerInput]];
	[self setMouseScale: [(KaBLAM *)scoreTaker mouseSensitivity]];
	
	[[[Sound alloc] initFromSection:@"kb_kablamThemeSong.snd"] play];
    return self;
} /*activate::*/



//this really just changes the framesize so that the other pails are shown.
//(used for extra player bonus)
- setNumPails: (int)numPails
{
  float		newHeight= PAIL_HEIGHT*numPails;
  float		newHalfHeight= PAIL_HALF_HEIGHT*numPails;
  
  frameSize.height= newHeight;
  distToCorner.height= newHalfHeight;
  drawRect.size.height = newHeight;
  collisionRect.size.height = newHeight;
  [self setFrameOrigin:NSMakePoint(x, -(KB_SCREENHEIGHT/2.0) + PAIL_HALF_HEIGHT*numPails)];
  
  return self; 
} /*setNumPails:*/



- positionChanged
{
  if (demoMode)
    if (timeInMS>demoModeExpireTime) [actorMgr requestLevel: 0];
	
  if (!mouseAsInput || demoMode) {
    if (rotation == LEFT) {
      theta += timeScale * (ROT_SPEED * PI / 180.0);
    }
    else if (rotation == RIGHT) {
      theta -= timeScale * (ROT_SPEED * PI / 180.0);
    }

    if (theta<0) theta+= timeScale * PI/24.;
    else if (theta>0) theta-= timeScale * PI/24.;

    if (theta<-PI/5) theta= -PI/9;
    else if (theta> PI/5) theta= PI/9;
  }
  
  [super positionChanged];
  return self;
} /*positionChanged*/




- calcDxDy:(NSPoint *)dp
{
  
  if (!mouseAsInput || demoMode) {			//keyboard as input
    if (x>(KB_SCREENWIDTH/2.0- frameSize.width/2.0)) {
	  xv= 0;
      theta= -theta;
	  [self setFrameOrigin:NSMakePoint(KB_SCREENWIDTH/2.0- frameSize.width/2.0 - 1, y)];
    }
    else if (x<(-KB_SCREENWIDTH/2.0+ frameSize.width/2.0)) {
      xv= 0;
      theta= -theta;
	  [self setFrameOrigin:NSMakePoint(-KB_SCREENWIDTH/2.0+ frameSize.width/2.0 + 1, y)];
    }
    else {
      if (demoMode) {
	    float  lowestBombLocation= [(KaBLAM *)scoreTaker lowestBombLocation];
       
	    if (lowestBombLocation<x && rotation!=LEFT) [self moveLeft];
	    else if (lowestBombLocation>x && rotation!=RIGHT) [self moveRight];
		else if (fabs(lowestBombLocation-x)<MOVE_GRAN) [self moveStop];
		
        xv += DEMO_ACCEL * timeScale * -sin(theta);
        dp->x = timeScale * xv;
	  }
	  else {
        xv += ACCEL * timeScale * -sin(theta);
        dp->x = timeScale * xv;
	  }
    }
  }
  else {			//mouse as input
    NSPoint thePoint;

    thePoint = [[mainView window] mouseLocationOutsideOfEventStream];
    thePoint.x-= KB_SCREENWIDTH/2.0;
    thePoint.x*= mouseScale;
	
    if (thePoint.x>KB_SCREENWIDTH/2.0-frameSize.width/2.0)
      [self setFrameOrigin:NSMakePoint(KB_SCREENWIDTH/2.0-frameSize.width/2.0, y)];
    else if (thePoint.x<-KB_SCREENWIDTH/2.0+frameSize.width/2.0)
      [self setFrameOrigin:NSMakePoint(-KB_SCREENWIDTH/2.0+frameSize.width/2.0, y)];
    else {
	  float		diff= x-thePoint.x;
	  
      //the following is done to prevent missing a collision.
	  //problems occur when objects travel at too high of speed.
      if (fabs(diff) > (PAIL_WIDTH))
        [self setFrameOrigin:NSMakePoint(x-(PAIL_WIDTH)*((diff)/fabs(diff)), y)];
	  else
        [self setFrameOrigin:NSMakePoint(thePoint.x, y)];
	}
  }
  
  return self;
} /*calcDxDy:*/



- moveLeft
{
  [self moveStop];
  rotation= LEFT;
  
  return self;
} /*moveLeft*/



- moveRight
{
  [self moveStop];
  rotation= RIGHT;
  
  return self;
} /*moveRight*/



- moveStop
{
  rotation= STRAIGHT;
  xv= 0;
  theta= 0;
  
  return self;
} /*moveStop*/



- stopMoveLeft
{
  if (rotation == LEFT) rotation= STRAIGHT;
  
  return self;
} /*stopMoveLeft*/



- stopMoveRight
{
  if (rotation == RIGHT) rotation= STRAIGHT;
  
  return self;
} /*stopMoveRight*/



- setMouseAsInput: (BOOL) mode
{
  mouseAsInput= mode;
  return self;
} /*setMouseAsInput:*/



- setMouseScale: (float) newMouseScale
{
  mouseScale= newMouseScale;
  return self;
} /*setMouseScale:*/



- performCollisionWith:(Actor *) theActor
{
  return self;
} /*performCollisionWith:*/
@end
