/*  
 * 
 * KB_InfoText.m	-- An actor for displaying the game's logo as a title.
 * 
 * 
 * You may freely copy, distribute, and reuse the code in this example.
 * The author disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 *
 * Written by Mark G. Tacchi, mtacchi@next.com
 *
 * Wed Jul 27 1994
 */

#import "ActorMgr.h"
#import "KaBLAMDefs.h"
#import "KB_InfoText.h"
#import "KaBLAM.h"
#import "SoundMgr.h"
#import "Actor.h"


@implementation KB_InfoText
- activate:sender :(int)tag
{
  NSSize tSize = {313,258};
  NSSize tsizeByTwo = {156.5,129};

  [super activate:sender :tag];
  [self reinitWithImage:@"kb_infoText"
		frameSize:&tSize
		numFrames:1
		shape: RECT
		alliance: EVIL
		radius: 0.0
		buffered: YES
		x: 0.0
		y: 0.0
		theta: 0.0
		vel: 0.0
		interval: 250
		distToCorner: &tsizeByTwo];
		
  expireTime= timeInMS + 15000;

  return self;
} /*activate::*/



- positionChanged
{
  if (timeInMS>expireTime) {
	[actorMgr requestLevel: 2];
    [actorMgr destroyActor:self];
  } /*endif*/
  
  [super positionChanged];
  
  return self;
} /*positionChanged*/



- calcDxDy:(NSPoint *)dp
{
  xv= 0;
  yv= 0;
  [super calcDxDy: dp];
  
  return self;
} /*calcDxDy:*/



- performCollisionWith:(Actor *) theActor
{
  return self;
} /*performCollisionWith:*/

@end
