/*  
 * 
 * KB_InfoBomberHand.m	-- An actor to control movement of the bomber's hand
 *                         in the introduction screen.
 * 
 * 
 * You may freely copy, distribute, and reuse the code in this example.
 * The author disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 *
 * Written by Mark G. Tacchi, mtacchi@next.com
 *
 * Wed Jul 27 1994
 */

#import "ActorMgr.h"
#import "KaBLAMDefs.h"
#import "KB_InfoBomberHand.h"
#import "KB_InfoBomber.h"
#import "SoundMgr.h"
#import "Actor.h"

#define MAX_PROVOKE		6

@implementation KB_InfoBomberHand
- activate:sender :(int)tag
{
  NSSize tSize = {39,26};
  NSSize tsizeByTwo = {19.5,13};

  [super activate:sender :tag];
  [self reinitWithImage:@"kb_infoBomberHand"
		frameSize:&tSize
		numFrames:1
		shape: RECT
		alliance: NEUTRAL
		radius: 0.0
		buffered: YES
		x: - INFOBOMBER_HALF_WIDTH + tsizeByTwo.width + 2
		y: - INFOBOMBER_HALF_HEIGHT + 5
		theta: 0.0
		vel: 0.0
		interval: 500
		distToCorner: &tsizeByTwo];
		  
  xv= 0;	yv= 0;
  performBird= NO;
  provoke= 0;
  
  return self;
} /*activate::*/



- provoke
{
  if (++provoke> MAX_PROVOKE) {
    [self performBird];
	provoke= 0;
  } /*endif*/
  
  return self;
} /*provokeMe*/



- performBird
{
  performBird= YES;
  numFrames= 4;
  [soundMgr playSound: kb_slideWhistleSnd at:0.5];
  
  return self;
} /*performBird*/



- positionChanged
{
  if (performBird && frame>=3) {
    numFrames= 1;
	performBird= NO;
  } /*endif*/
  
  [super positionChanged];

  return self;
} /*positionChanged*/



- performCollisionWith:(Actor *) theActor
{
  return self;
} /*performCollisionWith:*/

@end
