/*  
 * 
 * KB_InfoBomb.m	-- An actor for displaying and controlling the bombs
 *                         in the introduction screen.
 * 
 * 
 * You may freely copy, distribute, and reuse the code in this example.
 * The author disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 *
 * Written by Mark G. Tacchi, mtacchi@next.com
 *
 * Wed Jul 27 1994
 */

#import "ActorMgr.h"
#import "KaBLAMDefs.h"
#import "KB_InfoBomb.h"
#import "SoundMgr.h"
#import "Actor.h"


@implementation KB_InfoBomb
- activate:sender :(int)tag
{
  NSSize tsize= {25,36};
  NSSize tsizeByTwo= {12.5,18};

  [super activate:sender :tag];
  [self reinitWithImage:@"kb_bomb"
		frameSize:&tsize
		numFrames:2
		shape: RECT
		alliance: GOOD
		radius: 0.0
		buffered: YES
		x: randBetween(1,4)
		y: randBetween(1,4)
		theta: randBetween(0, 2 * PI)
		vel: 0
		interval: randBetween(10,25)
		distToCorner: &tsizeByTwo];
		
  vr= -randBetween(0.2,1);	//radial
  vt= randBetween(18,25);	//tangential
  
  beginTime= timeInMS + tag * 500;
  expireTime= beginTime + 15000;
  return self;
} /*activate::*/



- positionChanged
{
  [self bounceAtDistance: (xOffset-distToCorner.width)
			:(yOffset-distToCorner.height)];
  [super positionChanged];
  
  return self;
} /*positionChanged*/



- calcDxDy:(NSPoint *)dp
{
  if (timeInMS>beginTime) {
    theta= atan2 (y,x);
    xv= cos(theta)*vr - sin(theta)*vt;
    yv= sin(theta)*vr + cos(theta)*vt;
  
    dp->y= timeScale * yv;
    dp->x= timeScale * xv;
	
	if (timeInMS>expireTime) {
      [actorMgr newActor:xx_explosion for:self tag:1];
      [actorMgr destroyActor:self];
	} /*endif*/
  }
  else {
    xv= 0;
	yv= 0;
	[super calcDxDy: dp];
  }
  
  
  return self;
} /*calcDxDy:*/



- performCollisionWith:(Actor *) theActor
{
  if (theActor->actorType == kb_infoText) {	
    [actorMgr newActor:xx_explosion for:self tag:1];
    [actorMgr destroyActor:self];
  }
  else
    [self bounceOff:theActor];
	
  return self;
} /*performCollisionWith:*/

@end
