/*  
 * 
 * KB_GameOver.m	-- An actor used to notify the user when the game is over.
 * 
 * 
 * You may freely copy, distribute, and reuse the code in this example.
 * The author disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 *
 * Written by Mark G. Tacchi, mtacchi@next.com
 *
 * Wed Jul 27 1994
 */

#import "ActorMgr.h"
#import "KaBLAMDefs.h"
#import "KB_GameOver.h"
#import "SoundMgr.h"
#import "Actor.h"


@implementation KB_GameOver
- activate:sender :(int)tag
{
  NSSize tSize = {478,70};
  NSSize t10 = {239,35};

  [super activate:sender :tag];
  [self reinitWithImage:@"kb_gameOver"
		frameSize:&tSize
		numFrames:1
		shape: RECT
		alliance: NEUTRAL
		radius: 0.0
		buffered: YES
		x: 0.0
		y: 0.0
		theta: 0.0
		vel: 0.0
		interval: 200
		distToCorner: &t10];
		
  playSndAtTime= timeInMS + 600;
  expireTime= playSndAtTime + 10000;
  xv= 0;	yv= 0;
  
  return self;
} /*activate::*/



- calcDxDy:(NSPoint *)dp
{
  if (timeInMS > playSndAtTime && playSndAtTime!=0) {
    [soundMgr playSound: kb_gameOverSnd at:0.5];
	playSndAtTime= 0;
  }
  if (timeInMS > expireTime) [actorMgr requestLevel: 0];
  
  [super calcDxDy: dp];
  return self;
} /*calcDxDy:*/



- performCollisionWith:(Actor *) theActor
{
  return self;
} /*performCollisionWith:*/

@end
